/*
 * File          : mouse_b.C
 * Author        : Peter Kulek
 * Compuserve ID : 100140,1220
 * Date          : $Date:   Jan 1989 $
 * Revision      : $Revision:   Jun 1993  $
 * 
 * This function is an original work by Peter Kulek and is placed in the
 * public domain.
 *
 * Needs MSC Ver 6 to recompile
 *
 * Modification history:
 * ---------------------
 *
 */



#include "extend.h"
#include "fm.api"
#include "mouse.h"

//------------------------------------------------------------------------------
// return current horz mouse pos
CLIPPER m_x() {
    int pos = -1 ; //return error if no mouse
    byte mode = *(byte far *)0x00400049; //Get video mode
    IF (_IsMouse()) 
        ASMSTART   // Get a Mouse Button status & position
            mov  AX,3
            int  51
            mov pos,cx
        ASMEND
        IF (mode == 7 || mode == 3)
            pos = GraphToText(pos);
        ENDIF
    ENDIF
    _retni(pos);
}
//------------------------------------------------------------------------------
// return current vertical mouse pos
CLIPPER m_y() {
    int pos = -1 ; //return error if no mouse
    byte mode = *(byte far *)0x00400049; //Get video mode
    IF (_IsMouse()) 
        ASMSTART   // Get a Mouse Button status & position
            mov  AX,3
            int  51
            mov pos,dx
        ASMEND
        IF (mode == 7 || mode == 3)
            pos = GraphToText(pos);
        ENDIF
    ENDIF
    _retni(pos);
}
//-----------------------------------------------------------------------------
// move mouse cursor to new pos M_MOVE(x,y)
CLIPPER M_Move() {
    IF ( _IsMouse() && ISNUM(1) && ISNUM(2) ) 
        int x = _parni(1) ;
        int y = _parni(2) ;
        byte mode = *(byte far *)0x00400049;
        IF (mode == 7 || mode == 3)
             x = TextToGraph(x);
             y = TextToGraph(y);
        ENDIF
        ASMSTART
            mov AX,4
            mov CX,x
            mov DX,y
            int 51
        ASMEND
    ENDIF    
    _ret();
}
//-------------------------------------------------------------------------------
// show cursor
CLIPPER M_Show() {
   IF (_IsMouse()) 
       ASMSTART
            mov AX,1
            int 51
       ASMEND
   ENDIF    
   _ret();
}
//-------------------------------------------------------------------------------
// hide cursor
CLIPPER M_Hide() {
   IF (_IsMouse()) 
       ASMSTART
           mov AX,2
           int 51
       ASMEND
   ENDIF
   _ret();
}
//-------------------------------------------------------------------------------
// change cursur in graphics mode
CLIPPER M_CurGph() {
    IF ( _IsMouse() && ISNUM(1) && ISNUM(2) && ISCHAR(3) ) 
        int hot_spot_x = _parni(1);
        int hot_spot_y = _parni(2);
        unsigned *mask  = (unsigned *)(_parc(3)) ;
        int segm    = FP_SEG(mask);
        int offs    = FP_OFF(mask);
        ASMSTART
            mov AX,segm
            mov ES,AX
            mov DX,offs
            mov AX,9
            mov BX,hot_spot_x
            mov CX,hot_spot_y
            int 51
        ASMEND
    ENDIF
    _ret();
}
//-------------------------------------------------------------------------------
// change cursur in text mode
CLIPPER M_CurTxt() {
    IF ( _IsMouse() && ISNUM(1) && ISNUM(2) ) 
        int ScreenMask = _parni(1);
        int CursorMask = _parni(2);
        int CursorType = ( ISNUM(3) ? _parni(3) : 0); //default to Software Cursor
        ASMSTART
             mov AX,10
             mov BX,CursorType
             mov CX,ScreenMask
             mov DX,CursorMask
             int 51
        ASMEND
    ENDIF
    _ret();
}
//-------------------------------------------------------------------------------
// restrict mouse movement to area
CLIPPER M_AreaSet()  {
    byte mode = *(byte far *)0x00400049;
    IF ( _IsMouse() && ISNUM(1) && ISNUM(2) && ISNUM(3) && ISNUM(4) ) 
        int y      = _parni(1) ;
        int x      = _parni(2) ;
        int y2     = _parni(3) ;
        int x2     = _parni(4) ;
        IF (mode == 7 || mode == 3)
             x  = TextToGraph(x);
             y  = TextToGraph(y);
             x2 = TextToGraph(x2);
             y2 = TextToGraph(y2);
        ENDIF
        ASMSTART
             mov AX,7
             mov CX,x
             mov DX,x2
             int 51
             mov AX,8
             mov CX,y
             mov DX,y2
             int 51
        ASMEND
    ENDIF
    _ret();
}
//-------------------------------------------------------------------------------
// hide cursor when in area of screen use M_show() to redisplay
CLIPPER M_AreaHide() {
    byte mode = *(byte far *)0x00400049;
    IF ( _IsMouse() && ISNUM(1) && ISNUM(2) && ISNUM(3) && ISNUM(4) ) 
        int y   = _parni(1) ;
        int x   = _parni(2) ;
        int y2  = _parni(3) ;
        int x2  = _parni(4) ;
        IF (mode == 7 || mode == 3)
             x  = TextToGraph(x);
             y  = TextToGraph(y);
             x2 = TextToGraph(x2);
             y2 = TextToGraph(y2);
        ENDIF
       ASMSTART
            mov AX,16
            mov CX,x
            mov DX,y
            mov SI,x2
            mov DI,y2
            int 51
       ASMEND
    ENDIF
    _ret();
}
//-------------------------------------------------------------------------------
// set mouse mickeys and speed threshold
CLIPPER M_Config() {
   IF ( _IsMouse() && ISNUM(1) && ISNUM(2) && ISNUM(3) ) 
      int xmickey              = _parni(1) ;
      int ymickey              = _parni(2) ;
      int DoubleSpeedThreshold = _parni(3) ;
      ASMSTART
           mov AX,26
           mov BX,xmickey
           mov CX,ymickey
           mov DX,DoubleSpeedThreshold
           int 51
      ASMEND
   ENDIF
   _ret();
}
//-------------------------------------------------------------------------------
// restrict mouse movement to area
CLIPPER M_Speed() {
   IF ( _IsMouse() && ISNUM(1) && ISNUM(2)  ) 
      int y = ( ISNUM(1) ? _parni(1) : 32 ) ;
      int x = ( ISNUM(2) ? _parni(2) : 16 ) ;
      ASMSTART        
           mov AX,15   
           mov CX,x   
           mov DX,y   
           int 51
      ASMEND
   ENDIF   
   _ret();
}
//-------------------------------------------------------------------------------
// set mouse speed 
CLIPPER M_Motion() {
      int threshold = ( ISNUM(1) ? _parni(1) : 64 ) ;
      ASMSTART        
           mov AX,19
           mov DX,threshold   
           int 51
      ASMEND
   _ret();
}



