/*
 * File          : mouse_a.C
 * Author        : Peter Kulek
 * Compuserve ID : 100140,1220
 * Date          : $Date:   Jan 1989 $
 * Revision      : $Revision:   Jun 1993  $
 * 
 * This function is an original work by Peter Kulek and is placed in the
 * public domain.
 *
 * Needs MSC Ver 6 to recompile
 *
 * Modification history:
 * ---------------------
 *
 */



#include "extend.h"
#include "fm.api"
#include "mouse.h"

// *  static data
static int            IsMouse = FALSE;
static EVE * pEve;
static short          lastX  = 0,
                      lastY  = 0;
static BOOL           installed = FALSE ;
static LastArea = 0;               
static CurArea  = 0;               
static int             x1[MAXEVENT]   ;               
static int             x2[MAXEVENT]   ;               
static int             y1[MAXEVENT]   ;               
static int             y2[MAXEVENT]   ;               
static unsigned long mask[MAXEVENT] ;               
static int           hotx[MAXEVENT] ;               
static int           hoty[MAXEVENT] ;               

//------------------------------------------------------------------------------
/*  $DOC$
 *  $FUNCNAME$
 *     M_INIT()
 *  $CATEGORY$
 *     Keyboard/Mouse
 *  $ONELINER$
 *     Make Mouse Ready 
 *  $SYNTAX$
 *     M_INIT() -> lOk
 *  $ARGUMENTS$
 *     None
 *  $RETURNS$
 *     .T. if Mouse driver installed and mouse connected
 *  $DESCRIPTION$
 *     This function check whether a mouse is connected and 
 *     initialises all data
 *  $EXAMPLES$
 *     IF M_INIT()
 *        // code 
 *     ELSE
 *        alert(' Sorry Mouse Not Ready;or; Not Installed')
 *     ENDIF
 *  $SEEALSO$
 *     M_HIDE() M_SHOW()
 *  $END$
 */
CLIPPER M_Init() {
   byte far *vectfunct ;
   IF(IsMouse) 
       FREE(pEve);
   ENDIF
   IsMouse = FALSE;
   pEve = (EVE *) MALLOC( sizeof(EVE) ); // Allocate some memory
   // Get Some Video Information
   pEve->mode     = *(byte far *)0x00400049;
   pEve->numrows  = *(byte far *)0x00400084 ;
   pEve->numrows ++ ;
   pEve->numcols  = *(byte far *)0x0040004A;
   pEve->cheight  = *(byte far *)0x00400085;
   pEve->textmode = FALSE ;
   IF (pEve->mode == 7 || pEve->mode == 3)
       pEve->textmode = TRUE ;
   ENDIF    
   // Check to see if mouse installed
   vectfunct = (byte *) _getvector(0x33);
   IF (vectfunct != 0  &&  *vectfunct != 0xCF)
       // initialise mouse
       ASMSTART
           mov AX,33
           int 51
           mov IsMouse,AX
       ASMEND
   ENDIF
   pEve->shift     = PEEK_SHIFT ;    // Get shift status
   pEve->exshift   = PEEK_EXTSHIFT ; // Get extended shift status
   pEve->startTime = PEEK_TIME ;     // Get Dos time as long
   pEve->CurArea   = 0 ;
   IF( ! IsMouse) 
       FREE(pEve); // Free memory
   ENDIF
   _retl(IsMouse) ;
}
//-------------------------------------------------------------------------------
/*  $DOC$
 *  $FUNCNAME$
 *     M_ISMOUSE()
 *  $CATEGORY$
 *     Keyboard/Mouse
 *  $ONELINER$
 *     Checks if Mouse Initialised 
 *  $SYNTAX$
 *     M_ISMOUSE() -> lOk
 *  $ARGUMENTS$
 *     None
 *  $RETURNS$
 *     .T. if Mouse driver installed and initialised
 *  $DESCRIPTION$
 *     This function check whether a mouse is ready
 *  $EXAMPLES$
 *     IF M_ISMOUSE()
 *        // Do code 
 *     ELSE
 *        // Do something else
 *     ENDIF
 *  $SEEALSO$
 *     M_END() M_HIDE() M_SHOW()
 *  $END$
 */
CLIPPER M_IsMouse() {
    _retl(IsMouse) ;
}
//-------------------------------------------------------------------------------
/*  $DOC$
 *  $FUNCNAME$
 *     M_EVECHECK()
 *  $CATEGORY$
 *     Keyboard/Mouse
 *  $ONELINER$
 *     Checks a mouse, keyboard or time event from modal operation
 *  $SYNTAX$
 *     M_EVECHK(nEvent) -> lOk
 *  $ARGUMENTS$
 *     nEvent event to check
 *  $RETURNS$
 *     .T. if event occured
 *  $DESCRIPTION$
 *     This function checks for an event from the mouse, timer 
 *     or keyboard
 *  $EXAMPLES$
 *     #include 'mouse.ch' //constants for events
 *     if M_EVECHK(CHK_PRESS)
 *         ? 'Key 1 Pressed '
 *     endif
 *  $SEEALSO$
 *     M_EVEMODAL() M_REGNNEW()
 *  $END$
 */
CLIPPER m_EveChk() {
   int iType = ISNUM(1) ? _parni(1) : 0 ;
       switch( iType ) {
           case 0:
              _ret();
              break;
           case CHK_KEYBOARD:
              _retl(pEve->event & (1<<EVE_KEYBOARD))     ;
              break;
           case CHK_XPOS:
              _retni(pEve->x)    ;
              break;
           case CHK_YPOS:
              _retni(pEve->y)     ;
              break;
           case CHK_PRESS1:
              _retl(pEve->MEvent & (1<<MEVENT_PRESS1))     ;
              break;
           case CHK_PRESS2:
              _retl(pEve->MEvent & (1<<MEVENT_PRESS2))     ;
              break;
           case CHK_PRESS1AND2:
              _retl( (pEve->MEvent & (1<<MEVENT_PRESS1)) && (pEve->MEvent & (1<<MEVENT_PRESS2)))     ;
              break;
           case CHK_RELEASE1:
              _retl(pEve->MEvent & (1<<MEVENT_RELEASE1))     ;
              break;
           case CHK_RELEASE2:
              _retl(pEve->MEvent & (1<<MEVENT_RELEASE2))     ;
              break;
           case CHK_RELEASE1AND2:
              _retl( (pEve->MEvent & (1<<MEVENT_RELEASE1)) && (pEve->MEvent & (1<<MEVENT_RELEASE2)) )     ;
              break;
           case CHK_SCANCODE:
              _retni(pEve->scan)  ;  
              break;
           case CHK_ASCIICODE:
              _retni(pEve->scan & 0x00ff)     ;   //Asc
              break;
           case CHK_EXTENDCODE:
              _retni(pEve->scan >> 8)  ;  //Extended Code
              break;
           case CHK_TIMEOUT:
              _retl(pEve->event & (1<< EVE_TIMER))     ;
              break;
           case CHK_MMOVE:
              _retl(pEve->MEvent & (1<<MEVENT_MOVE))     ;
              break;
           case CHK_SHIFTKEYR:
              _retl(pEve->shift & (1<<SHIFT_SHIFTKEYR))     ;
              break;
           case CHK_SHIFTKEYL:
              _retl(pEve->shift & (1<<SHIFT_SHIFTKEYL))     ;
              break;
           case CHK_SHIFTKEY:
              _retl( (pEve->shift & (1<<SHIFT_SHIFTKEYR)) || (pEve->shift & (1<<SHIFT_SHIFTKEYL)) )     ;
              break;
           case CHK_CTRLKEY:
              _retl(pEve->shift & (1<<SHIFT_CTRLKEY))     ;
              break;
           case CHK_ALTKEY:
              _retl(pEve->shift & (1<<SHIFT_ALTKEY))     ;
              break;
           case CHK_SCROLLOCK:
              _retl(pEve->shift & (1<<SHIFT_SCROLLOCK))     ;
              break;
           case CHK_NUMLOCK:
              _retl(pEve->shift & (1<<SHIFT_NUMLOCK))     ;
              break;
           case CHK_CAPSLOCK:
              _retl(pEve->shift & (1<<SHIFT_CAPSLOCK))     ;
              break;
           case CHK_INSERT:
              _retl(pEve->shift & (1<<SHIFT_INSERT))     ;
              break;
           case CHK_SYSREQ:
              _retl(pEve->exshift & (1<<EXSHIFT_SYSREQ))     ;
              break;
           case CHK_PAUSE:
              _retl(pEve->exshift & (1<<EXSHIFT_PAUSE))     ;
              break;
           case CHK_BREAK:
              _retl(pEve->exshift & (1<<EXSHIFT_BREAK))     ;
              break;
           case CHK_CURREGION:
              _retni(pEve->CurArea);
              break;
           case CHK_REGION:
              _retl(pEve->event & (1<<EVE_REGION))     ;
              break;
           case CHK_TIMER:
              _retnl(pEve->time)     ;
              break;
           case CHK_STARTTIME:
              _retnl(pEve->startTime);
              break;
           case CHK_EVENTFLAG:
              _retnl(pEve->event)   ;
              break;
           case CHK_NUMROWS:
              _retni(pEve->numrows)     ;
              break;
           case CHK_NUMCOLS:
              _retni(pEve->numcols)     ;
              break;
           case CHK_CHEIGHT:
              _retni(pEve->cheight)     ;
              break;
        }
        _ret();
}
//-------------------------------------------------------------------------------
/*  $DOC$
 *  $FUNCNAME$
 *     M_END()
 *  $CATEGORY$
 *     Keyboard/Mouse
 *  $ONELINER$
 *     Closes mouse buffers 
 *  $SYNTAX$
 *     M_END(nEvent)
 *  $ARGUMENTS$
 *     None
 *  $RETURNS$
 *     None
 *  $DESCRIPTION$
 *     This closes mouse use. This must be called before quiting the 
 *     program otherwise your machine will blow up.
 *  $EXAMPLES$
 *     if M_INIT()
 *         // code
 *     endif
 *     M_END()
 *  $SEEALSO$
 *     M_INIT()
 *  $END$
 */
CLIPPER M_End() {
   ASMSTART        
        mov AX,2    // Hide Mouse
        int 51
        xor AX,AX   // Reset
        int 51
   ASMEND
   // free any buffers
   FREE(pEve);
   IsMouse = FALSE ;
   _ret();
}
//-------------------------------------------------------------------------------
/*  $DOC$
 *  $FUNCNAME$
 *     M_REGNNEW() -> nRegion
 *  $CATEGORY$
 *     Keyboard/Mouse
 *  $ONELINER$
 *     Initialises an area of screen
 *  $SYNTAX$
 *     M_REGNNEW(nTop,nLeft,nBottom,nRight,nMask,nColor)
 *  $ARGUMENTS$
 *     nTop,nLeft,nBottom,nRight   screen coordinates   
 *     nMask   Cursor mask
 *     nColor  Cursor color 
 *  $RETURNS$
 *     numeric of region
 *  $DESCRIPTION$
 *     Initialises an area of screen that can have different cursor
 *     and color
 *  $EXAMPLES$
 *     M_INIT()
 *     nRegion :=  M_REGNNEW(0,0,10,10)
 *     do while .t.
 *         m_MODAL()
 *         if m_EveChk(CHK_REGION) = nRegion .and. m_EveChk(CHK_PRESS1)
 *             exit
 *         endif
 *     enddo
 *     M_END()
 *  $SEEALSO$
 *     M_INIT() M_MODAL() M_EVECHK()
 *  $END$
 */
CLIPPER M_RegnNew() {
// Set up a hot region
    _retni(0);
    IF ( IsMouse && (LastArea < MAXEVENT) && ISNUM(1) && ISNUM(2) && ISNUM(3) && ISNUM(4)  ) 
        int mask2 = ( ISNUM(5) ? _parni(5) : PTRSAMECHAR ) ;
        int mask1 = ( ISNUM(6) ? _parni(6) : PTRDIFCOLB(78) ) ;
        LastArea++ ;
        y1[LastArea]   = _parni(1) ;
        x1[LastArea]   = _parni(2) ;
        y2[LastArea]   = _parni(3) ;
        x2[LastArea]   = _parni(4) ;
        mask[LastArea] = MouPtrMask( mask1,mask2 )  ;
        pEve->CurArea  = LastArea ;
        _retni(LastArea);
    ENDIF
}
//-------------------------------------------------------------------------------
/*  $DOC$
 *  $FUNCNAME$
 *     M_EVEMODAL() -> nEventMask
 *  $CATEGORY$
 *     Keyboard/Mouse
 *  $ONELINER$
 *     Wait for a Mouse Keyboard Region or Time event
 *  $SYNTAX$
 *     M_REGNNEW(nDelay)
 *  $ARGUMENTS$
 *     nDelay  Delay for time out in clock ticks apx 18 per second
 *  $RETURNS$
 *     Event mask
 *  $DESCRIPTION$
 *     Wait for a Mouse Keyboard Region or Time event
 *  $EXAMPLES$
 *     M_INIT()
 *     do while .t.
 *         M_MODAL(500)  // timeout every 500 ticks
 *         if m_EveChk(CHK_TIMEOUT)
 *             exit
 *         endif
 *     enddo
 *     M_END()
 *  $SEEALSO$
 *     M_INIT() M_EVECHK()
 *  $END$
 */
CLIPPER M_EveModal() {
    uint scancode = 0 ;
    int x,y,button;
    int mask1 = PTRSAMECHAR ;
    int mask2 = PTRDIFCOLB(63)      ;
    pEve->event     = 0;
    pEve->scan      = 0;
    pEve->MEvent    = 0;
    pEve->startTime = PEEK_TIME ;
    IF( ISNUM(1) )
        pEve->time = _parni(1); // Set Time Out
    ENDIF
    while (1) {
        IF( pEve->time  && ( PEEK_TIME > (pEve->time + pEve->startTime)   ) )
            pEve->startTime  = PEEK_TIME ;
            pEve->event      = _SetBit(pEve->event, EVE_TIMER );
        ENDIF
        ASMSTART   // Get a Key stroke
            l01:    mov  AH,11h
                    int  16h
                    jz   nokey
                    mov  scancode,AX
                    mov  AH,0       //Clear buffer
                    int  16h
                    jmp  l01
            nokey:
        ASMEND
        IF( scancode )
            pEve->event = _SetBit(pEve->event,EVE_KEYBOARD) ;
        ENDIF
        IF ( IsMouse ) 
            ASMSTART   // Get a Mouse Button status & position
                mov  AX,3
                int  51
                mov  button,bx
                mov  x,cx
                mov  y,dx
            ASMEND
            IF( button & ( 1 << 0 ) ) 
                pEve->MEvent = _SetBit(pEve->MEvent,MEVENT_PRESS1) ;
                pEve->event  = _SetBit(pEve->event,EVE_MOUSE) ;
            ENDIF
            IF( button & ( 1 << 1 ) ) 
                pEve->MEvent = _SetBit(pEve->MEvent,MEVENT_PRESS2) ;
                pEve->event  = _SetBit(pEve->event,EVE_MOUSE) ;
            ENDIF
            IF (pEve->textmode) 
                pEve->x = GraphToText(x);
                pEve->y = GraphToText(y);
            ELSE
                pEve->x = x;
                pEve->y = y;
            ENDIF
            pEve->samepos = (bool)(pEve->x == lastX  &&  pEve->y == lastY) ;
            IF( ! pEve->samepos )
                pEve->CurArea = 0 ;
                x = LastArea;
                pEve->MEvent = _SetBit(pEve->MEvent,MEVENT_MOVE) ;
                pEve->event  = _SetBit(pEve->event,EVE_MOUSE) ;
                lastX   = pEve->x;
                lastY   = pEve->y;
                do { 
                    IF ( (lastX >= x1[x]) && (lastX <= x2[x]) && (lastY >=y1[x]) && (lastY <= y2[x]) )
                        mask1 = (int)mask[x] ;
                        mask2 = (int)mask[x] >> 16 ;
                        break ;
                    ENDIF
                    x -- ;
                } while ( x > 0 ) ;
                pEve->CurArea = x ;
                IF( pEve->lastarea != pEve->CurArea )
                    pEve->event    = _SetBit(pEve->event,EVE_REGION ) ;
                    pEve->lastarea = pEve->CurArea ;
                ENDIF    
                // Set Mouse Pointer Masks
                ASMSTART
                    mov AX,10
                    mov BX,0
                    mov CX,mask1
                    mov DX,mask2
                    int 51
                ASMEND
                // Get Mouse Button Release info
                ASMSTART
                    mov AX,6
                    mov BX,0  //Left button
                    int 51
                    mov x,BX     // no of releases since last call
                ASMEND
                IF(x)
                    pEve->MEvent = _SetBit(pEve->MEvent,MEVENT_RELEASE1 ) ;
                    pEve->event  = _SetBit(pEve->event,EVE_MOUSE) ;
                ENDIF
                ASMSTART
                    mov AX,6
                    mov BX,1  //Right button
                    int 51
                    mov x,BX     // no of releases since last call
                ASMEND
                IF(x)
                    pEve->MEvent = _SetBit(pEve->MEvent,MEVENT_RELEASE2 ) ;
                    pEve->event  = _SetBit(pEve->event,EVE_MOUSE) ;
                ENDIF
            ENDIF
        ENDIF
        IF ( pEve->event ) 
            break;
        ENDIF
    }
    pEve->shift   = PEEK_SHIFT ;
    pEve->exshift = PEEK_EXTSHIFT ;
    pEve->scan    = scancode  ;
    _retni(pEve->event);
}
//-------------------------------------------------------------------------------
// Used for external C calls
int _IsMouse(void) {
    return(IsMouse);
}




