    
/*
    Author Peter Kulek
    Compuserve ID 100140,1220
    
    Demonstration of mouse library for clipper 

*/

#include "mouse.ch"

local nRow := 0
local nCol := 0
local nRegn1,nRegn2,nRegn3,cScr
cls
if ! m_Init() // initialise mouse 
    alert('Sorry No Mouse Detected')
else
    nRegn1 := m_RegnNew(15 ,14 ,19,70 ) //Set Up A Region
    dispbox(  15 ,14,19,70)         // and put a box round it
    nRegn2 := m_RegnNew(20 ,14 ,24,70 ) 
    dispbox(  20 ,14,24,70)         
    nRegn3 := m_RegnNew(15 ,0 ,24,13 ) 
    @ 17,16 say 'Click Left Button In This Box or Press Esc to Exit '
    @ 22,16 say 'Click Right Button In This Box or Press Esc to Exit '
    m_show() //Show Mouse
    do while .t. 
        M_EveModal(10) // Wait For An Event  times out after 10 ticks
        nRow := 0
        nCol := 0
        m_areaHide(00,00,14,79)
        @ nRow++,nCol say 'Current X Pos     ' + transform(m_x(),'###')
        @ nRow++,nCol say 'Current Y Pos     ' + transform(m_y(),'###')
        @ nRow++,nCol say 'Mouse Moved       ' + transform(m_EveChk(CHK_MMOVE),'Y' )
        @ nRow++,nCol say 'But 1 Pressed     ' + transform(m_EveChk(CHK_PRESS1),'Y')
        @ nRow++,nCol say 'But 2 Pressed     ' + transform(m_EveChk(CHK_PRESS2),'Y')
        @ nRow++,nCol say 'But 1 & 2 Pressed ' + transform(m_EveChk(CHK_PRESS1AND2),'Y')
        @ nRow++,nCol say 'But 1 Release     ' + transform(m_EveChk(CHK_RELEASE1),'Y' )
        @ nRow++,nCol say 'But 2 Release     ' + transform(m_EveChk(CHK_RELEASE2),'Y' )
        @ nRow++,nCol say 'But 1 & 2 Release ' + transform(m_EveChk(CHK_RELEASE1AND2),'Y' )
        @ nRow++,nCol say 'Region Mouse In      ' + transform(m_EveChk(CHK_CURREGION),'###')
        @ nRow++,nCol say 'Crossed Region       ' + transform(m_EveChk(CHK_REGION),'Y')
        @ nRow++,nCol say 'Time Out          ' + transform(m_EveChk(CHK_TIMEOUT),'Y')
        nRow := 0
        nCol := 40
        @ nRow++,nCol say 'Keyboard Scan Code   ' + transform(m_EveChk(CHK_SCANCODE),'######')
        @ nRow++,nCol say 'Keyboard Ascii Code  ' + transform(m_EveChk(CHK_ASCIICODE),'######')+if(!empty(m_evechk(CHK_ASCIICODE)) ,' = '+chr(m_evechk(CHK_ASCIICODE)),'    ')
        @ nRow++,nCol say 'Keyboard Extend Code ' + transform(m_EveChk(CHK_EXTENDCODE),'######')
        @ nRow++,nCol say 'Right Shift Key      ' + transform(m_EveChk(CHK_SHIFTKEYR),'Y')
        @ nRow++,nCol say 'Left Shift Key       ' + transform(m_EveChk(CHK_SHIFTKEYL),'Y')
        @ nRow++,nCol say 'Shift Key            ' + transform(m_EveChk(CHK_SHIFTKEY),'Y')
        @ nRow++,nCol say 'Ctrl Key             ' + transform(m_EveChk(CHK_CTRLKEY),'Y')
        @ nRow++,nCol say 'Alt Key              ' + transform(m_EveChk(CHK_ALTKEY),'Y')
        @ nRow++,nCol say 'Scroll Lock          ' + transform(m_EveChk(CHK_SCROLLOCK),'Y')
        @ nRow++,nCol say 'Num Lock             ' + transform(m_EveChk(CHK_NUMLOCK),'Y')
        @ nRow++,nCol say 'Caps Lock            ' + transform(m_EveChk(CHK_CAPSLOCK),'Y')
        @ nRow++,nCol say 'Insert               ' + transform(m_EveChk(CHK_INSERT),'Y')
        if m_eveChk(CHK_CURREGION)==nRegn3
            m_hide()
            cScr := savescreen(15 ,0 ,24,13 ) 
            dispbox(15,0,24,13)
            @ 17,2 say 'Hidden '
            @ 18,2 say 'Region '
            m_show()
            do while  m_x() >=0 .and. m_x()<=13 .and. m_y()>=15.and. m_y()<=24
            enddo
            m_hide()
            restscreen(15 ,0 ,24,13,cScr ) 
            m_show()
        endif
        if m_EveChk(CHK_ASCIICODE) = 27;
            .or. (m_eveChk(CHK_CURREGION)==nRegn1.and.m_evechk(CHK_PRESS1));
            .or. (m_eveChk(CHK_CURREGION)==nRegn2.and.m_evechk(CHK_PRESS2))
            exit
        endif
        m_show() //Show Mouse
    enddo
   	m_end()
endif









