*!*********************************************************************
*!
*!       Function: W_LOOKUP()
*!
*!*********************************************************************
FUNCTION w_lookup
* Performs lookups on databases.  This version used only 2 fields, the code and
* the meaning of the code.  The bottom row of the window is 20 and the help is
* on lines 21 to 23.  Meanings of the type codes are: N=Numeric; E=expression or
*    variable or string; L=logical.
* Parameters: wn (N) - the window number
*             t - (N) - top row of window
*             l - (N) - left column of the window
*             colr - (E) - color attribute of the window (e.g. w/b)
*             area - (letter or E) - area where the lookup file is
*             gfld - (E) - the field in the lookup table to get
*             sfld - (E) - the field with the code description
*             shd - (L) - whether to call sbox or not
*             wbrdr - (N or E) - 1 - 8 for predefined borders or your own
*             wtit - (E) - a title to be centered on top row of window
*             mkey - (E) - a variable (not literal) to seek on (optional)
*             cond - (E) - a condition to do while .t. (allows lookups on subset of dbfs)
* Syntax: mcode = w_lookup(<wn>, <t>, <l>, <colr>, <area>, <gfld>, <sfld>, <shd>, <wbrdr>, <wtit>, <mkey> <cond>)
*     or: replace filevar with w_lookup(<wn, <t>, <l>, <colr>, <area>, <gfld>, <showfield>, <shd>, <wbrdr>, <wtit>, <mkey> <cond>)
* Notes:  All parameters up to and includeing <shd> are required.  Others are optional.
*         If a seek is to be done make sure an index is open in the seek area.  Otherwise
*         a locate will be done.

PARAMETER wn, t, l, colr, area, gfld, sfld, shd, wbrdr, wtit, mkey, cond
STORE ALIAS() TO currarea      && save the origional area
SELECT &area                   && select the lookup table

*** make sure all variables are accounted for
if type("wbrdr") = 'U'
   wbrdr = 1
endif
if type("wtit") = 'U'
   wtit = ""
endif
if type("mkey")="U"
   mkey = ""
   makecond = "1 = 1"
   cond = makecond
endif

if mkey == ""
   GO BOTTOM
   lastrec = RECNO()
   GO TOP
   firstrec = RECNO()
else
   if indexord() = 0
      locate for cond
   else
      seek &mkey
   endif
   if eof()
      return " "
   endif
   firstrec = recno()
   do while &cond
      skip
   enddo
   skip -1
   lastrec = recno()
endif

mlastkey = 0
eof_flag = .F.
t = IIF(t < 3, 3, t)
b = 20
r = l + LEN(&gfld) + LEN(&sfld) + 6
   
if wtit == ""
  w_draw(wn, t, l, b, r, (colr), shd, wbrdr)
else
  w_draw(wn, t, l, b, r, (colr), shd, wbrdr, wtit)
endif

**** save what is under the help box and draw it ****
oldbox = savescreen(0, 4, 3, 76)   && make it bigger for shd box
dbox(0, 4, 2, 75, 1, shd)
@1, 6 SAY "Press , , PgUp, PgDn, Home or End to move cursor.  Enter to exit."

w_height = b - t - 1    && calculate # rows in window
finished = .F.                && now work within the window
goto firstrec

DO WHILE .NOT. finished
   w_fill(wn, " ")         && clear the box
   lk_line = 1
   
   **** display one windows worth of information ****
   DO WHILE lk_line <= w_height .and. iif(mkey = "", 1 = 1, &cond)
      eof_flag = .F.
      @w_row(wn, lk_line),w_col(wn, 2) SAY &gfld+'  '+&sfld
      lk_line = lk_line + 1
      SKIP
      
      IF EOF()          && get out if end of file
         eof_flag = .T.
         EXIT
      ENDIF
      if mkey = ""
         if .not. &cond
            eof_flag = .t.
            exit
         endif
      endif
      
   ENDDO
   
   sb = RECNO()                                  && save record at bottom of screen
   IF mlastkey != endkey                         && end key was not pressed
      SKIP -(lk_line - 1)                         && skip back to top of screen
      lk_line = 1
      @w_row(wn, 1),w_col(wn, 2) GET &gfld  && hilite the first record in box
      @w_row(wn, 1), COL()+2 SAY &sfld       && show what it means
   ELSE                                          && end key was pressed.
      SKIP - 1                                    && get off end of file
      lk_line = lk_line - 1
      @w_row(wn, lk_line), w_col(wn, 2) GET &gfld
      @w_row(wn, lk_line), COL()+2 SAY &sfld
   ENDIF
   CLEAR GETS
   
   **** get a key and react accordingly ****
   action = .T.
   DO WHILE action
      mlastkey = INKEY(0)       && pause for a key press
      DO CASE
         
      CASE mlastkey = dnarrow
         IF RECNO() = lastrec                     && beep if end of file
            eof_flag = .T.
            ??CHR(7)
         ELSE
            lk_line = lk_line + 1                                               && increment row
            IF lk_line > w_height                                               && oops.  went past window but !eof
               lk_line = w_height                                               && keep lk_line at screen bottom
               @w_row(wn, w_height), w_col(wn, 2) SAY &gfld               && unhilite last record
               SKIP                                                             && get next record
               sb = RECNO()                                                     && hold record number
               w_scroll(wn, 1)                                                && scroll 1 line
               @w_row(wn, lk_line), w_col(wn, 2) SAY &gfld+'  '+&sfld  && display new record
            ELSE                                                                && still within the window area
               @w_row(wn, lk_line - 1), w_col(wn, 2) SAY &gfld            && unhilite last record
               SKIP                                                             && skip to next record
            ENDIF
            @w_row(wn, lk_line),w_col(wn, 2) GET &gfld                    && hilite new record
            CLEAR GETS
         ENDIF
         
      CASE mlastkey = uparrow
         IF RECNO() = firstrec                    && already at file beginning
            ??CHR(7)
         ELSE
            lk_line = lk_line - 1
            IF lk_line < 1                                 && went past top of window but !eof
               lk_line = 1
               @w_row(wn, 1),w_col(wn, 2) SAY &gfld
               SKIP - 1
               sb = RECNO()
               w_scroll(wn, -1)
               @w_row(wn, 1), w_col(wn, 2) SAY &gfld+'  '+&sfld
            ELSE                                            && still within window
               @w_row(wn, lk_line + 1), w_col(wn, 2) SAY &gfld
               SKIP - 1
            ENDIF
            @w_row(wn, lk_line), w_col(wn, 2) GET &gfld
            CLEAR GETS
         ENDIF
         
      CASE mlastkey = pgdn .AND. .NOT. eof_flag
         GOTO sb
         EXIT         && exit to display the new screen in routine at top.
         
      CASE mlastkey = pgup
         SKIP -lk_line          && skip to record at top of screen
         SKIP -(w_height - 1)
         if .not. &cond
            goto firstrec
         endif
         EXIT                   && exit to display new window area
         
      CASE mlastkey = homekey
         GO firstrec
         EXIT
         
      CASE mlastkey = endkey
         GO lastrec
         SKIP -(w_height - 1)
         if .not. &cond
            goto firstrec
         endif
         EXIT
         
      CASE mlastkey = ret_key
         finished = .T.
         EXIT
         
      OTHERWISE                 && invalid key
         ??CHR(7)
      ENDCASE
      
   ENDDO
   
ENDDO
mcode = &gfld                 && store contents of file variable
SELECT &currarea                && switch back to origional work area
restscreen(0, 4, 3, 76, oldbox) && restore what was under the help box
w_erase(wn)

RETURN(mcode)

