*:*********************************************************************
*:
*:        Program: WINDDEMO.PRG
*:
*:         System: Windowing System Demonstration
*:         Author: David Kanter
*:      Copyright (c) 1989, D & P Consulting
*:  Last modified: 04/06/89     17:46
*:
*:  Procs & Fncts: MPROMPT()
*:               : CTR()
*:
*:          Calls: WHEADER.PRG
*:               : MPROMPT()      (function  in WINDDEMO.PRG)
*:
*:           Uses: SMALFILE.DBF   
*:               : BIGFILE.DBF    
*:
*:        Indexes: BIGKEY.NDX
*:
*:      Documented 04/07/89 at 07:41                SNAP!  version 3.12e
*:*********************************************************************

******************************************************************************
* Demonstrates the use of the functions in WINDOW.LIB.  See the file WHEADER
* for needed public variables and arrays for borders, etc.  This file should
* be compiled with whatever programs you use WINDOW.LIB in.  This library and
* demonstration is in the public domain.  Source code is available by sending
* a registration fee of $25 to:
*
*     D & P Consulting
*     6103 Biltmore Ave.
*     Baltimore, MD  21215
*
* Registered users will be informed of updates which at this time will be sent
* at no charge provided you supply the disk and stamped floppy mailer.
*
* I apologize for the brevity of comments in this program.  I didn't think
* anyone would want to see elaborate comments, but rather study the code and
* use this program as a partial reference.
******************************************************************************

DO wheader WITH 3   && do this program first because it sets up public variables
                    ** to hold window information.
set cursor off

** makes a box of the whole screen with a blank border and title.
set color to n/bg
@ 0, 0, 24, 79 BOX ""

** makes a box at the top of screen with no shadow, double border, no title
SET COLOR TO (cwindow1)
DBOX(0, 0, 2, 79, 1, .f.)
ctr(1, "* * * Window Library Demonstration * * *")

** makes a box in middle of screen with shadow, double border, and no title
DBOX(8, 25, 15, 55, 1, .T.)
CTR(10, "Brought to you by:")
CTR(11, "D & P Consulting")
CTR(12, "6103 Biltmore Ave.")
CTR(13, "Baltimore, MD 21215")

SET COLOR TO (cnormal)
@ 23, 0 clear
mprompt("Press a key to begin")

** make a small window to demonstrate scrolling **
W_DRAW(1, 3, 3, 15, 20, (cwindow2), .T., 2, "WIndow 1")
FOR X = 1 TO 5
   var = "Line " + STR(X,1,0)
   @W_ROW(1, X + 2), W_COL(1, 2) SAY var
NEXT

** scroll up **
mprompt("Press a key scroll up")
W_SCROLL(1, 2)    && scroll 2 lines
mprompt("Press a key scroll down")
W_SCROLL(1, -2)    && scroll 2 lines

** move it **
mprompt("Press a key to move the window")
W_MOVE(1, 6, 15)

** lookup in a small file **
mprompt("Press a key to lookup in a small file.  We want to get the value of NEWKEY.")
SELECT 1
USE smalfile
GO TOP
newkey = SPACE(5)
newkey = W_LOOKUP(2, 10, 50, (cwindow3), 'smalfile', 'key', 'field1', .T., 1, "small")
MESS = "Newkey = &newkey"
mprompt(MESS)
** note that window 2 is automatically closed **

** draw another window to show switching **
mprompt("Let's draw another window to demonstrate window switching.  A key please.")
W_DRAW(2, 9, 20, 20, 40, (cwindow1), .T., 3, "Window 2")
FOR X = 1 TO 6
   var = "Line " + STR(X,1,0)
   @W_ROW(2, X + 2), W_COL(2, 2) SAY var
NEXT

mprompt("Press a key to switch windows 1 and 2")
W_SWITCH(2, 1)

mprompt("Now, press a key to switch them back")
W_SWITCH(1, 2)

** lookup in a big file **
** Big Note:  The library is currently limited to searches and displays of
** character types only.  It will not work with numbers or dates.  You must
** somehow convert them to character for it to work here.
**
mprompt("Press a key to lookup in a big file.  Our client's account number is 10090")
SELECT 1
USE bigfile INDEX bigkey
GO TOP
newkey = SPACE(5)
newkey = W_LOOKUP(3, 10, 30, (cwindow3), 'bigfile', 'fdate', 'key + " " + field1', .T., 1, "big file", "10090", "key = '10090'")
MESS = "The Fdate for the record selected for our client is: " + fdate
mprompt(MESS)
** note:  window 3 is automatically closed **

** close window 2 **
mprompt("Press a key to close window 2")
W_ERASE(2)

** close window 1 **
mprompt("Press a key to close window 1")
W_ERASE(1)

mprompt("Hope you liked it.  Press a key to exit.")
close data
set cursor on
QUIT

*!*********************************************************************
*!
*!       Function: MPROMPT()
*!
*!      Called by: WINDDEMO.PRG                  
*!
*!*********************************************************************
FUNCTION mprompt
PARAMETER MESS
lastcolor = Setcolor()
SET COLOR TO (cnormal)
@23,0 SAY SPACE(79)
ctr(23, mess)
INKEY(0)
SET COLOR TO (lastcolor)
RETURN .T.


*!*********************************************************************
*!
*!       Function: CTR()
*!
*!*********************************************************************
FUNCTION CTR
PARAMETER ROW, MESS

mess_len = LEN(MESS)
pad = (80 - mess_len) / 2
@ROW, pad SAY MESS
RETURN .T.
*: EOF: WINDDEMO.PRG
