*:*********************************************************************
*:
*:        Program: WHEADER.PRG
*:
*:         System: Windowing System Demonstration
*:         Author: David Kanter
*:      Copyright (c) 1989, D & P Consulting
*:  Last modified: 04/06/89     16:48
*:
*:      Called by: WINDDEMO.PRG                  
*:
*:   Memory Files: COLORS.MEM
*:
*:      Documented 04/07/89 at 07:41                SNAP!  version 3.12e
*:*********************************************************************
* wheader.prg
* This header should be in most if not all of my clipper programs.
* It defines some very basic but often used parameters.  This could very
* easily have been included in dave_udf except for the windowing junk.
* Only 1 parameter is passed for the number of windows to open.  If absent
* default to 3.
PARAMETERS maxwind

** default colors only if colors.mem exists.  otherwise no default colors **
IF FILE("COLORS.MEM")
   PUBLIC cnormal, cerror, cwindow, cwindow1, cwindow2, cwindow3
   RESTORE FROM colors ADDITIVE
ENDIF

** window parameters **
IF Pcount() <> 1
   maxwind = 3
ENDIF
PUBLIC wtop_row[maxwind], wtop_col[maxwind], wbot_row[maxwind], wbot_col[maxwind]
PUBLIC wcolor[maxwind], wtemp[maxwind], oldcolor[maxwind], wshade[maxwind]

** basic setup for a nice environment **
SET DELETED ON
SET BELL OFF
SET SCOREBOARD OFF
SET Wrap ON

** box drawing array **
PUBLIC box_array[9]
box_array[1] = "ͻȺ" && double line
box_array[2] = "Ŀ" && single line
box_array[3] = "͸Գ" && double top, single sides
box_array[4] = "ķӺ" && single top, double sides
box_array[5] = "" && thick solid
box_array[6] = "" && thick all but bottom
box_array[7] = "" && thin block top and bottom, thick sides
box_array[8] = "" && thick top, thin all else
box_array[9] = "        " && no border

**** keyboard definitions ****
PUBLIC ret_key, homekey, endkey, uparrow, dnarrow, pgup, pgdn
ret_key = 13                   && setup keys and other variables
homekey  = 1
endkey   = 6
uparrow  = 5
dnarrow  = 24
pgup     = 18
pgdn     = 3

RETURN

*: EOF: WHEADER.PRG
