;  Copyright (c) 1991 Michael Kragl   All rights reserved.
;                     Compuserve: 75070,2113
;
;  MY_CLIPBRD
;  Copy Clipper-String to Microsoft Windows-Clipboard
;  Version 2 - real or protected (tested with Blinker 3.0)
;  Protected-Mode:
;     - allocate dos-memory below 1 MB
;     - copy clipper string to that memory
;     - emulate real-mode int2f using dos-memory
;  experimental-version.... segment locking not implemented.......
;                           no check for size-limits
;                           but should work for standard usage
;--------------------------------------------------------------------------
;       sample call from clipper:                                         |
;--------------------------------------------------------------------------
; |   external MY_CLIPBRD
; |   cliadr:="Teststring"
; |   ii=my_clipbrd(@cliadr)
; |
; |   do case
; |           case ii = 0
; |                   ii=my_clipbrd(@cliadr)      //sometimes it does'nt work for the 1st time
; |                   if ii = 0
; |                           ?"this function is only supported under Windows"
; |                           inkey(3)
; |                   else
; |                           ?"ok - 2"
; |                   endif
; |           case ii = 1
; |                   ?"ok"
; |           case ii = 2
; |                   ?"problem with EmptyClipboard"
; |                   inkey(3)
; |           case ii = 3
; |                   ?"problem with CloseClipboard"
; |                   inkey(3)
; |           case ii = 4
; |                   ?"problem with SetClipboardData"
; |                   inkey(3)
; |           case ii = 5
; |                   ?"Protected Problem with alloc-DOS-Mem"
; |                   inkey(3)
; |           case ii = 6
; |                   ?"Protected Problem with int 2F"
; |                   inkey(3)
; |           otherwise
; |                   ?"????????????????"+str(ii)
; |                   inkey(3)
; |   endcase
;--------------------------------------------------------------------------
PUBLIC               MY_CLIPBRD
EXTRN                __RETNI:FAR        ;return integer
EXTRN                __PARC:FAR         ;get character parameter
EXTRN                __PARCLEN:FAR      ;get character parameter
EXTRN                __PARNI:FAR        ;get character parameter

;--------------------------------------------------------------------------
DGROUP GROUP _MY_DATA
_MY_DATA SEGMENT 'DATA'
    REGS16 STRUC               ;structure for real-mode int2f
        xdi       dw 0h
                  dw 0h
        xsi       dw 0h
                  dw 0h
        xbp       dw 0h
        xxx       dd 0h
                  dw 0h
        xbx       dw 0h
                  dw 0h
        xdx       dw 0h
                  dw 0h
        xcx       dw 0h
                  dw 0h
        xax       dw 0h
                  dw 0h
        xflags    dw 0h
        xes       dw 0h
        xds       dw 0h
        xfs       dw 0h
        xgs       dw 0h
        xip       dw 0h
        xcs       dw 0h
        xsp       dw 0h
        xss       dw 0h
    REGS16 ENDS
    slen dw 0h                             ;length of clipper parameter
    cliseg dw 0h                           ;selector protected-mode
    clioff dw 0h                           ;offset of clipper parameter
    xregs REGS16 <>                        ;calling structure for int31-100h
_MY_DATA ENDS
;--------------------------------------------------------------------------
_MY_CODE   SEGMENT 'CODE'
             ASSUME cs:_MY_CODE, ds:DGROUP

MY_CLIPBRD PROC    FAR
;--------------------------------------------------------------------------
     push    bp              ; save registers
     mov     bp,sp
     push    ds
     push    es
     push    si
     push    di
;--------------------------------------------------------------------------
     mov  ax,1700h            ; IdentifyWinOldApVersion
     int  2fh
     cmp  ax,2                ; Support Version 2?
     je   OK                  ; if yes, then j ok
     cmp ax,1700h             ; running under Windows?
     je   NOWINDOW            ;
;--------------------------------------------------------------------------
NOWINDOW:
     mov  bx,0
     jmp  RETNC1
;--------------------------------------------------------------------------
OK:
     mov  ax,1701h            ; OpenClipboard
     int  2fh
     cmp  ax,0                ; ok?
     jne EMPTYCB              ; error if 0
     mov bx,2                 ;return  2  to clipper
     jmp RETNC
;--------------------------------------------------------------------------
EMPTYCB:
     mov  ax,1702h            ; EmptyClipboard
     int  2fh
     cmp  ax,0                ; ok?
     jne MOVEIT               ; error if 0
     mov bx,2                 ;return  2  to clipper
     jmp RETNC
;--------------------------------------------------------------------------
MOVEIT:
     mov ax,1
     push ax
     call __PARCLEN           ;find length of paramter -> ax
     add SP,2
     inc ax                   ;add 1 for terminating zero !! (this was hard to find for me)
     mov slen,ax
;--------------------------------------------------------------------------
     mov ax,1                 ;find address of parameter
     push ax                  ;address in dx:ax
     call __PARC
     add sp,2
     mov cliseg,dx            ;save address
     mov clioff,ax
;--------------------------------------------------------------------------
TESTPROT:
     mov  ax,1686h            ; Test if in protected mode
     int  2fh
     cmp  ax,0                ; 0 - protected-mode
     jne  OKREALA             ; if yes, then j to real-mode
;--------------------------------------------------------------------------
     mov  ax,0100h            ; allocate dos - memory via dpmi
     mov  bx,slen             ;    size in paragrafs (16-byte)
     shr  bx,1                ;div /2
     shr  bx,1                ;div /2
     shr  bx,1                ;div /2
     shr  bx,1                ;div /2
     inc  bx
     int  31h                 ; dpmi interrupt
     jc   PROTECTED1A         ; carry ? fehler
     mov  xregs.xes,ax        ; real mode segment  in ax
     mov  es,dx               ; dx:0  selector
     mov  di,0h               ; string will start at beginning of selector
     push ds                  ; save register
     mov  cx,slen             ; prepare for movsb
                              ; parmlen +1 for terminating 0
     mov  si,clioff           ; offset of clipper parameter
     mov  ds,cliseg           ; now change ds to clipper-selector (do not reference dgroup now!)
     rep  movsb               ; es:di <- ds:si   move string to dos memory
     pop  ds                  ; restore ds to point to dgroup
     jmp  PROTINT
;--------------------------------------------------------------------------
OKREALA:                      ; aux-label
     jmp  OKREAL
;--------------------------------------------------------------------------
PROTECTED1A:
     mov  bx,5
     jmp  RETNC1
;--------------------------------------------------------------------------
PROTINT:
     mov  ax,slen             ;prepare calling-structure
     mov  xregs.xcx,ax        ;length of clipper-parameter
     mov  xregs.xbx,0
     mov  xregs.xdx,7         ; oem-text
     mov  xregs.xax,1703h     ; set clipboard-data
     mov  xregs.xds,ds
     mov  di,OFFSET xregs
     mov  ax,SEG xregs
     mov  es,ax
     mov  ax,300h
     mov  bl,2fh
     mov  bh,0
     mov  cx,0
     int  31h
     jc   PROTECTED2          ; carry->error
     cmp  xregs.xax,0         ; was call to 1703 successfull?
     jne COPYOKP
     mov bx,4                 ;return  4  to clipper
     jmp  COPYOKP
;--------------------------------------------------------------------------
OKREAL:
     mov  es,cliseg           ;String in ES:BX
     mov  bx,clioff           ;
     mov dx,7                 ; CF_OEM_TEXT  for conversion to ansi
     mov SI,0                 ;length in  SI:CX
     mov cx,slen
     mov ax,1703H             ;SetClipboardData
     int 2fh
     cmp  ax,0
     jne COPYOK
     mov bx,4                 ;return  4  to clipper
     jmp RETNC
;--------------------------------------------------------------------------
PROTECTED2:
     mov  bx,6
     jmp  RETNC1
;--------------------------------------------------------------------------
COPYOKP:
     mov  ax,0101h            ; deallocate dos - memory
     int  31h                 ; dpmi interrupt
COPYOK:
     mov  ax,1708h            ; CloseClipboard
     int  2fh
     cmp  ax,0
     jne  CLOSOK              ; if 0 error
     mov bx,3                 ;return  3  to clipper
     jmp RETNC
;--------------------------------------------------------------------------
CLOSOK:
     mov bx,1                 ;return .t. to clipper
     jmp RETNC1
;--------------------------------------------------------------------------
PROTECTED:
     mov  bx,5
     jmp  RETNC1
;--------------------------------------------------------------------------
RETNC:
     mov  ax,1708h            ; CloseClipboard
     int  2fh                 ; int 2fh
;--------------------------------------------------------------------------
RETNC1:
     push bx
     call __RETNI
     add      sp,2
;--------------------------------------------------------------------------
     pop     di               ; restore registers
     pop     si
     pop     es
     pop     ds
     pop     bp
     cld

     ret
;-------------------------------------------------------------------

MY_CLIPBRD ENDP               ; end of procedure

_MY_CODE      ENDS            ; end of code segment
              END
