*:*********************************************************************
*:
*:        Program: WINCLIP.PRG
*:
*:         System: WINCLIP
*:         Author: Jeff A. Benton
*:      Copyright (c) 1990, Jeff A. Benton
*:  Last modified: 02/11/90      8:39
*:
*:  Procs & Fncts: _INITWIN()
*:               : _CRETWIN()
*:               : _WINSTD()
*:               : _WINUPDT()
*:               : _DELWIN()
*:               : _DISPWIN()
*:
*:      Documented 02/11/90 at 08:42                SNAP!  version 4.02
*:*********************************************************************
*!*********************************************************************
*!
*!       Function: _INITWIN()
*!
*!*********************************************************************
FUNCTION _initwin
PUBLIC _winsel
PUBLIC _winlast
PUBLIC _wincord [10]
PUBLIC _wincolr [10]
PUBLIC _winsave [10]
IF TYPE('TRUE') = 'U'
   PUBLIC true
   true = .T.
ENDIF
IF TYPE('FALSE') = 'U'
   PUBLIC false
   false = .F.
ENDIF
_winsel = 0
_winlast = 1
RETURN(0)

*!*********************************************************************
*!
*!       Function: _CRETWIN()
*!
*!          Calls: _WINSTD()      (function  in WINCLIP.PRG)
*!
*!*********************************************************************
FUNCTION _cretwin
PARAM top_row, top_col, bot_row, bot_col, txt_colr, frm_colr
_winsel = _winsel + 1
IF _winsel > 10
   RETURN(-1)
ENDIF
_wincord[ _WinSel ] = _winstd(top_row,top_col,bot_row,bot_col,0,0)+'0'
_wincolr[ _WinSel ] = txt_colr+'|'+frm_colr
_winsave[ _Winsel ] = SAVESCREEN(top_row,top_col,bot_row,bot_col)
RETURN( _winsel )

*!*********************************************************************
*!
*!       Function: _WINSTD()
*!
*!      Called by: _CRETWIN()     (function  in WINCLIP.PRG)
*!
*!*********************************************************************
FUNCTION _winstd
PARAM tr, tc, BR, bc, rr, rc
PRIV t1
t1 = IIF(tr<10,'0'+STR(tr,1),STR(tr,2))
t1 = t1 + IIF(tc<10,'0'+STR(tc,1),STR(tc,2))
t1 = t1 + IIF(BR<10,'0'+STR(BR,1),STR(BR,2))
t1 = t1 + IIF(bc<10,'0'+STR(bc,1),STR(bc,2))
t1 = t1 + IIF(rr<10,'0'+STR(rr,1),STR(rr,2))
t1 = t1 + IIF(rc<10,'0'+STR(rc,1),STR(rc,2))
RETURN( t1 )

*!*********************************************************************
*!
*!       Function: _WINUPDT()
*!
*!      Called by: _DISPWIN()     (function  in WINCLIP.PRG)
*!
*!*********************************************************************
FUNCTION _winupdt
PARAM cr, cc
PRIV t1
t1 = SUBSTR(_wincord[_winlast],1,8)
t1 = t1 + IIF(cr<10,'0'+STR(cr,1),STR(cr,2))
t1 = t1 + IIF(cc<10,'0'+STR(cc,1),STR(cc,2))
t1 = t1 + SUBSTR(_wincord[_winlast],13,1)
RETURN( t1 )

*!*********************************************************************
*!
*!       Function: _DELWIN()
*!
*!   Binary Files: __SETWIN.BIN
*!
*!*********************************************************************
FUNCTION _delwin
PARAM WINDOW
PRIV t1, t2, t3, t4, t5, txtcolr, A, currow, curcol
IF (WINDOW > _winsel)
   RETURN (-1)
ENDIF
CALL __setwin WITH Word(0), Word(0), Word(24), Word(79)
t2 = VAL(SUBSTR( _wincord[ Window ], 1,2))
t3 = VAL(SUBSTR( _wincord[ Window ], 3,2))
t4 = VAL(SUBSTR( _wincord[ Window ], 5,2))
t5 = VAL(SUBSTR( _wincord[ Window ], 7,2))
Scroll( t2, t3, t4, t5, 0)
_wincord[ Window ] = " "
_wincolr[ Window ] = " "
FOR A = 1 TO _winsel
   IF SUBSTR(_wincord[A],1,1) != ' '
      t2 = VAL(SUBSTR( _wincord[ A ], 1,2))
      t3 = VAL(SUBSTR( _wincord[ A ], 3,2))
      t4 = VAL(SUBSTR( _wincord[ A ], 5,2))
      t5 = VAL(SUBSTR( _wincord[ A ], 7,2))
      currow = VAL(SUBSTR( _wincord[ A ], 9,2))
      curcol = VAL(SUBSTR( _wincord[ A ],11,2))
      t1 = AT('|',_wincolr[ WINDOW ])
      txtcolr = SUBSTR( _wincolr[ WINDOW ],1,(t1-1))
      RESTSCREEN(t2,t3,t4,t5,_winsave[ A ])
   ENDIF
NEXT
CALL __setwin WITH Word(t2+1), Word(t3+1), Word(t4-1), Word(t5-1)
SET COLOR TO (txtcolr)
@ currow, curcol SAY ''
RETURN( WINDOW )


*!*********************************************************************
*!
*!       Function: _DISPWIN()
*!
*!          Calls: _WINUPDT()     (function  in WINCLIP.PRG)
*!
*!   Binary Files: __SETWIN.BIN
*!
*!*********************************************************************
FUNCTION _dispwin
PARAM WINDOW, fast
PRIV t1
PRIV t2
PRIV t3
PRIV t4
PRIV t5
PRIV txtcolr
PRIV frmcolr
PRIV frstime
PRIV currow
PRIV curcol
frstime = .F.
currow = ROW()
curcol = COL()
CALL __setwin WITH Word(0), Word(0), Word(24), Word(79)
IF WINDOW > _winsel
   RETURN(-1)
ENDIF
IF WINDOW > 0
   t2 = VAL(SUBSTR( _wincord[ _Winlast], 1,2))
   t3 = VAL(SUBSTR( _wincord[ _Winlast], 3,2))
   t4 = VAL(SUBSTR( _wincord[ _Winlast], 5,2))
   t5 = VAL(SUBSTR( _wincord[ _Winlast], 7,2))
   _winsave[ _Winlast] = SAVESCREEN(t2,t3,t4,t5)
   _wincord[ _Winlast] = _winupdt(currow,curcol)
   _winlast = WINDOW
ENDIF
IF WINDOW <= _winsel
   t2 = VAL(SUBSTR( _wincord[ Window ], 1,2))
   t3 = VAL(SUBSTR( _wincord[ Window ], 3,2))
   t4 = VAL(SUBSTR( _wincord[ Window ], 5,2))
   t5 = VAL(SUBSTR( _wincord[ Window ], 7,2))
   currow = VAL(SUBSTR( _wincord[ Window ], 9,2))
   curcol = VAL(SUBSTR( _wincord[ Window ],11,2))
   IF fast
      RESTSCREEN(t2,t3,t4,t5,_winsave[ WINDOW ])
   ENDIF
ENDIF
t1 = AT('|',_wincolr[ Window ])
txtcolr = SUBSTR( _wincolr[ Window ],1,( t1-1 ))
IF VAL(SUBSTR( _wincord[ Window],13, 1)) == 0
   frmcolr = SUBSTR( _wincolr[ Window ],( t1+1 ),;
      ( LEN(_wincolr [Window]) - t1) )
   SET COLOR TO (frmcolr)
   frstime = .T.
   _wincord[ Window ] = SUBSTR( _wincord[ Window ], 1,12) + '1'
   t2 = VAL(SUBSTR( _wincord[ Window], 1,2))
   t3 = VAL(SUBSTR( _wincord[ Window], 3,2))
   t4 = VAL(SUBSTR( _wincord[ Window], 5,2))
   t5 = VAL(SUBSTR( _wincord[ Window], 7,2))
   currow = VAL(SUBSTR( _wincord[ Window], 9,2))
   curcol = VAL(SUBSTR( _wincord[ Window],11,2))
   @ t2, t3 TO t4, t5 DOUBLE
ENDIF
SET COLOR TO (txtcolr)
CALL __setwin WITH Word(t2+1), Word(t3+1), Word(t4-1), Word(t5-1)
IF frstime
   CLEAR
ENDIF
@ currow, curcol SAY ''
RETURN(0)
*: EOF: WINCLIP.PRG
