
// WinBox() - Draws sunken or raised grey boxes on your windows
// Neat way to highlight buttons, controls, create status bars, etc.
//
// 05/24/93, Hugh A. Lokey
//
// Calling Syntax:
//         hWnd    := handle to window to draw on
//         nX,nY   := Upper left corner of box (column,row)
//         nCX,nCY := Lower right hand corder of box (column,row)
//         nStyle  := 1 = sunken, 2 = raised
//         nBorder := 1 = draw a black border, 2 = no border
//         nPixHD  := number of pixels deep or high
//                    on two or more the lines are staggerd so
//                    you get beveled "picture frame" corners
//
//         nTBbord := Inset from edge for top and bottom of box
//         nLRbord := Inset from edge for left and right sides
//                    nTBord and LRbord are used when you want
//                    to create "status bar" type arrangements
//
// NOTES:  You can easily modify this to allow the selection of
// your own colors - I happen to like simple things like the
// grey background!
//
// You will also have to re-draw the boxes when you get an event_redraw
// for the window they are on.  If you stick buttons or other controls
// within a box you should include WS_CLIPCHILDREN in the window def
// so that Windows will redraw the controls otherwise they will be
// hidden behind your box when you redraw it!

FUNCTION WinBox(hWnd,nX,nY,nCX,nCY,nStyle,nBorder,nPixHD,nTBbord,nLRBord)
         LOCAL nLeft, nTop, nRight, nBottom, hOldPen, hTopPen, hBotPen
         LOCAL hDC, hFillPen, hBlackPen, hGreyPen, hWhitePen, nCtr

         hDc       := GetDC(hWnd)
         nLeft     := nX
         nTop      := nY
         nRight    := nCX
         nBottom   := nCY
         nStyle    := IIF(nStyle  == NIL, 1 , nStyle)
         nBorder   := IIF(nBorder == NIL, 1 , nBorder)
         nPixHD    := IIF(nPixHD  == NIL, 1 , nPixHD)

         hBlackPen := CreatePen(PS_SOLID,1,RGB(0,0,0))
         hGreyPen  := CreatePen(PS_SOLID,1,RGB(128,128,128))
         hWhitePen := CreatePen(PS_SOLID,1,RGB(255,255,255))
         hFillPen  := CreateSolidBrush(RGB(192,192,192))
         hOldPen   := SelectObject(hDC,hBlackPen)

         Rectangle(hDC,nLeft,nTop,nRight,nBottom)
         IF nBorder == 1
            FillRect(hDC,nLeft+1,nTop+1,nRight-1,nBottom-1,hFillPen)
            nLeft   += 1
            nTop    += 1
            nRight  -= 2
            nBottom -= 2
         ELSE
            FillRect(hDC,nLeft,nTop,nRight,nBottom,hFillPen)
            ++nLeft
            ++nTop
            --nRight
            --nBottom
         ENDIF
         nLeft   := IIF(nLRBord == NIL,nLeft,nLeft+nLRBord)
         nRight  := IIF(nLRBord == NIL,nRight,nRight-nLRBord)
         nTop    := IIF(nTBBord == NIL,nTop,nTop+nTBBord)
         nBottom := IIF(nTBBord == NIL,nBottom,nBottom-nTBBord)
         IF nStyle == 1
            hTopPen := hGreyPen
            hBotPen := hWhitePen
         ELSE
            hTopPen := hWhitePen
            hBotPen := hGreyPen
         ENDIF
         FOR nCtr := 1 TO nPixHD
             DrawWBox(hDC,hTopPen,hBotPen,nTop,nLeft,nBottom,nRight)
             ++nLeft
             ++nTop
             --nRight
             --nBottom
         NEXT
         SelectObject(hDC,hOldPen)
         ReleaseDC(hWnd,hDC)
         DeleteObject(hFillPen)
         DeleteObject(hBlackPen)
         DeleteObject(hGreyPen)
         DeleteObject(hWhitePen)
RETURN(NIL)

STATIC FUNCTION DrawWBox(hDC,hTopPen,hBotPen,nTop,nLeft,nBottom,nRight)

       SelectObject(hDC,hTopPen)
       MoveTo(hDC,nLeft,nBottom)
       LineTo(hDC,nLeft,nTop)
       LineTo(hDC,nRight,nTop)
       SelectObject(hDC,hBotPen)
       LineTo(hDC,nRight,nBottom)
       LineTo(hDC,nLeft,nBottom)
RETURN(NIL)
