/*
    Steve's Object Access Definition File     v1.0

    Written by Steve Klingler
    (C) 1990 Steve Klingler

    Expanded by Richard Lalonde
    June 1991


   Expanded to use a 2 dimendional array   ( R.L.  June 1991 )
     { 1:  { Exported Methods } ;
       2:  { Exported Non-Assignable Instance Variables } ;   **  NEW  **
       3:  { Exported Assignable Instance Variavles     } ;   **  NEW  **
     }
*/
*****************************************************************************/
#command OBJECT <obj1>:<oType> => ;
        \#translate <obj1>:\<method\>( \[ \<list,...\> \] ) \=\> ;
                <oType>:\<method\>( <obj1>, \<list\> )

#command OBJECT <obj1> FROM <oType> => ;
        \#translate <obj1>:\<method\>( \[ \<list,...\> \] ) \=\> ;
                <oType>:\<method\>( <obj1>, \<list\> )


*****************************************************************************/
// Class Method
#command EXPORT METHOD <oType>:<meth> <num1>,<num2> => ;
    \#translate <oType>:<meth>( \<instance\>, \[ \<list,...\> \] ) \=\> ;
        ( \<instance\> := EVAL( <oType>( <num1>,<num2> ), \<instance\>, \<list\> ))

*****************************************************************************/
/*  DO NOT USE INSTANCE => RESERVED WORD => INSTVAR  R.L. June 1991 */
/*  Attempts to assign a value will be trapped at compile time

// Non-Assignable Instance Variable
#command EXPORT NON_ASSIGN <oType>:<meth> <num1>,<num2> => ;
    \#translate <oType>:<meth>( \<instance\>, )  \=\> ;
         ( EVAL( <oType>( <num1>,<num2> ), \<instance\>, ))

// Assignable Instance Variable
#command EXPORT ASSIGNABLE <oType>:<meth> <num1>,<num2> => ;
    \#translate <oType>:<meth>( \<instance\>, )  \[ \:= \<any\> \]  \=\> ;
         ( EVAL( <oType>( <num1>,<num2> ), \<instance\>, \<any\>  ) )

/*  TAKE NOTE                                              */
/*  use the same variable NAME when passing as a PARAM     */
/*  OR "re-declare" object with OBJECT param FROM Class    */


