/*
    Steve's Command Definition File     v1.1    Last revised on 11/10/90

    Written by Steve Klingler
    (C) 1990 Steve Klingler

    Except as noted (ie. the DEFAULT command) everything in here is
    of my own design.  I'm sure it will continue to evolve for some
    time yet.  Input is welcome.
*/


/*****************************************************************************
 start with the obvious . . . 
*****************************************************************************/
#define TRUE                    .T.
#define FALSE                   .F.


/*****************************************************************************
 The DEFAULT command is by Brad Choate   CServe ID: 75056,1247
         ie. DEFAULT color WITH "W/N"
*****************************************************************************/
#command DEFAULT <v1> WITH <x1> [, <vN> WITH <xN> ];
      => IIF((<v1>)=NIL,<v1>:=<x1>,NIL) [; IF((<vN>)=NIL,<vN>:=<xN>,NIL)]


/*****************************************************************************
 ie. IFPASSED color UPDATE newColor
*****************************************************************************/
#command IFPASSED <x1> UPDATE <v1> [, <vN> UPDATE <xN> ];
      => iif((<x1>)=NIL,NIL,<v1>:=<x1>) [; IIF((<xN>)=NIL,NIL,<vN>:=<xN>)]


/*****************************************************************************
 ie. UPDATE color WITH newColor - for consistency with the IFPASSED and 
 DEFAULT commands.  Nothing tricky here.
*****************************************************************************/
#command UPDATE <v1> WITH <x1> [, <vN> WITH <xN> ];
      => <v1>:=<x1> [; <vN>:=<xN>]


/*****************************************************************************
 ie. UPDATE color WITH newColor DEFAULT "W/N"
 If newColor is defined, assign it to color.  If not, assign "W/N" to color.
*****************************************************************************/
#command UPDATE <v1> WITH <x1> DEFAULT <d1> [, <vN> WITH <xN> DEFAULT <dN>];
      => iif((<x1>)=NIL,<v1>:=<d1>,<v1>:=<x1>) [; IIF((<xN>)=NIL,<vN>:=<dN>,<vN>:=<xN>)]


/*****************************************************************************
 Instead of typing Static Function you can type SFunction . . . so I'm lazy
*****************************************************************************/
#command SFUNCTION <*declaration*>      => ;
    static function <declaration>


/*****************************************************************************
 Save the Cursor to <row>, <col>  
        ie. SCURSOR prow, pcol
*****************************************************************************/
#command SCURSOR <row>, <col>   => ;
        <row>:=row();<col>:=col()


/*****************************************************************************
 Restore the Cursor to <row>, <col>  
        ie. RCURSOR prow, pcol
*****************************************************************************/
#command RCURSOR <row>, <col>   => ;
          DevPos( <row>, <col> )

