/*
    Steve's Object Access Definition File     v1.0

    Written by Steve Klingler
    (C) 1990 Steve Klingler

    Everything in here is of my own design.  I'm sure it will continue 
    to evolve for some time yet.  Input is welcome.

    This file must be #included in all user access include files.
            ie.  WIN.CH includes OBJECT.CH

    Feel free to use these and enhance them to your own liking.  All I ask 
    is that if you do use them, please give me credit in the CH file or 
    leave this header intact.

*/


/*****************************************************************************
 Define Objects:
        OBJECT myWin:WIN
 defines myWin as an instance of the WIN object

 The tricky part comes when you use this UDC with arrays.
        OBJECT window_[ 1 ]:win
 this is pretty simple, right?  Not always . . .  window_[ 1 ]:show() does 
 what we want, but what happens when you access with a variable for the
 element?  ie. window_[ curWindow ]:show() does not work!  We get around
 this with the following declaration:
        OBJECT window_[ <ele> ]:win
 This now indicates that the array window_ is an array of objects of type WIN
 and that we are to use the WIN access methods regardless of what element was
 referenced or how it was referenced (ie. with a memvar or explicit element)

 This has it's own problem.  What if you had an array of different types of 
 objects?  . . . well, for now you would have to declare every element to it's
 correct type.  This is obviously somewhat limiting but I don't know how to 
 resolve it without resorting to a run-time determination of the object type
 which I don't want to do due to the speed consequences.
  
*****************************************************************************/
#command OBJECT <obj1>:<oType> => ;
        \#translate <obj1>:\<method\>( \[ \<list,...\> \] ) \=\> ;
                <oType>:\<method\>( <obj1>, \<list\> )


/*****************************************************************************
 Assign Objects:
        METHOD ASSIGN WIN:NEW 1
  defines the NEW method as an assignment method and specifies it as
  method #1 in the WIN system.

  For example:
        // define the method
        METHOD ASSIGN WIN:NEW 1
        // define myWindow as an instance of WIN
        DEFINE WIN OBJECT myWindow
        // create and initialize myWindow
        myWindow:new()

 The last line (myWindow:new()) will be translated into something like . . . 
         ( myWindow := WIN:NEW( myWindow ))

 Note that we do pass the variable to the method and that we assign the return
 value to the variable.  While this might seem silly in the case of NEW - it 
 is useful in other situations and it does not hurt a thing in the case of NEW.

*****************************************************************************/
#command METHOD ASSIGN <oType>:<meth> <num> => ;
        \#translate <oType>:<meth>( \<instance\>, \[ \<list,...\> \] ) \=\> ;
                ( \<instance\> := EVAL( <oType>( <num> ), \<instance\>, \<list\> ))


/*****************************************************************************
 Access Objects:
        METHOD ACCESS WIN:SHOW 2
 defines the SHOW method as an access method and specifies it as method #2
 in the WIN system.

   For example:
        // define the method
        METHOD ACCESS WIN:SHOW 1
        // define myWindow as an instance of WIN
        OBJECT myWindow:WIN
        // create and initialize myWindow
        myWindow:show()

 The last line (myWindow:show()) will be translated into something like . . . 
         ( WIN:SHOW( myWindow ))

 Note that we pass the variable to the method but do not assign the return 
 value to the variable.  The return value will usually contain other 
 information as defined in the system.  For example:
        myWindow:isVisible()
 might return .T. if it is visible or .F. if not.
        myWindow:show()
 would simply display myWindow (although it could return a useful value).

*****************************************************************************/
#command METHOD ACCESS <oType>:<meth> <num> => ;
        \#translate <oType>:<meth>( \[ \<list,...\> \] ) \=\> ;
                ( EVAL( <oType>( <num> ), \<list\> ))


