/*  
    OOPS type Window Routines ??
    Have fun with it . . . it's not complete, but it's kinda fun to play with!

    Written by Steve Klingler
    Awe, Shucks.  Let's release this one to the Public Domain and hope someone
    learns something from it or is able to enhance and use it to their benefit.
    I make no claims or warranties at all.  Use at your own risk.
*/

#include "steve.ch"
#include "win.ch"
#include "box.ch"

// following are only for use in this file
#define WIN_ELE 11
#define TYPE    1
#define CORT    2
#define CORL    3
#define CORB    4
#define CORR    5
#define COLOR   6
#define BORDER  7
#define HEADER  8
#define FOOTER  9 
#define VISIBLE 10
#define SCREEN  11

#define T_WINDOW    1

#define METHODS     {   {| top, left, bottom, right, color, border, header, footer | ;
                            New( top, left, bottom, right, color, border, header, footer ) }, ;
                        {| window_ | Destroy( window_ ) }, ;
                        {| window_ | Show( window_ ) }, ;
                        {| window_ | Hide( window_ ) }, ;
                        {| window_, vert, horiz | Move( window_, vert, horiz ) }, ;
                        {| window_, top, left, bottom, right | ;
                            Position( window_, top, left, bottom, right ) } ;
                    }


function win( method )
return METHODS[ method ]


static function New( window_, top, left, bottom, right, color, border, header, footer )
    window_ := array( 11 )
    UPDATE window_[ TYPE   ] WITH T_WINDOW  
    UPDATE window_[ CORT   ] WITH top       DEFAULT 4
    UPDATE window_[ CORL   ] WITH left      DEFAULT 10
    UPDATE window_[ CORB   ] WITH bottom    DEFAULT 20
    UPDATE window_[ CORR   ] WITH right     DEFAULT 69
    UPDATE window_[ COLOR  ] WITH color     DEFAULT "W+/N"
    UPDATE window_[ BORDER ] WITH border    DEFAULT B_DOUBLE
    UPDATE window_[ HEADER ] WITH header    DEFAULT NIL
    UPDATE window_[ FOOTER ] WITH footer    DEFAULT NIL
    UPDATE window_[ VISIBLE ] WITH FALSE    
    UPDATE window_[ SCREEN ] WITH NIL       
return window_


sfunction Destroy( window_ )
    window_ := {}
return window_


sfunction Position( window_, top, left, bottom, right )
    local wasVisible

    // Hide the window if it was visible!
    wasVisible := ( window_[ VISIBLE ] == TRUE )
    if ( wasVisible )
        Hide( window_ )
    endif

    IFPASSED top    UPDATE window_[ CORT   ]
    IFPASSED left   UPDATE window_[ CORL   ]
    IFPASSED bottom UPDATE window_[ CORB   ]
    IFPASSED right  UPDATE window_[ CORR   ]

    // Show the window if it was visible!
    if ( wasVisible )
        Show( window_ )
    endif

return NIL


sfunction Hide( window_ )
    if ( window_[ VISIBLE ] = TRUE )
        restscreen( window_[ CORT   ], ;
                    window_[ CORL   ], ;
                    window_[ CORB   ], ;
                    window_[ CORR   ], ;
                    window_[ SCREEN ] ;
                  )

        window_[ VISIBLE ] := FALSE
    endif
return NIL


sfunction Show( window_ )
    local prevColor, prow, pcol
    // If already visible - better hide it first!
    if ( window_[ VISIBLE ] = TRUE )
        Hide( window_ )
    endif

    // Now (re)Display the window
    // First save the previous screen
    window_[ SCREEN ] := savescreen( ;
                window_[ CORT   ], ;
                window_[ CORL   ], ;
                window_[ CORB   ], ;
                window_[ CORR   ]  )

    // save the old color and set the new one and save cursor position
    prevColor := setcolor( window_[ COLOR ] )
    SCURSOR prow, pcol

    // Now clear the region and draw the border
    scroll( window_[ CORT   ], window_[ CORL   ], ; 
            window_[ CORB   ], window_[ CORR   ], 0 )

    @ window_[ CORT   ], window_[ CORL   ], ;
      window_[ CORB   ], window_[ CORR   ] box window_[ BORDER ] 

    // Now Indicate the Header and Footer values
    if ( window_[ HEADER ] # NIL )
        @ window_[ CORT   ], window_[ CORL ] + 1 say ;
            "[" + left( window_[ HEADER ], window_[ CORR   ] - window_[ CORL   ] - 3 ) + "]"
    endif

    if ( window_[ FOOTER ] # NIL )
        @ window_[ CORB   ], window_[ CORL ] + 1 say ;
            "[" + left( window_[ FOOTER ], window_[ CORR   ] - window_[ CORL   ] - 3 ) + "]"
    endif

    // restore the old color and cursor position
    setcolor( prevColor )
    RCURSOR prow, pcol

    // tell the window it is now visible
    window_[ VISIBLE ] := TRUE

return NIL


sfunction Move( window_, vert, horiz )

    // make sure something was passed
    DEFAULT vert    WITH 0, ;
            horiz   WITH 0

    // check for boundaries and reposition the window
    vert := vert + ChkBounds( vert, 0 - window_[ CORT   ], maxrow() - window_[ CORB   ] )
    horiz := horiz + ChkBounds( horiz, 0 - window_[ CORL   ], maxcol() - window_[ CORR   ] )

    // if there will be movement, position the window
    if !( vert = 0 .and. horiz = 0 )
        Position( window_, ;
            window_[ CORT   ] + vert, ;
            window_[ CORL   ] + horiz, ;
            window_[ CORB   ] + vert, ;
            window_[ CORR   ] + horiz )
    endif

return NIL


function ChkBounds( offset, lowval, highval )
    local retVal
    do case
        case ( offset > highval )
            retVal := ( highval - offset )
        case ( offset < lowval )
            retVal := ( lowval - offset )
        otherwise
            retVal := 0
    endcase
return retVal 

