************************************************************
*
*  WTEST.PRG  - Program to demonstrate WhereIs() and Tree() 
*               functions for Clipper S`87 (not 5.0)
*
*  WhereIs()  - Returns No. of "hits" to a DOS legal filespec.
*               Optionally fills a pre-declared array with the
*               path/filename of all "hits".  Array should be declared
*               large enough to contain all "hits" (but no biggie if not).  
*
*     Usage   - WhereIs( <filespec> [, ArrayName] )
*               <filespec> can be any DOS legal filename, including wildcards
*               and may optionally include a drive specifier, for example
*               WHEREIS( "B:*.BAT", A_Bats ).  Do not include any path info.
*
*  Defaults   - Defaults to "*.*" on current drive if no drive and/or 
*               filespec are provided.  Neither parm are mandatory.
*
*   Returns   - A numeric indicating number of hits, 0 if no hits or 
*               error (invalid drive or drive door not closed, etc.).
*                        __________________________
*
*    Tree()   - Returns No. of directories and sub-directories on 
*               current or specified drive.  Optionally fills a pre-defined 
*               array with the directory tree.  Array should be declared 
*               large enough to contain entire tree.
*
*     Usage   - Tree( [<drive:>] [,[ArrayName]] )
*
*  Defaults   - Defaults to current drive if no drive is specified. 
*               Neither parm are mandatory.
*
*   Returns   - A numeric indicating number of directories, 0 if error.
*                        __________________________
*
*   Linking   - Link with EXTOR.obj (found with R. McConnel's "CGOODS.ARC")
*
*               e.g. LINK WTEST+WHEREIS+EXTOR,,,CLIPPER EXTEND
*
*             - WhereIs.OBJ is well behaved, that is may be dynamically
*               overlaid by WarpLink, Blinker, et al.  WhereIs.OBJ is
*               not beleived to be compatible with Clipper 5.0, as memory
*               handling functions have been changed.  As soon as I have
*               time to unwrap 5.0 I will do a 5.0 version and post it on
*               CompuServe.
*
*
*   Written in MASM 5.1 by K. Stephan Larsen, TechSupport, Inc.
*   5852 W. Chestnut Ave.  Littleton, Colorado  80123
*            (303) 972-2261        CIS 76370,1532
*
*   Please report any problems so that they may be addressed.
*
*                Copyright (c) 1990 All Rights Reserved
*
*   You may freely use these functions without royalty,
*   however any commercial use or distribution for sale is prohibited.
*
************************************************************

DECLARE Newarray[2000]          && array must be declared large enough to
                                &&  contain all matches of filespec
                                
*  You may also elect to call WhereIs()/Tree() first without any array,
*   to obtain the number of elements for the array.  Then DECLARE the array
*   with the exact number of elements.  Obviously two calls to the function
*   requires twice as much time, however your array will be properly sized.

DO WHILE LASTKEY() <> 27        && loop until ESCape
    CLEAR SCREEN
    CLEAR TYPEAHEAD
    mpattern = SPACE(15)        && user defines filespec to search
    @ 5, 27 SAY 'Select a Function to Test'
    @ 0, 19 PROMPT 'WhereIs()'
    @ 0, 51 PROMPT 'Tree()'
    MENU TO which               && flag for WhereIs()/Tree()

    IF which = 0
        QUIT
    ENDIF

    @ 5, 0
    IF which = 1                && WhereIs()
        @ 2, 8 SAY "Enter drive/filespec to search:" GET mpattern
        @ 4, 8 SAY "Example -  C:*.BAT   - default is all files on current drive"
    ELSE                        && Tree()
        @ 2, 8 SAY "Enter drive to search:" GET mpattern
        @ 4, 8 SAY "Example -  C:        - default is current drive"
    ENDIF
    READ

    IF LASTKEY() = 27
        QUIT
    ENDIF

    @ 4, 0
    @24, 0 SAY 'Looking...'
    IF which = 1
        x = WhereIs(TRIM(mpattern), Newarray)   && perform search and fill array
    ELSE
        x = Tree(TRIM(mpattern), Newarray)
    ENDIF

    @24,0
    @ 4, 8 SAY LTRIM(STR(x, 5)) + ' occurances found'  && print them out

    x = MIN(x, LEN(Newarray))   && loop for either no of "hits" else array len
    z = 5
    FOR y = 1 TO x              && loop to display "hits" in groups of 15
        IF ROW() = 20
            ?
            WAIT
            @ 6, 0 CLEAR
            z = z - 15       
            IF LASTKEY() = 27                   && ESC, bounce outta here
                EXIT
            ELSEIF LASTKEY() = 18               && PgUp, back up one frame
                y = IIF( (y-29) < 1, 1, y-29 )
                z = IIF( (z+15) > 5, 5, z+15 )
            ENDIF
        ENDIF
        @ y + z, 5 SAY Newarray[y]
    NEXT
    ?
    WAIT
ENDDO
QUIT
