DO testwoy                                       && runs the test program
*****************
* woy
*   Pass..... a date
*   Returns.. numeric representing the number representing the 
*             week of the year.  
*   Notes.... Since any partial week at the beginning of the 
*             year is counted as a whole week, 53 weeks are 
*             possible.  To aleviate that, make offset = 0 or 1
*             uncomment line #23 and comment line # 22
*****************
FUNCTION woy 
  PARAMETER today                                && date
  PRIVATE dayone, lastday, yr, days, offset, ;
          addweek, round, retval

  yr      = YEAR(today)                          && numeric
  lastday = CTOD("12/31/" + ;
            LTRI(STR(INT(yr - 1))))              && date
  dayone  = lastday + 1                          && first day of year
  days    = today - lastday
  offset  = DOW(dayone)
* offset  = 0
  addweek = IF( DOW(today) < offset, 1, 0)
  round   = IF( MOD(days, 7) = 0, 0, 1)
  retval  = INT((days / 7) + addweek + round)
RETURN( retval)                                  && woy 

*****************
* testwoy
*   Pass.....
*   Notes....
*****************
PROCEDURE testwoy 
  * call woy with any date variable.  For speed, I cut any type
  * checking out of it.  It will crash on bad data
  datevar = date()
  DO WHILE .NOT. LASTKEY() = 27
    @ 00, 00 CLEAR
    @ 10, 10 SAY "Today is " + DTOC(datevar) + ;
                  ".  It is week number " + ;
                  LTRI(STR(WOY(datevar)))
    @ 11, 10 SAY "Enter another Date -" GET datevar
    READ
  ENDDO                                          && WHILE .NOT. LASTKEY() = 27
RETURN                                           && testwoy 
* 
* This is just a simple procedure to calculate the week of the year
* It divides the number of days between 01/01/xx and the date by 
* 7 (lines 21, and 26), adds one if there is a remainder (line 25),
* and optionally adds one if the DOW(today) < DOW(01/01/xx) (line 24).
* 
* Hope this is some help.
* 
* Mike Henry
