*****************
*****************
**
**  Syntax:
**  wait4key( [ <delay> ] )
**
**  Variable   T Len Description
**       
**  delay      N     Number of seconds to delay.  If 0 or not passed, waits
**                   forever.
**
**  Notes:  Uses the system clock ticks from ticker()
**
**  Source:  h:\users\jfk\vtcs\scroller.prg
*****************
*****************
function wait4key
parameter delay
if pcount() < 1
  delay = 0
endif
****** 18.2 is the # of clock ticks per second
if delay > 0
  delay = 18.2 * m->delay + ticker()
else
  delay = 0
endif
do while nextkey() = 0
  ****** Test if should exit if time expired.
  if m->delay > 0 .and. ticker() >= m->delay
    exit
  endif
enddo
return nextkey()

