;*:*********************************************************************
;*:
;*:      Program: V_SYSTEM.ASM
;*:
;*:       System: Vega Group Standard Library
;*:       Author: Glendon Todd / Vega Group
;*:    Copyright (c) 1987, Public Domain by Vega Group
;*:
;*:    Called by: V_LIB.PRG
;*:
;*: Documented: 12/3/87       22:51                   SNAP! version 2.01
;*:*********************************************************************
;
;
;
;  For support, comments, questions or whatever, contact :
;           
;                             Glendon Todd
;                             312 Van Buren St.
;                             Falls Church, VA    22046
;                             Compuserve 71121,352
;                             Voice (703) 532-8191   


extrn   _retl : far    ; return logical true or false

bios	segment at 0f000h
org 0fff0h
reset	label	far
bios ends

prog	segment	byte public 'PROG'
assume	CS:prog, DS:prog

;****************************************************************************
;       FLASHUP
;       This function checks to see if the Flashup TSR is installed and
;       returns a logical value.     This function currently works with
;       Clipper only.

public  flashup
flashup proc    far
push    ax
mov     ax, 6000h  
int     17h             ;dummy INT17 used by flashup (sneaky)
cmp     al,60h
mov     ax,0FFh
jz      fls_ret
mov     ax,0
fls_ret:
push    ax              ; put return value on the stack
call    _retl           ; return logical value to clipper
pop     ax              ; restore the stack
pop     ax
ret
flashup  endp

;******************************************************************************
;       REBOOT    Reboot the computer
;        This routine allows you to either perform a warm boot or a
;       cold boot of the machine. The warm boot simulates a Ctrl-Alt-Del,
;       and the cold boot simulates a power on with a memory and
;       diagnostics check.
;
;       reboot(wcode);
;       int wcode       1 : cold boot
;                       0 : warm boot

public  reboot
reboot  proc    far
mov     bp,sp		; don't need to save registers here !!!!!
mov     ax,[bp+2]		; get boot type
cmp     ax,1		; cold boot request?
jz      reboot1
mov     ax,40h		; setting location 0x40:0x72 = 1234h
mov     si,72h		; makes bios thing that ctrl-alt-delete was
mov     ds,ax		; pressed !!!!
mov     [si],1234h
reboot1:
assume cs:bios
jmp reset
reboot	endp

;****************************************************************************
;       SPEEDSCR
;       This function checks to see if the Speedscr TSR is installed and
;       returns a logical value.     This function currently works with
;       Clipper only.

assume	CS:prog, DS:prog

public  speedscr
speedscr  proc    far
push    ax
mov     ax, 6100h  
int     17h             ;dummy INT17 used by speedscr (sneaky)
cmp     al,61h
mov     ax,0FFh
jz      spd_ret
mov     ax,0
spd_ret:
push    ax              ; put return value on the stack
call    _retl           ; return logical value to clipper
pop     ax              ; restore the stack
pop     ax
ret
speedscr  endp

prog	ends
end	



*: EOF: V_SYSTEM.ASM
