/* Program Name: vtimeb.c                                                      */
/* Author: Vukan S. Ruzic                                                      */
/* Copyright (c) 1990 by Leisure Technology, Inc.                              */
/*-----------------------------------------------------------------------------*/
/* Created: 1/31/1990 at 9:10                                                  */
/* main =                                                                      */
/* Called From: Clipper Summer 87 Programs                                     */
/* Linking:                                                                    */
/*                                                                             */
/*        You MUST include Microsoft C 5.0 or later library LLIBCA.LIB         */
/*        in your library list.                                                */
/*                                                                             */
/* Function Description:                                                       */
/*                                                                             */
/*        1) When no parameters are passed to it, the function                 */
/*           will return a 4 character date/time string                        */
/*                                                                             */
/*           Example m = vtimeb()  :   returns: "%"                         */
/*                                                                             */
/*        2) When you pass the same string back to it,                         */
/*           the function will return a 24 character date/time                 */
/*           string.                                                           */
/*                                                                             */
/*           Example ? vtimeb(m)   :   returns: "Wed Jan 31 09:21:39 1990"     */
/*                                                                             */
/*        3) If you pass a noncharacter string the function will return        */
/*           an empty string.                                                  */
/*                                                                             */
/*.............................................................................*/
/* Revision: 1.0 Last Revised: 1/31/1990 at 9:10                               */
/* Description: Original Creation.                                             */
/*.............................................................................*/
/*---------------------------- ALL RIGHTS RESERVED ----------------------------*/

#include <nandef.h>
#include <extend.h>
#include <time.h>

CLIPPER vtimeb()                       /* get or return time */
{
   long ltime;

   if(PCOUNT != 0)
       {

           if( ISCHAR(1) )
               {

               ltime = ( long ) _parc(1);
               _retclen( ctime( ltime ) , 24 );

               }
           else

               _retc("");

       }
   else
       {

       time( &ltime );
       _retclen( ( char * ) &ltime , 4 );

       }

}
