*                     Enhanced version of viewport()
*----------------------
* Function............VIEWPORT() enhanced with additional features.
* Action..............Multi-optional data entry engine
* Returns.............nothing
* Category............Superfunction
* Syntax..............VIEWPORT([expL],[array1...array7],[expL])
* Description.........Presents a generic data entry screen with multiple
*                     movement, search, view and editing capabilities.
*
* Options.............[expL] Logical - this is .T. if you want to give
*                     the user Add,Edit,Delete, and .F. if not. Defaults
*                     to .T.
*
*                     Arrays 1-5 and array 7 must have the same # of
*                     elements. (default is # of fields in DBF). You may
*                     pass a .f. or a "" to bypass and activate the
*                     default.
*
*
*                     [array1] An array of field names. Defaults to
*                     all fields in DBF.
*
*                     [array2] An array of field descriptions. Defaults
*                     to field names. You must pass array1 if you wish
*                     to pass array2.
*
*                     [array3] is an array of PICTURES as Character
*                     expressions to correspond with the FIELDS
*                     array. Default is pictures as derived by ED_G_PIC()
*                     If you pass this array, each element must contain
*                     at least a "".
*
*                     [array4] is an array of DEFAULT expressions
*                     to correspond with the FIELDS array. The programmer
*                     must insure that the proper field type is returned.
*                     examples:  ctod("03/04/90") would be place 03/04/90
*                     as a default for a date field.
*
*                     [array5] is an array of Pre-edit (When) clauses
*                     to correspond with the FIELDS array. If the expression
*                     or UDF evaluates to .F., then the field will be passed
*                     over without being edited.
*
*                     [array6] is an array of VALID clauses and messages
*                     to correspond with the FIELDS array. Each
*                     is in the form "{valid clause};{valid message}"
*                     The FIELD is represented as a token "@@" in the
*                     valid clause which is replaced with the current
*                     edited value at edit time.
*                     i.e.
*                     "!empty(@@);Must not be empty"
*                     If you pass this array, each element must contain
*                     at least a "".
*
*                     [array7] is an array of Lookup definitions corresponding
*                     to the FIELDS array. These are delimited strings
*                     with 1-4 component parts matching the first
*                     four parameters of SMALLS(). Delimiter is a
*                     semicolon (;). As an example, to make a
*                     lookup definition corresponding to the COMPANY
*                     field in the FIELDS array, which will lookup
*                     on the field CORPNAME in the database INSTIT,
*                     titling the box "Company" and KEYBOARDing
*                     the contents of CORPNAME if CR pressed :
*                     "CORPNAME;Company;%INSTIT;CORPNAME".
*                     If you realize that these 4 components are
*                     parsed and sent as parameters to SMALLS(), you
*                     will get the idea.
*                     If you pass this array, each element must contain
*                     at least a "".
*
*                     [array8] [1-9] Character - each of elements 1-9
*                     is a delimited string in the format
*                     "{option};{action}" where option is
*                     a displayed menu option and action is
*                     a proc to be executed. i.e.:
*                     "Form Letters;FORMLETR()"
*                     "List Myfile;FILEREAD(2,2,22,78,'FMYFILE.TXT')"
*                     Pass 1-9 option/proc combinations. These will
*                     be presented as an 'Other' menu.
*                     THESE PROCS MUST BE DECLARED EXTERNAL!!!
*
*                     [array9] Logical - matches the FIELDS array and
*                     defines which fields may be edited (.t.) and
*                     which are display only (.f.)
*                     If you pass this array, each element must be of
*                     TYPE Logical.
*
*                     [array10] Logical - matches the FIELDS array and
*                     defines which fields are required (.t.) and
*                     which are not (.f.)
*                     If you pass this array, each element must be of
*                     TYPE Logical.
*
*                     [expL] Logical - pop up 'Carry Forward' message
*                     when adding? True/False. Default is True.
*
*                     [expC] Character - optional title for View Port
*
*                     [expC] Character - optional string containing (only)
*                     the first character of any menu item you wish to disable.
*                     Example: de_noallow = "NP" would disable "Next Record" &
*                     "Previous Record" menu options.
*
* Examples............use register
*                     private flds[fcount()]
*                     private fdes[fcount()]
*                     private fval[fcount()]
*                     private floo[fcount()]
*                     private fedit[fcount()]
*
*                     afields(flds)
*                     afields(fdes)
*                     afill(fval,"")
*                     afill(floo,"")
*                     afill(fedit,.t.)
*
*
*                     - valids for fields 5 and 6
*                     fval[5]="!empty(@@);Cannot be empty"
*                     fval[6]="!empty(@@);Cannot be empty"
*                     *                     *- lookups for fields 5 and 6
*                     floo[5] = "First;First Name;%user%;trim(first)"
*                     floo[6] = "Last;Last Name;%user;trim(Last)"
*
*                     *- 'other' menu array
*                     private oth[3]
*                     oth[1] = "Read PRG;FILEREAD(1,1,23,79,'s_viewp.prg')"
*                     oth[2] = "Do Form Letters ;FORMLETR()"
*                     oth[3] = "Frequency Analysis;FREQANAL()"
*
*                     * be sure the 'other' procs are pulled in
*                     EXTERNAL FILEREAD,FREQANAL,FORMLETR
*
*                     VIEWPORT(.t.,flds,fdes,.f.,fval,floo,oth)
*
* Modifications
*
* 12/13/90  FRG
*                     Changed default of description length from 15 to the
*                     length of the longest element in the array de_desc.
*
* 12/14/90  FRG
*                     Added parameters "de_title", "de_noallow".  de_title lets
*                     user replace the standard "V I E W  P O R T" title with a
*                     custom one.  de_allow is a char. string made up of the
*                     first letters of any menu options the developer does not
*                     want the user to have access to. (this is good for a
*                     situation where you want to give a user 'edit' capability
*                     but not 'add' or 'delete':  de_noallow = "AD"
*
* 12/26/90  FRG
*                     Added support for a pre-edit udf "de_when[m->on_field]"
*                     to trigger a udf before an edit takes place.
*
* 01/05/91  FRG
*                     Added support for a default expression carried in
*                     "de_dflt[m->i]" to allow defaults when an "add" is issued.
* 01/05/91  FRG
*                     Added support for an array "de_reqd" that
*                     forces required input for the associated field.
*
* 01/14/91  FRG       Added support for an array "de_msg" that places a
*                     message on the 23rd line of the display for each field.
*
* 01/22/91 FRG        Made changes so that non-edit fields (de_edit[m->on_field])
*                     remain the same color as titles. In addition, while
*                     editing, the cursor skips over non-edit fields.
*----------------------
FUNCTION viewport
private allowed,de_carry,de_title,de_noallow
PARAM allowed,de_flds,de_desc,de_pics,de_msg,de_dflt,de_when,de_vals,de_looks,de_others,de_edit,de_reqd,de_carry,de_title,de_noallow
EXTERNAL ctrlw

* --- 12/14/90 Added parameter to pass a title to viewport
if type('de_title') <> 'C'
  de_title = "  VIEW  PORT  for file: "+TRIM(ALIAS())+' '
endif

* --- 12/14/90 Added parameter to disallow options by adding 1st letter to list
if type('de_noallow') <> 'C'
  de_noallow = ""
endif

*#06-06-1990 Added logical parameter for Carry

PRIVATE start_fld,db_size,nbr_rows,max_rows,prior_rec,stand,enh,unsel,last_fld
PRIVATE choice,subchoice,I,nbrmemos,_ik__,_lk__,I,tempbox,tempvar
PRIVATE trow,BROW,preview,oldcolor,tget,allowed,do_other,others
PRIVATE showbox,allowfill,Readex,getlength,atget,sgetlength
*----------------------

*#09-24-1990 Added this in to allow longer discriptions, shorter
*            gets, if needed. Adjust m->getlength to appropriate length
*            for gets display. Length of description may be adjusted
*            accordingly. Default is 45 for getlength.

desc_len = iif(type('de_desc')=='A',bigelem(de_desc),10)
getlength = 60 - desc_len

sgetlength = "@S"+alltrim(trans(m->getlength,"999"))
atget = 78-m->getlength



*****
SAVE SCREEN TO preview
Readex = Readexit(.T.)
initsup()
*- starting field
start_fld = 1
trow = 2
BROW = 22
allowfill = .F.

IF (!TYPE("m->allowed")=="L")
  allowed = .T.
ENDIF

IF (!TYPE("m->de_flds")=="A")
        private de_flds[fcount()]
        private de_desc[fcount()]
        afields(m->de_flds)
        acopy(m->de_flds,m->de_desc)
        db_size = fcount()
else
        db_size = aleng(m->de_flds)
ENDIF
PRIVATE de_types[m->db_size],de_lens[m->db_size],de_decs[m->db_size]
fillarr(m->de_flds,m->de_types,m->de_lens,m->de_decs)


IF !(TYPE("m->de_pics")=="A")
  PRIVATE de_pics[m->db_size]
  Afill(m->de_pics,"")
  for i = 1 to m->db_size
     DO CASE
     CASE de_types[m->i] == "C"
       *- make sure it fits on the screen
       *#09-24-1990 Changed test length from 59 to m->getlength
       *#           some fields were going off the screen in edit mode
       if de_lens[m->i] > m->getlength
         de_pics[m->i] = m->sgetlength
       endif
     CASE de_types[m->i] == "N"
       *- convert to a string
       if de_decs[m->i]>0
           de_pics[m->i] = REPLICATE("9",de_lens[m->i]-(de_decs[m->i]+1))+"."
           de_pics[m->i] = de_pics[m->i]+REPLICATE("9",de_decs[m->i])
       else
           de_pics[m->i] = REPLICATE("9",de_lens[m->i])
       endif
     CASE de_types[m->i] == "L"
         de_pics[m->i] = "Y"
     ENDCASE
  next
ENDIF
IF (TYPE("m->de_vals")=="A")
  FOR I = 1 TO m->db_size
    de_vals[m->i] = STRTRAN(de_vals[m->i],"@@","m->workinonit")
  NEXT
ELSE
  PRIVATE de_vals[m->db_size]
  Afill(m->de_vals,"")
ENDIF

IF !(TYPE("m->de_msg")=="A")
  PRIVATE de_msg[m->db_size]
  Afill(m->de_msg,"")
ENDIF

IF !(TYPE("m->de_dflt")=="A")
  PRIVATE de_dflt[m->db_size]
  Afill(m->de_dflt,"")
ENDIF

IF !(TYPE("m->de_when")=="A")
  PRIVATE de_when[m->db_size]
  Afill(m->de_when,"")
ENDIF


IF !(TYPE("m->de_looks")=="A")
  PRIVATE de_looks[m->db_size]
  Afill(m->de_looks,"")
ENDIF


IF (TYPE("m->de_others")=="A")
  do_other = .T.
  others = aleng(m->de_others)+1
  PRIVATE othermenu[others],otherproc[others]
  FOR I = 1 TO m->others-1
    othermenu[m->i]=takeout(de_others[m->i],';',1)
    otherproc[m->i]=takeout(de_others[m->i],';',2)
  NEXT
  othermenu[m->others]="Quit Other Menu"
  otherproc[m->others]=""
ELSE
  do_other = .F.
ENDIF

IF !(TYPE("m->de_edit")=="A")
  PRIVATE de_edit[m->db_size]
  Afill(m->de_edit,.t.)
ENDIF

IF !(TYPE("m->de_reqd")=="A")
  PRIVATE de_reqd[m->db_size]
  Afill(m->de_reqd,.f.)
ENDIF

*#06-06-1990 Added this check for the 'Carry' parameter
IF !(TYPE("m->de_carry")=="L")
   de_carry = .t.
ENDIF


*- determine # of rows in box
nbr_rows = MIN(m->db_size,m->brow-m->trow)
last_fld = m->start_fld+m->nbr_rows-1
nbrmemos = 0

PRIVATE de_work[m->db_size]
sfv_initw()

nbrmemos = akount(m->de_types,"M")
IF m->nbrmemos > 0
  PRIVATE de_memos[m->nbrmemos]
  sfv_initm()
ENDIF


*- sets
*- make F10 seem like ctrl-w
SET KEY -9 TO ctrlw

oldcolor = Setcolor(m->c_normcol)
stand = standard()
enh = enhanced()
unsel = unselected()
@ 0,15,24,79 BOX "Ŀ "
@0,18 SAY de_title
IF m->nbr_rows < m->db_size
  @24,18 SAY " Pgup Pgdn "
ENDIF
Setcolor(m->c_popcol)
@ 0,0,24,14 BOX "ͻȺ "
@18,1 SAY ""
@0,2 SAY " Menu "
* display the menu screen
*----------------------
*- main loop

*- fill in the first set of field pictures
choice = 1

sfv_says(.T.)
DO WHILE .T.
  SET CURSOR OFF
  SET COLOR TO (m->c_popmenu)
  @2,2       PROMPT "Next Record"
  @ROW()+1,2 PROMPT "Prev Record"
  @ROW()+1,2 PROMPT "Search File"
  @ROW()+1,2 PROMPT "Key Search"
  @ROW()+1,2 PROMPT "TableView"
  @ROW()+1,2 PROMPT "Hardcopy"
  @ROW()+1,2 PROMPT "Viewmemo"
  @ROW()+1,2 PROMPT "Build Query"
  @ROW()+1,2 PROMPT "Field Order"
  IF m->allowed
    @ROW()+1,2 PROMPT "Edit Record"
    @ROW()+1,2 PROMPT "Add Record"
    @ROW()+1,2 PROMPT "Memo Edit"
    @ROW()+1,2 PROMPT IIF(DELETED(),"UnDelete","Delete  ")
  ENDIF (m->allowed
  IF m->do_other
    @ROW()+1,2 PROMPT "Other Menu"
  ENDIF
  @ROW()+1,2 PROMPT "Quit"
  *#06-25-1990 Changed TRANS() to STR()
  @19,2 SAY "Rec# "
  @20,2 SAY STR(RECNO())
  @21,2 SAY "of # "
  @22,2 SAY STR(RECC())
  @23,2 SAY IIF(DELETED(),"Deleted","       ")
  MENU TO choice
  SET COLOR TO (m->c_popcol)
  DO CASE
  CASE ispart(LASTKEY(),3,18,1,6)
    sfv_disp(LASTKEY())
  CASE choice = 1                                    && next record
    IF not_allow('N')
      LOOP
    ENDIF
    SKIP
    if eof()
      go bott
    endif
    sfv_initw()
    sfv_says(.F.)
  CASE choice = 2                                    && prev record
    IF not_allow('P')
      LOOP
    ENDIF
    SKIP -1
    sfv_initw()
    sfv_says(.F.)
  CASE choice = 3                                    && search file
    IF not_allow('S')
      LOOP
    ENDIF
    searchme(m->de_flds,m->de_types,de_lens)
    KEYBOARD "@"
    INKEY()
    sfv_initw()
    sfv_says(.F.)
  CASE choice = 4                                    && key search
    IF not_allow('K')
      LOOP
    ENDIF
    tempvar = INDEXKEY(0)
    IF !EMPTY(m->tempvar)
      _ik__ = INDEXKEY(0)
      IF TYPE(m->_ik__)=="C"
        _lk__ = SPACE(MAX(LEN(&_ik__),20))
        popread(.T.,"Index key to seek (enter for LOOKUP TABLE) :",@_lk__,"")
        IF !EMPTY(m->_lk__)
          SET SOFTSEEK ON
          SEEK UPPER(m->_lk__)
          SET SOFTSEEK OFF
        ELSE
          smalls(_ik__,"Lookup Table of Key")
        ENDIF
      ENDIF
      sfv_initw()
      sfv_says(.F.)
    ELSE
      msg("No index files open - no KEY present")
    ENDIF
  CASE choice = 5                                    && table view
    IF not_allow('T')
      LOOP
    ENDIF
    showbox = makebox(0,0,24,79,Setcolor(),0)
    @2,1 TO 2,78
    @1,1 SAY "USE Up Down Right Left PGUP PGDN HOME END keys      Press ENTER when done"
    Setcolor(m->c_normcol)
    KEYBOARD CHR(0)
    INKEY()
    DBEDIT(3,1,23,78, m->de_flds,'','',de_desc)
    Setcolor(m->c_popcol)
    unbox(m->showbox)
    sfv_initw()
    sfv_says(.F.)
  CASE choice = 6                                    && hard copy
    IF not_allow('H')
      LOOP
    ENDIF
    sfv_hard()
  CASE choice = 7                                    && view memo
    IF not_allow('V')
      LOOP
    ENDIF
    IF m->nbrmemos > 0
      subchoice = 1
      IF m->nbrmemos > 1
        *#10-29-1990 Increased depth of box by one
        subchoice = mchoice(m->de_memos,2,15,3+m->nbrmemos,26,"Which Memo:")
      ENDIF
      IF subchoice = 0
        LOOP
      ENDIF
      showbox = makebox(0,15,24,79,Setcolor(),0)
      tget = de_memos[m->subchoice]
      *#10-29-1990 HARDCR() allows viewing with wordwrap done
      tget = HARDCR(&tget)
      @0,18 SAY '[VIEWING MEMO FIELD: '+de_memos[m->subchoice]+' Press ESCAPE when done]'
      Memoedit(m->tget,1,16,23,78,.F.,'',79)
      unbox(m->showbox)
    ELSE
      msg("No memo fields detected","")
    ENDIF
  CASE choice = 8                                    && build query
    IF not_allow('B')
      LOOP
    ENDIF
    QUERY(m->de_flds,m->de_desc,m->de_types,"To ViewPort")
    IF TYPE('query_exp') = 'C'
      oldcolor = Setcolor(m->c_normcol)
      IF !EMPTY(query_exp)
        SET FILTER TO &query_exp
        @ 0,66 SAY 'Query Active'
        GO TOP
        sfv_initw()
        sfv_says(.F.)
      ELSE
        @ 0,66 SAY ''
        SET FILTER TO
      ENDIF
      Setcolor(m->oldcolor)
    ENDIF
  CASE choice = 9                                    && field order
    IF not_allow('F')
      LOOP
    ENDIF
    sfv_forder()
    sfv_initw()
    IF m->nbrmemos > 0
      sfv_initm()
    ENDIF
    sfv_says(.T.)
  CASE choice = 10 .AND. m->allowed .AND. RECC()>0   && edit record
    IF not_allow('E')
      LOOP
    ENDIF
    sfv_editit(1)
    sfv_initw()
    sfv_says(.F.)
  CASE choice = 11 .AND. m->allowed                  && add record
    IF not_allow('A')
      LOOP
    ENDIF
    sfv_editit(2)
    sfv_initw()
    sfv_says(.F.)
  CASE choice = 12 .AND. m->allowed                  && memo edit
    IF not_allow('M')
      LOOP
    ENDIF
    IF m->nbrmemos > 0
      subchoice = 1
      IF m->nbrmemos > 1
        *#10-29-1990 Increased depth of box by one
        subchoice = mchoice(m->de_memos,2,15,3+m->nbrmemos,26,"Which Memo:")
      ENDIF
      *#10-29-1990 Loop if none selected to avoid crash
      IF subchoice = 0
        loop
      ENDIF
      editmemo(de_memos[m->subchoice],0,15,24,79,.t.)
    ELSE
      msg("No memo fields detected","")
    ENDIF
  CASE choice = 13 .AND. m->allowed                 && delete record
    IF not_allow('D')
      LOOP
    ENDIF
    IF DELETED()
      RECALL
    ELSE
      DELETE
    ENDIF
    sfv_initw()
  CASE (m->choice = 10.OR. m->choice=14) .AND. (m->do_other)
    *- other
    tempbox = makebox(8,6,9+m->others,6+BIGELEM(m->othermenu)+3)
    @9,8 PROMPT othermenu[1]
    FOR I = 2 TO m->others
      @ROW()+1,8 PROMPT othermenu[m->i]
    NEXT
    I = 1
    MENU TO I
    unbox(m->tempbox)
    IF m->i > 0 .AND. m->i < m->others
      tempvar = otherproc[m->i]
      I = &tempvar
    ENDIF
  OTHERWISE
    IF MESSYN("Exit Now ?")
      SET CURSOR ON
      Readexit(m->readex)
      Setcolor(m->oldcolor)
      RESTORE SCREEN FROM m->preview
      RETURN ''
    endif
  ENDCASE
ENDDO


FUNCTION sfv_disp
PARAM lkey
IF !(m->nbr_rows < m->db_size)
  RETURN ''
ENDIF
PRIVATE oldstart
oldstart = m->start_fld
Setcolor(m->c_normcol)
DO CASE
CASE m->lkey = 3
  IF  m->last_fld#m->db_size
    start_fld = m->start_fld+1
    last_fld = m->last_fld+1
    Scroll(m->trow,16,m->brow,78,1)
    prnt(m->trow+m->nbr_rows-1,17,de_desc[m->start_fld+m->nbr_rows-1],m->stand)
    if de_edit[m->start_fld+m->nbr_rows-1]
      prnt(m->trow+m->nbr_rows-1,m->atget,sfv_makep(m->start_fld+m->nbr_rows-1),m->unsel)
    else
      prnt(m->trow+m->nbr_rows-1,m->atget,sfv_makep(m->start_fld+m->nbr_rows-1),m->stand)
    endif
  ELSE
    CLEAR TYPEAHEAD
  ENDIF (m->last_fld#m->db_size
CASE m->lkey = 18
  IF m->start_fld>1
    start_fld = m->start_fld-1
    last_fld = m->last_fld-1
    Scroll(m->trow,16,m->brow-1,78,-1)
    prnt(m->trow,17,de_desc[m->start_fld],m->stand)
    if de_edit[m->start_fld]
      prnt(m->trow,m->atget,sfv_makep(m->start_fld),m->unsel)
    else
      prnt(m->trow,m->atget,sfv_makep(m->start_fld),m->stand)
    endif
  ELSE
    CLEAR TYPEAHEAD
  ENDIF (m->start_fld>1
ENDCASE
Setcolor(m->c_popcol)
RETURN ''



FUNCTION sfv_says

PARAM saystoo

PRIVATE kounter,curr_row,oldcol
oldcol = Setcolor(m->c_normcol)

curr_row = m->trow
IF m->saystoo
  Scroll(m->trow,16,m->brow,78,0)
  FOR m->kounter = m->start_fld TO m->last_fld
    *- say the description
    @m->curr_row,17 SAY de_desc[m->kounter]
    m->curr_row = m->curr_row+1
  NEXT
ENDIF
Setcolor(takeout(Setcolor(),',',5))
curr_row = m->trow
FOR m->kounter = m->start_fld TO m->last_fld
  *- simulate a get field in unselected color
  if de_edit[m->kounter]
    Setcolor(takeout(Setcolor(),',',5))
  else
    Setcolor(m->c_normcol)
  endif
  @m->curr_row,m->atget SAY sfv_makep(m->kounter)
  m->curr_row = m->curr_row+1
NEXT
Setcolor(m->oldcol)
RETURN ''

FUNCTION sfv_makep
PARAM nbr
IF de_types[M->NBR]=="M"
  RETURN "(MEMO)"
ELSEIF de_types[M->NBR]=="C"
  RETURN LEFT(de_work[m->nbr],m->getlength)
ELSE
  RETURN TRANS(de_work[m->nbr],de_pics[m->NBR])
ENDIF

FUNCTION sfv_forder
PRIVATE pk,pos,sel,tmp,pk2
PRIVATE tmp[7]
pk = makebox(2,9,21,65)
@ 2,28 SAY ""
@ 18,9 SAY ''
@ 21,28 SAY ""
@ 3,28 SAY "  Field Viewing Order:"
@ 4,28 SAY ""
@ 5,28 SAY " The fields for this datafile may"
@ 6,28 SAY " be viewed in any order.      "
@ 7,28 SAY ""
@ 8,28 SAY " "
@ 9,28 SAY " "
@ 10,28 SAY ""
@ 11,28 SAY " Press ENTER to select a field to"
@ 12,28 SAY " move. You will be prompted for the"
@ 13,28 SAY " position to move it to."
@ 14,28 SAY ""
@ 15,28 SAY ""
@ 16,28 SAY ""
@ 17,28 SAY ""
@ 18,10 SAY "Ĵ"
@ 19,28 SAY " Press ESCAPE when done."
@ 20,10 SAY "Total Fields:     "
@ 20,23 SAY LTRIM(STR(m->db_size))
pos = 1
sel = 1
DO WHILE .T.
  sel = m->pos
  sel = ACHOICE(4,12,17,27,m->de_desc)
  IF m->sel = 0
    EXIT
  ENDIF
  SET CURSOR ON
  @ 19,10 SAY "New position:" GET m->pos PICT "99"
  READ
  @ 19,10 SAY "                 "
  SET CURSOR OFF
  IF m->pos <= 0
    pos = 1
  ELSEIF m->pos > m->db_size
    pos = m->db_size
  ENDIF
  
  sfv_ashift(m->de_flds,m->sel,m->pos)
  sfv_ashift(m->de_desc,m->sel,m->pos)
  sfv_ashift(m->de_types,m->sel,m->pos)
  sfv_ashift(m->de_lens,m->sel,m->pos)
  sfv_ashift(m->de_pics,m->sel,m->pos)
  sfv_ashift(m->de_vals,m->sel,m->pos)
  sfv_ashift(m->de_looks,m->sel,m->pos)
  *#06-21-1990 Added this line to sort the Edit/Display array
  sfv_ashift(m->de_edit,m->sel,m->pos)
  pos = m->pos+1
ENDDO
unbox(m->pk)
RETURN ''

FUNCTION sfv_ashift
PARAM ar,cur,new
PRIVATE I,END
PRIVATE tmp
tmp = ar[m->cur]
IF m->cur > m->new
  I = m->cur
  DO WHILE m->i > m->new
    ar[m->i] = ar[(m->i-1)]
    I = m->i-1
  ENDDO
  ar[m->new] = m->tmp
ELSEIF m->cur < m->new
  END = m->new-1
  FOR I = m->cur TO m->end
    ar[m->i] = ar[m->i+1]
  NEXT
  ar[m->new] = m->tmp
ENDIF
RETURN ''




FUNCTION sfv_initw
FOR m->i = 1 TO m->db_size
  f_ie_ld_name =  de_flds[m->i]
  IF de_types[m->i]$"CNDL"
    de_work[m->i] = &f_ie_ld_name
    m_dflt = trim(de_dflt[m->i])
    IF !empty(m_dflt) .and. EOF()
      de_work[m->i] = &m_dflt
    ENDIF
  ENDIF
NEXT
RETURN ''


FUNCTION sfv_editit
PARAM edit_add
PRIVATE adding,kounter,f_ie_ld_name
PRIVATE on_field,curr_row,LASTKEY,recnbr,tempvar
PRIVATE valclause,valmsg,workinonit,preord

Setcolor(m->c_normcol)

adding = (m->edit_add = 2)
IF m->adding
  recnbr = RECNO()
  GO BOTT
  SKIP 1
  *#06-06-1990 Added this check for the 'Carry' parameter, and also
  *#           now defaults to No.
  IF RECC()>0 .and. m->de_carry
    IF !messyn("Carry contents of current record forward?","No","Yes")
      GO m->recnbr
    ENDIF
  ENDIF
  sfv_initw()
  IF m->recnbr > 0
    GO m->recnbr
  ENDIF
ENDIF


start_fld = 1
last_fld = m->start_fld+m->nbr_rows-1

sfv_says(.T.)

on_field = 1
curr_row = m->trow

DO WHILE .T.
  Setcolor(m->c_normcol)
  SET CURSOR ON
  SET KEY -1 TO sfv_lookup
  workinonit = de_work[m->on_field]
  IF !EMPTY(de_looks[m->on_field])
    @24,18 SAY " F10 to save       ESC to cancel       F2 for Lookup "
  ELSE
    @24,18 SAY " F10 to save       ESC to cancel "
  ENDIF
  @ 23,17 say space(60)
  @ 23,17 say de_msg[m->on_field]
  IF de_types[m->on_field]=="M"
    IF de_edit[m->on_field] .and. !m->adding
      workinonit = "N"
      @m->curr_row,m->atget+7 GET m->workinonit PICT "Y"
      @m->curr_row,m->atget+9 SAY "Press Y to Edit memo"
      READ
      @m->curr_row,m->atget+7 SAY "                           "
      IF UPPER(m->workinonit)=="Y"
        editmemo(de_flds[m->on_field],1,16,23,78,.t.)
        LOOP
      ENDIF
    ELSE
      prnt(m->curr_row,m->atget+7,"",m->enh)
      @m->curr_row,m->atget+9 SAY "MEMO - save record first"
      @m->curr_row,m->atget+7 SAY ""
      INKEY(0)
      @m->curr_row,m->atget+7 SAY "                           "
    ENDIF
  ELSEIF EMPTY(de_vals[m->on_field])
    IF de_edit[m->on_field]
      when_udf = IIF(EMPTY(de_when[m->on_field]),'.T.',de_when[m->on_field])
      when_cond = &when_udf
      when_cond = iif(type("when_cond")=="L",when_cond,.T.)
      IF when_cond
        @m->curr_row,m->atget GET m->workinonit PICT de_pics[m->on_field]
        READ
        IF empty(m->workinonit) .and. de_reqd[m->on_field] .and. !ispart(LASTKEY(),27,23)
          msg(5,"Required field, cannot be left blank!")
          LOOP
        ENDIF
      ENDIF
    ELSE
*     prnt(m->curr_row,m->atget,sfv_makep(m->on_field),m->enh)
*     INKEY(0)
    ENDIF
  ELSE
    IF de_edit[m->on_field]
      valclause = takeout(de_vals[m->on_field],';',1)
      valmsg = takeout(de_vals[m->on_field],';',2)
      when_udf = IIF(EMPTY(de_when[m->on_field]),'.T.',de_when[m->on_field])
      when_cond = &when_udf
      when_cond = iif(type("when_cond")=="L",when_cond,.T.)
      IF when_cond
        @m->curr_row,m->atget GET m->workinonit PICT de_pics[m->on_field] ;
        VALID genval(m->valclause,m->valmsg)
        READ
        IF empty(m->workinonit) .and. de_reqd[m->on_field] .and. !ispart(LASTKEY(),27,23)
          msg(5,"Required field, cannot be left blank!")
          LOOP
        ENDIF
      ENDIF
    ELSE
*     prnt(m->curr_row,m->atget,sfv_makep(m->on_field),m->enh)
*     INKEY(0)
    ENDIF
  ENDIF
  de_work[m->on_field] = m->workinonit
  SET KEY -1 TO
  if de_edit[m->on_field]
    prnt(m->curr_row,m->atget,sfv_makep(m->on_field),m->unsel)
  else
    prnt(m->curr_row,m->atget,sfv_makep(m->on_field),m->stand)
  endif
  DO CASE
  CASE ispart(LASTKEY(),18,5)
    *- decrease field, minimum 1
    IF m->on_field > 1
      on_field = m->on_field-1
      IF m->curr_row = m->trow
        sfv_disp(18)
      ELSE
        curr_row = m->curr_row-1
      ENDIF
    ELSEIF !de_edit[m->on_field]
      keyboard chr(24)
      inkey(1)
    ENDIF
  CASE ispart(LASTKEY(),27,23)
    EXIT
  OTHERWISE
    IF m->on_field<m->db_size
      on_field = m->on_field + 1
      IF m->curr_row = m->brow-1
        sfv_disp(3)
      ELSE
        curr_row = m->curr_row+1
      ENDIF
    ELSE
     *#06-06-1990 Added this to catch going past last field with
     *            cursor or ENTER key. Check for if done.
     IF MESSYN("Done?")
       exit
     endif
     if !de_edit[m->on_field]
       keyboard chr(5)
       inkey(1)
     endif
    ENDIF
  ENDCASE
ENDDO
Setcolor(m->c_normcol)
@24,18 TO 24,78
IF m->nbr_rows < m->db_size
  @24,18 SAY " Pgup Pgdn "
ENDIF
*#06-06-1990 Changed from lastkey()=23 to !lastkey()=27
@ 23,17 say space(60)
IF !LASTKEY() = 27
  IF messyn("Save changes ?")
    IF m->adding
      APPEND BLANK
    ENDIF
    preord = INDEXORD()
    SET ORDER TO 0
    FOR I = 1 TO m->db_size
      IF de_edit[m->i] .AND. (!de_types[m->i]=="M")
        tempvar = de_flds[m->i]
        REPLACE &tempvar WITH de_work[m->i]
      ENDIF
    NEXT
    SET ORDER TO (m->preord)
  ENDIF
ENDIF
RETURN ''


FUNCTION sfv_lookup
PRIVATE I,temp,lookstrng,sparams
IF !EMPTY(de_looks[m->on_field])
  lookstrng = de_looks[m->on_field]
  PRIVATE l_array[4]
  sparams = 0
  FOR I = 1 TO 4
    temp = takeout(m->lookstrng,';',m->i)
    IF EMPTY(m->temp)
      EXIT
    ENDIF
    l_array[m->i] = m->temp
    sparams = m->sparams+1
  NEXT
  DO CASE
  CASE m->sparams = 1
    smalls(l_array[1])
  CASE m->sparams = 2
    smalls(l_array[1] ,l_array[2])
  CASE m->sparams = 3
    smalls(l_array[1] ,l_array[2],l_array[3])
  CASE m->sparams = 4
    smalls(l_array[1] ,l_array[2],l_array[3],l_array[4])
  ENDCASE
ELSE
  msg("No lookup defined for this field..")
ENDIF
RETURN ''

FUNCTION sfv_initm
PRIVATE kounter,I,fc
kounter = 0
*#08-13-1990 Changed from FCOUNT() to db_size
fc = m->db_size
FOR m->i = 1 TO m->fc
  IF de_types[m->i] = "M"
    kounter = m->kounter + 1
    de_work[m->i] = "(memo)"
    de_memos[m->kounter] = de_flds[M->i]
  ENDIF
NEXT

FUNCTION sfv_hard
PRIVATE aspect,pmemo,I,mlines,target,_to_file_
aspect = 1
target = 1

DO WHILE .T.
  IF m->nbrmemos > 0
    aspect = menu_v("Hardcopy of:","Current record   ","Attached Memo field ")
    IF m->aspect = 0
      EXIT
    ENDIF
  ENDIF
  target = menu_v("Send hardcopy to:","Printer           ","Text File")
  IF m->target = 0
    EXIT
  ENDIF
  IF m->target = 1
    _SUPERPRN= prnport()
    IF !p_ready(m->_SUPERPRN)
      EXIT
    ENDIF
  ELSE
    _to_file_ = SPACE(12)
    popread(.F.,"File to send output to ",@_to_file_,"@N")
    IF EMPTY(m->_to_file_)
      EXIT
    ENDIF
    IF FILE(m->_to_file_)
      IF !messyn("File "+m->_to_file_+" exists, and will be overwritten. Continue ?")
        LOOP
      ENDIF
    ENDIF
    SET PRINTER TO &_to_file_
  ENDIF
  SET PRINT ON
  IF m->aspect = 1
    SET CONSOLE OFF
    FOR I = 1 TO m->db_size
      ?addspace(de_desc[m->i],desc_len)+': '
      _the_field_ = de_flds[m->I]
      IF de_types[M->i]=="M"
        ??"(memo)"
      ELSEIF de_types[M->i]=="C"
        ??LEFT(&_the_field_,79-(desc_len+2))
      ELSE
        ??TRANS(&_the_field_,de_pics[m->I])
      ENDIF
      IF (m->i%60)=0
        EJECT
      ENDIF ((m->i%60)=0
    NEXT
    IF (m->i%60)<>0
      EJECT
    ENDIF ((m->i%60)<>0
  ELSE
    IF m->nbrmemos > 1
      I = mchoice(m->de_memos,8,27,15,54,"Memo field to print")
      IF m->i = 0
        RETURN ''
      ENDIF
      pmemo = de_memos[m->i]
    ELSE
      pmemo = de_memos[1]
    ENDIF
    pmemo = &pmemo
    mlines = MLCOUNT(m->pmemo,79)
    SET CONSOLE OFF
    IF !EMPTY(m->pmemo)
      FOR m->i = 1 TO m->mlines
        ?MEMOLINE(m->pmemo,79,I)
        IF (m->i%60)=0
          EJECT
        ENDIF ((m->i%60)=0
        
      NEXT
      IF (m->i%60)<>0
        EJECT
      ENDIF ((m->i%60)<>0
    ELSE
      msg("This memo field is empty")
    ENDIF
  ENDIF (m->aspect = 1
  SET PRINTER TO (m->_SUPERPRN)
  SET PRINT OFF
  SET CONSOLE ON
  EXIT
ENDDO
RETURN ''

FUNCTION not_allow
private first_char
parameters first_char
if first_char $ de_noallow
  msg(5,"Option not available for this screen")
  return .t.
endif
return .f.


*: EOF: S_VIEWP.PRG

