*  
*  
*  
*  ĳ  
*     Frank R. Genus, Jr. & Associates
*              Copyright (c) 1991, All rights reserved  (yea, right!)

* Program.....: vptest.prg
* Purpose.....: test of modified viewport functions w/ data dictionary
* System......: n/a
* Version.....: Clipper Summer '87 Edition
* Author......: Frank R. Genus, Jr.
* Date written: 01/07/91
* Notes.......: Requires super.lib 2.0
*               Assumes dbf files: names.dbf, states.dbf, dictflds.dbf and
*               their associated index files are available.

* Modification Log:

* Date      Rev    By                   Description
* -----------------------------------------------------------------------------
* 01/07/91  1.0a   Frank R. Genus, Jr.  Initial Creation
* -----------------------------------------------------------------------------

* --- initialize metafunctions
initsup()

* --- set environment
SET TALK OFF
SET ECHO OFF
SET CONFIRM OFF
SET BELL OFF
SET SAFETY OFF
SET SCOREBOARD OFF
SET TYPEAHEAD TO 50
SET DELETED ON
EXTERNAL proper
EXTERNAL lookup

* --- define default area code (for default expression in phone # dict entry)
dflt_area = "908"

* --- open database & index files
plswait(.t.,'Please Wait, Opening data files...')
close data
select 0
use names
set index to names
select 0
use states
set index to states
select names
plswait(.f.)

* --- load data dictionary information into arrays, then call viewport
dict_array('names')
select names
viewport(.t.,m->field_name,m->field_desc,m->field_pict,m->field_msg,m->field_dflt,m->field_when,m->field_val,m->field_look,"",m->field_edit,m->field_reqd,.f.," Our Little Test Database ","S")
close data
quit
* --- tttttthats all folks!


FUNCTION dict_array
* --- checks the field dictionary for file name passed in 'dbf_file', if found
*     populates all arrays from dictionary.  If not found, populates
*     field_name, field_desc, field_type, and field_len from the file itself.

parameters dbf_file
plswait(.t.)
dbf_file = upper(trim(dbf_file))
select 0
use dictflds
set index to dictfld1

public fcount
fcount = 0
seek m->dbf_file
if found()
  do while trim(file_name) == m->dbf_file .and. !eof()
    fcount = iif(field_tag,fcount + 1,fcount)
    skip
  enddo
endif

public field_name[fcount],field_desc[fcount],field_type[fcount],field_len[fcount]
public field_pict[fcount],field_msg[fcount],field_dflt[fcount],field_when[fcount]
public field_val[fcount],field_look[fcount],field_edit[fcount],field_reqd[fcount]

seek m->dbf_file
if found()
  x = 1
  do while trim(file_name) == m->dbf_file .and. !eof()
    if field_tag
      field_name[x] = trim(field_name)
      field_desc[x] = trim(field_desc)
      field_type[x] = trim(field_type)
      field_len[x]  = field_len
      field_pict[x] = trim(field_pict)
      field_msg[x]  = trim(field_msg)
      field_dflt[x] = trim(field_dflt)
      field_when[x] = trim(field_when)
      field_val[x]  = trim(field_val)
      field_look[x] = trim(field_look)
      field_edit[x] = field_edit
      field_reqd[x] = field_reqd
      x = iif(x>=fcount,fcount,x+1)
    endif
    skip
  enddo
  use
else
  select &dbf_file
  public fcount
  public field_name[fcount()],field_desc[fcount()],field_type[fcount()]
  public field_len[fcount()],field_pict[fcount()],field_msg[fcount()]
  public field_dflt[fcount()],field_when[fcount()],field_val[fcount()]
  public field_look[fcount()],field_edit[fcount()],field_reqd[fcount()]
  afields(field_name,field_type,field_len)
  afields(field_desc)
  fcount = fcount()
endif
plswait(.f.)
return .t.


FUNCTION lookup
* --- performs a lookup on an open, unselected table.
*     can allow/disallow blanks
*     can pass a udf to be performed after lookup. (udf must return .t. or .f.)

private _nullok,_object,_table,_function
private old_alias,ret_value
parameters _nullok,_object,_table,_function

if empty(_object) .and. _nullok
  return .t.
endif

old_alias = alias()
ret_value = .f.
select &_table
seek _object
if found()
  ret_value = .t.
  if pcount() >3
    ret_value = &_function
  endif
endif
go top
select &old_alias
return ret_value


FUNCTION dupcheck
* --- checks for duplicate key based on 'key_expr'.

private rec_no,key_expr,ret_value
parameters key_expr
rec_no = recno()
ret_value = .t.
seek key_expr
if found()
  if adding .or. !(recno() == rec_no)
    ret_value = .f.
  endif
endif
goto rec_no
return ret_value


