*
* file = vlitebar.prg
* Vertical lite bar screen generator for dbase III
* ADAPTED from "Dbase III Plus programming techniques", page 82
* (c) 1986 Cary N. Prague
* Except this version is expanded & "improved" - a relative notion at best
*
* G.L. Peterson - If you can take this little bit of work and found a
* financial empire on it, more power to you. Any money you make with it
* belongs to you. I s'pose Cary may feel differently....
*
* To nest these menues, use a word processor to globally change 'M1' to
* Mn where 'n' corresponds to a unique number for this menu. This will
* insure unique variable names from menu to menu.
*



CLEAR
SET TALK OFF
SET ECHO OFF
SET ESCAPE OFF

* THIS IS THE CONFIGURATION DATA FOR THE MENU SYSTEM
******************************************************************************

* SET THE MENU TITLE(S) HERE
STORE "ABC CORPORATION CUSTOMER CREDIT SYSTEM" TO M1TITLE1
STORE "--------------------------------------" TO M1TITLE2

* SET THE MENU FOOTERS (OPERATOR INSTRUCTIONS, ETC. HERE)
STORE "USE ARROW KEYS TO MOVE HIGHLIGHT AND 'ENTER' TO SELECT ITEM" TO M1FOOT1
STORE "OR SELECT INPUT BY MENU NUMBER, OR OPTION 1ST LETTER" TO M1FOOT2

* SET TO THE MAX NUMBER OF MENU ITEMS
M1MENUMAX = 6

* SET THE MENU ITEM TITLES TO DISPLAY
STORE "1. ADD CUSTOMER RECORDS"    TO M1MSG1
STORE "2. CHANGE CUSTOMER RECORDS" TO M1MSG2
STORE "3. DELETE CUSTOMER RECORDS" TO M1MSG3
STORE "4. VIEW CUSTOMER RECORDS"   TO M1MSG4
STORE "5. PRINT CUSTOMER RECORDS"  TO M1MSG5
STORE "6. EXIT SYSTEM"             TO M1MSG6

* SET THE 1ST LETTER OF EACH MENU OPTION FOR OPERATOR SELECTION
STORE "A"            TO M1LET1
STORE "C"            TO M1LET2
STORE "D"            TO M1LET3
STORE "V"            TO M1LET4
STORE "P"            TO M1LET5
STORE "E"            TO M1LET6

* SET THE ACTIONS TO TAKE FOR EACH MENU ITEM SELECTED
STORE "DO ADD"        TO M1ACT1
STORE "DO CHANGE"     TO M1ACT2
STORE "DO DELETE"     TO M1ACT3
STORE "DO VIEW"       TO M1ACT4
STORE "DO PRINT"      TO M1ACT5
STORE "M1MNUCK = .F." TO M1ACT6

* SET THE DEFAULT MENU ITEM YOU WANT HIGHLIGHTED INITIALLY HERE
M1SEL = 1

* SET THE LEFT MARGIN OF THE MENU HERE
M1LMAR = 25

******************************************************************************


* PAINT THE SCREEN
CLEAR

* DRAW A PLEASING BOX FOR OPERATOR INPUTS
@  4, 1 TO  4, 78
@ 20, 1 TO 20, 78
@  1, 0 TO 23, 79 DOUBLE

* DISPLAY THE MENU TITLE(S)
@ 2, (80 - LEN(M1TITLE1))/2 SAY M1TITLE1
@ 3, (80 - LEN(M1TITLE2))/2 SAY M1TITLE2

* DISPLAY THE FOOTERS
@ 21, (80 - LEN(M1FOOT1))/2 SAY M1FOOT1
@ 22, (80 - LEN(M1FOOT2))/2 SAY M1FOOT2

* DISPLAY THE MENU OPTIONS
@  6, M1LMAR SAY M1MSG1
@  8, M1LMAR SAY M1MSG2
@ 10, M1LMAR SAY M1MSG3
@ 12, M1LMAR SAY M1MSG4
@ 14, M1LMAR SAY M1MSG5
@ 16, M1LMAR SAY M1MSG6




* MAIN MENU LOOP: DISPLAY THE SCREEN & GET A RESPONSE
M1LSTSEL = M1MENUMAX
M1MNUCK = .T.
DO WHILE M1MNUCK

  * PAINT OVER LAST HIGHLIGHTED MENU ITEM IN NORMAL MODE
  STORE 'M1MSG' + STR(M1LSTSEL, 1) TO M1MSGNUM
  @ M1LSTSEL * 2 + 4, M1LMAR SAY &M1MSGNUM

  * AND HIGHLIGHT NEW MENU ITEM
  SET COLOR TO N/W+
  STORE 'M1MSG' + STR(M1SEL, 1) TO M1MSGNUM
  @ M1SEL * 2 + 4, M1LMAR SAY &M1MSGNUM


  SET COLOR TO


  * FETCH THE OPERATOR KEYBOARD INPUT
  M1OPIN = 0
  DO WHILE M1OPIN = 0
    M1OPIN = INKEY()
  ENDDO

  * AGE THE SELECTION NUMBER
  M1LSTSEL = M1SEL

  * HANDLE OPERATOR INPUT OF ARROW KEYS
  DO CASE

    * HOME KEY, SELECT THE 1ST OPTION
    CASE M1OPIN = 1
      M1SEL = 1

    * END KEY, GO TO THE LAST OPTION
    CASE M1OPIN = 6
      M1SEL = 6

    * DOWN ARROW KEY, HIGHLITE THE NEXT OPTION (WITH ROLLOVER)
    CASE M1OPIN = 24
      IF M1SEL = M1MENUMAX
        M1SEL = 1
      ELSE
        M1SEL = M1SEL + 1
      ENDIF

    * UP ARROW KEY, HIGHLITE THE PREVIOUS OPTION (WITH ROLLOVER)
    CASE M1OPIN = 5
      IF M1SEL = 1
        M1SEL = M1MENUMAX
      ELSE
        M1SEL = M1SEL - 1
      ENDIF

    * HANDLE OPERATOR SELECTION OF HIGHLITED OPTION BY C/R INPUT
    CASE M1OPIN = 13
      M1MNUCK = .F.
      DO CASE
        CASE M1SEL = 1
          &M1ACT1

        CASE M1SEL = 2
          &M1ACT2

        CASE M1SEL = 3
          &M1ACT3

        CASE M1SEL = 4
          &M1ACT4

        CASE M1SEL = 5
          &M1ACT5

        CASE M1SEL = 6
          &M1ACT6

      ENDCASE

      * HANDLE OPERATOR SELECTION BY INPUTING 1ST LETTER OF THE COMMAND
      CASE UPPER (CHR(M1OPIN)) $ "&M1LET1&M1LET2&M1LET3&M1LET4&M1LET5&M1LET6"
        M1MNUCK = .F.
        DO CASE
          CASE UPPER(CHR(M1OPIN)) $ "&M1LET1"
            &M1ACT1

          CASE UPPER(CHR(M1OPIN)) $ "&M1LET2"
            &M1ACT2

          CASE UPPER(CHR(M1OPIN)) $ "&M1LET3"
            &M1ACT3

          CASE UPPER(CHR(M1OPIN)) $ "&M1LET4"
            &M1ACT4

          CASE UPPER(CHR(M1OPIN)) $ "&M1LET5"
            &M1ACT5

          CASE UPPER(CHR(M1OPIN)) $ "&M1LET6"
            &M1ACT6

        ENDCASE

 
      * HANDLE OPERATOR SELECTION BY INPUTING MENU ITEM NUMBER
      CASE CHR(M1OPIN) $ "123456"
        M1MNUCK = .F.
        DO CASE
          CASE CHR(M1OPIN) $ "1"
            &M1ACT1

          CASE CHR(M1OPIN) $ "2"
            &M1ACT2

          CASE CHR(M1OPIN) $ "3"
            &M1ACT3

          CASE CHR(M1OPIN) $ "4"
            &M1ACT4

          CASE CHR(M1OPIN) $ "5"
            &M1ACT5

          CASE CHR(M1OPIN) $ "6"
            &M1ACT6

        ENDCASE

      * HANDLE OPERATOR INPUT OF 'ESC' KEY - EXIT MENU
      CASE M1OPIN = 27
        M1MNUCK = .F.

      * UNKNOWN INPUT, COMPLAIN BY BEEPING BELL & LOOP
      OTHERWISE
        ? CHR(7)

    ENDCASE
  ENDDO M1MNUCK

CLEAR
RELEASE ALL LIKE M1*
RETURN

