FUNCTION Vin
*-----------------------------------------------------------------------------
*-- Programmer..: Ferdinand Trauttmansdorff (73607,1443)
*-- Date........: 11/04/92
*-- Notes.......: VIN CHECKER.  Returns .T. if the Vehicle Identification
*--               Number's Check Digit calculates properly.  Returns .F. if
*--               Check Digit does not match, or invalid characters are
*--               entered, or VIN is incorrect length.
*--               If parameter2 (lDetail) is set to .T., the function will
*--               pause and display detailed error messages in a window,
*--               or if VIN is valid, will decode and display the Model Year
*--               of the valid VIN.  If (lDetail) is set to .F. or omitted,
*--               the VIN() function will display no messages, but will
*--               simply return a .T. or .F. for a valid or invalid VIN.
*-- Written for.: dBASE IV, 1.5
*-- Rev. History: None
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: Vin(<cVin>,<lDetail>)
*-- Example.....: ? Vin("1FTCR10A9NTA00294",.T.)
*-- Returns.....: Logical
*-- Parameters..:    cVin = Vehicle Identificatiion Number
*--               lDetail = .T. or .F. flag for messages. (can be omitted)
*-----------------------------------------------------------------------------
parameters cVin, lDetail
private lDetail
private cVin,cChr,cChkDgt,cYr
private n,nVal,nFactor,nSum,nModYr
define window wMsg from 5,20 to 16,51 color w+/r

nFactor = "0807060504030210000908070605040302"
   nSum = 0

if len(cVin)<>17       && check length of VIN
  if lDetail=.T.
      activate window wMsg
      @ 0,12 say "ERROR" color gr+/b
      if len(cVin)>19
        @ 2,5 say "-"+left(cVin,19)+"..."+"-"  && if too big for window
      else
        @ 2,5 say "-"+cVin+"-"
      endif
      @ 4,2 say "This VIN has "+ltrim(str(len(cVin)))+ " characters."
      @ 6,3 Say "VIN needs 17 characters."
      ?
      wait
      release window wMsg
  endif
  RETURN (.F.)
endif

n=1
do while n<=17			&& do for each of 17 characters
  cChr=substr(cVin,n,1)
  if cChr<"0";
   .or. cChr>"Z";
   .or. (cChr>=":" .and. cChr<="@");
   .or. cChr="I";
   .or. cChr="O";
   .or. cChr="Q"		&& check for first non-valid character
	if lDetail=.T.
		activate window wMsg
		@ 0,12 say "ERROR" color gr+/b
		@ 1,5 say "-"+cVin+"-"
		@ 2,n+5 say "^" color gr+*/r
		@ 3,1 say '"'+cChr+'"'+" is an illegal character."
		@ 5,2 say "Allowable characters are:"
		@ 6,6 say '"1234567890"'+", or"
		@ 7,2 say '"ABCDEFGHJKLMNPRSTUVWXYZ"'
		?
		wait
		release window wMsg
	endif
	RETURN (.F.)
  endif

  do case         && assign numeric value to character
    case cChr>="0" .and. cChr<="9"
      nVal=val(cChr)        && numerics 0-9
    case cChr<="H"
      nVal=asc(cChr)-64           && A-H gets 1-8
    case cChr>="J" .And. cChr<="R"
      nVal=asc(cChr)-73           && J-R gets 1-9
    otherwise
      nVal=asc(cChr)-81           && S-Z gets 2-9
  endcase

  nSum=nSum+nVal*val(substr(nFactor,n*2-1,2))
  n=n+1
enddo

cYr=substr(cVin,10,1)       && check for non-valid model year characters
if cYr="0" .or. cYr="U" .or. cYr="Z"
	if lDetail=.T.
		activate window wMsg
		@ 0,12 say "ERROR" color gr+/b
		@ 2,5 say "-"+cVin+"-"
		@ 3,15 say "^" color gr+*/r
		@ 4,6 say "In this position,"
		@ 5,1 say '"'+cYr+'"'+" is an illegal character."
		?
		wait
		release window wMsg
	endif
	RETURN (.F.)
endif

************* Calculate Check Digit *******************
cChkDgt=ltrim(str(int(((nSum/11)-int(nSum/11))*11)))
if cChkDgt="10"
      cChkDgt="X"
endif
if cChkDgt<>substr(cVin,9,1)       && Compare Check Digit
	if lDetail=.T.
		activate window wMsg
		@ 0,12 say "ERROR" color gr+/b
		@ 2,5 say "-"+cVin+"-"
		@ 3,14 say "^" color gr+*/r
		@ 5,3 say "Check Digit is incorrect."
		?
		wait
		release window wMsg
	endif
	RETURN (.F.)
endif

********** Calculate Model Year ****************
if lDetail=.T.
	do case
	  case cYr=>"A" .and. cYr<="H"
		nModYr=asc(cYr)+1915
	  case cYr=>"J" .and. cYr<="N"
		nModYr=asc(cYr)+1914
	  case cYr="P"
		nModYr=1993
	  case cYr=>"R" .and. cYr<="T"
		nModYr=asc(cYr)+1912
	  case cYr=>"V" .and. cYr<="Y"
		nModYr=asc(cYr)+1911
	  case cYr=>"1" .and. cYr<="9"
		nModYr=asc(cYr)+1952
	endcase
	cYr=ltrim(str(nModYr))
	activate window wMsg
	@ 0,7 say "Check Digit OK" color gr+/b
	@ 2,5 say "-"+cVin+"-"
	@ 4,6 say "Vehicle Model Year"
	@ 5,8 say "indentified as"
	@ 6,12 say '"'+cYr+'"'
	?
	wait
	release window wMsg
endif

RETURN (.T.)
*--EoF: Vin
