***************************** Clipper, Summer '87 ***************************
*
*  File Name:  VIDEOCLP.PRG
*  File Type:  Clipper Source Code File
*
*  Compiler:   Clipper, Summer '87
*
*  Author:     Bob Falk
*  Company:    Falk Data Systems
*
*  --------------------------------------------------------------------------
*
*  Purpose:  This small program demonstrates the use of the assembly  
*            language UDF called VideoID (VideoID.OBJ).
*
*

CLEAR
? "VideoClp:  Demonstrates using the external assembly language"
? "           VideoID function."
?
? "The VideoID function returns the following possible values:"
?
? "     Adapter Type:  0 = None (not installed)"
? "                    1 = MDA  (Monochrome Display Adapter)"
? "                    2 = CGA  (Color Graphics Adapter)"
? "                    3 = EGA  (Enhanced Graphics Adapter)"
? "                    4 = MCGA (Multi-Color Graphics Array)"
? "                    5 = VGA  (Video Graphics Array)"
? "                    6 = HGC  (Hercules Monochrome Graphics Card)"
? "                    7 = HGC+ (Hercules Monochrome Graphics Card Plus)"
? "                    8 = Hercules InColor Card"
? 
? "     Monitor type:  0 = None (not installed)"
? "                    1 = Monochrome"
? "                    2 = Color"
? "                    3 = EGA Compatible Color"
? "                    4 = PS/2 Compatible Monochrome"
? "                    5 = PS/2 Compatible Color"
?

WAIT "Press any key to see this system's video hardware configuration..."

CLEAR

? "VideoClp:  Demonstration program for VideoID function."
?
?
? "Video hardware installed in this system:"
?
? "     First Adapter:  " + AdapName( 1 )
?? "    First Monitor:  " + VideoName( 2 )
?
? "     Second Adapter:  " + AdapName( 3 )
?? "    Second Monitor:  " + VideoName( 4 )
?
? "-------------------------------------------------------------------------------"
?
? "Calling examples (to determine):"
?
? "     First Adapter Type:   MemVar = VideoID( 1 )"
? 
? "     First Monitor Type:   MemVar = VideoID( 2 )"
? 
? "     Second Adapter Type:  MemVar = VideoID( 3 )"
? 
? "     Second Monitor Type:  MemVar = VideoID( 4 )"
?
?
? "Happy Clipping! from  -=[Falk Data Systems]=-"
?

QUIT


**************************************** UDF()
*
*    Function:  AdapName()
*
* Description:  Demonstrates the use of the VideoID function.
*
*               This function converts the adapter value returned
*               by the VideoID function to a character string.

FUNCTION AdapName

  PARAMETERS ParamNum                   && Get passed parameter value

  PRIVATE RetNum                        && Variable to hold returned number
  PRIVATE RetStr                        && Variable to hold function return

  RetNum = VideoID( ParamNum )          && Call VideoID with number

  DO CASE

    CASE RetNum = 0
      RetStr = "not installed (none)"

    CASE RetNum = 1
      RetStr = "MDA"

    CASE RetNum = 2
      RetStr = "CGA"

    CASE RetNum = 3
      RetStr = "EGA"

    CASE RetNum = 4
      RetStr = "MCGA"

    CASE RetNum = 5
      RetStr = "VGA"

    CASE RetNum = 6
      RetStr = "HGC"

    CASE RetNum = 7
      RetStr = "HGC Plus"

    CASE RetNum = 8
      RetStr = "Hercules InColor Card"

  ENDCASE

RETURN RetStr



**************************************** UDF()
*
*    Function:  VideoName()
*
* Description:  Demonstrates the use of the VideoID function.
*
*               This function converts the monitor value returned
*               by the VideoID function to a character string.

FUNCTION VideoName

  PARAMETERS ParamNum                   && Get passed parameter value

  PRIVATE RetNum                        && Variable to hold returned number
  PRIVATE RetStr                        && Variable to hold function return

  RetNum = VideoID( ParamNum )          && Call VideoID with number

  DO CASE

    CASE RetNum = 0
      RetStr = "not installed (none)"

    CASE RetNum = 1
      RetStr = "Monochrome"

    CASE RetNum = 2
      RetStr = "Color"

    CASE RetNum = 3
      RetStr = "EGA Compatible Color"

    CASE RetNum = 4
      RetStr = "PS/2 Compatible Monochrome"

    CASE RetNum = 5
      RetStr = "PS/2 Compatible Color"

  ENDCASE

RETURN RetStr


*  eof VIDEOCLP.PRG

