IF .f.
  VGCATPO.PRG  -- P.L. Olympia, DSI --  11/01/86

  This program is described in the Dr. dBASE column, Data Based Advisor, 02/87

  Luis Castro's ViewGen (tm) generates a main PRG file, a procedure file
  (NAM_PROC) and a bunch of routines with names like NAM_APPE (append
  function), NAM_EDIT (edit), etc.

  This program gathers all the subroutines into one PROC file, called
  NAM_PROC.NEW (where NAM is the first three letters of the application
  system you name). Rename that later to NAM_PROC.PRG.

  Techniques used:
    1. Uses the scratch DBF method to process text data
    2. Uses SET CATALOG method to create needed SCRAT.DBF if not found
    3. It is a DOable program that sets itself as the PROC file

ENDI  not f

SET TALK OFF
SET SAFE OFF
CLEA ALL

SET PROC TO vgcatpo             && note this

*-- omit LABE
*  Memvar "ROUTINES" contain the modules you want to include in
*  NAM_PROC. Memvar "NCHAR" dictates length of module name.

routines = ;
 'APPE BROW DISP EDIT EXPR FORM GETS HELP MENU OPEN PACK PHRA REPO SAYS '

nchar = 5                     && number of chars used by a routine 'APPE '
len_rout = LEN(routines)
totrout = (len_rout/nchar)    && number of routines to be appended

CLEA
appname = SPAC(8)
@ 2,1 SAY "Program also uses the first three letters of name you supply below"
@ 10,1 SAY "Name of main program (w/o PRG) " GET appname
READ

appname=TRIM(appname)
IF ''=appname            && no name specified
  RETU
ENDI

pref = IIF(LEN(appname)<3, appname+'_', SUBS(appname,1,3)+'_')

*--  Open file
 SELE A
 scrat = 'SCRAT.DBF'
 IF FILE('&scrat')
    USE &scrat
 ELSE
*          If required DBF not found we just create it. Note this.

    ? CHR(7)+ scrat + ' not found. I will create it'
  is_no_cat = .f.                     && true if CATALOG.CAT doesn't exist
  IF .NOT. FILE('catalog.cat')
    SET TITL OFF                   && suppress prompt for title
    SET CATA TO catalog.cat        && *.cat is really a DBF
    SET CATA TO                    && close catalog
    is_no_cat = .t.
  ENDI
    USE catalog.cat
    COPY STRU EXTE TO test1.$$$
    USE test1.$$$                  && has FIELD_NAME, FIELD_TYPE, etc
    ZAP
    APPE BLAN
    REPL field_name WITH 'line', field_type WITH 'c', field_len WITH 254
    USE
    CREA &scrat FROM test1.$$$     && create SCRAT.DBF
    ERAS test1.$$$
  IF  is_no_cat
    ERAS catalog.cat
  ENDI
    ? scrat+' created ...'
*    LIST STRU
 ENDI  scrat exists

*--  Start program
altefile = pref+'PROC.NEW'
SET ALTE TO &altefile
SET ALTE ON

*     Start with main program
main_prg = appname+'.PRG'
DO CaptureIt WITH main_prg

*                            Add 2 blanks & row of asterisks
   ?
   ?
   ? REPL('*',40)


procfile = pref+'PROC.PRG'
DO CaptureIt WITH procfile

nrout = 1
DO WHIL nrout <= totrout
   routname = SUBS(routines,(nrout-1)*nchar+1,nchar)
   procname = pref+TRIM(routname)
   routname = procname+'.PRG'

   SET ALTE OFF
   IF .NOT. FILE('&routname')
      ? CHR(7)+routname+' not found'
      nrout = nrout+1
      LOOP
   ENDI
   ? 'Working on '+routname
   SET ALTE ON

*                            Add 2 blanks & row of asterisks
   ?
   ?
   ? REPL('*',40)
   ? 'PROC '+procname

*                            Add current routine
   DO CaptureIt WITH routname

   nrout = nrout+1                        && increment routine counter
ENDD        nrout <= totrout

*---      Closing
   SET ALTE OFF
   CLOS ALTE
   CLOS PROC
   ? '---> All done. Merged file written to '+altefile
   SET TALK ON
   RETU

*******************************
PROC CaptureIt
PARA filename

 ZAP
 APPE FROM &filename SDF
 GO TOP
 DO WHIL .NOT. EOF()
  ? TRIM(line)
  SKIP
 ENDD
 RETU
