* VERTMENU.PRG  USED TO CREATE VERTICAL MENU PROCEDURE
* Copyright October 2, 1987, Gregory J. Scott
* Placed into the public domain.
mFIRSTLINE=4             && first line to write options on
mLASTLINE=mFIRSTLINE+16  && last line to write options on
mMESSAGE=mLASTLINE+2     && line to write option "help" messages on   
mTITLE=SPACE(80)         && initialize title variable.
mTITLErow=1              && row to write title on.
mOUTFILE="VERTMOUT.PRG         " && output file. .prg is NOT assumed
mINFILE="VERTMENU.DBF         "  && input database. .dbf is assumed.
mMENUno="  "             && used to keep menu variables distinct.
mPREFIX="PREFIX"         && procedure name prefix. vary with application
mEXIT="Y"                && test for exit condition
mCHOICE=1                && choice variable. corresponds to dbf record 
mENDCHOICE=32            && maximum choices allowed.
mLINE=1                  && screen line for @ say
mOFFSET=2                && used to offest records 17-32
@ 0, 0 clear
@ 1,10 say "VERTMENU.PRG writes clipper code for PROMPT-MESSAGE menu's"
@ 2,10 say "(Lotus style light bar with detail message)"
@ 3,10 say "Demo menu dbf file MENU.DBF is provided to give an example."
@ 6,10 say " Menu Parameter File " get mINFILE
@ 6,55 say ".dbf default"
@ 7,10 say " Output menu Program " get mOUTFILE
@ 7,55 say "extension required"
@ 8,10 say "         Menu Number " get mMENUno
@ 9,10 say "  Application Prefix " get mPREFIX 
@10,10 say "          Menu Title " get mTITLE    picture "@s40"
@11,10 say "           Title Row " get mTITLErow picture "99"
@12,10 say "          First Line " get mFIRSTLINE picture "99"
@13,10 say "           Last Line " get mLASTLINE picture "99"
@14,10 say "        Message Line " get mMESSAGE  picture "99"
read
if file(mOUTFILE)  && check to avoid overwriting file
   @ 0, 0 clear
   @01,10 say "Warning! This file exists. Erase it? (Y/N) " get mEXIT pict "!"
   read
   if mEXIT<>"Y"
      return
   endif
endif
if (.not. file(mINFILE)) .and. (.not. file(mINFILE+".dbf"))  && check exist
   @ 0, 0 clear
   @01,10 say "Warning! Menu Parameter file does not exist"
   wait
   return  
endif
use &mINFILE
goto top
mLINE=mFIRSTLINE              && begin writing options on first line allowed
mCHOICE=1                     && option choice should correspond to recno()
mENDCHOICE=iif(lastrec()<(32),lastrec(),32)  && num last choice in dbf 32 max
@0,0 clear
mOFFSET=2            && first column of choices
set alternate on     && redirect printer output to file
set alternate to &mOUTFILE  && name of output file
? "mMENU"+mMENUno+"=1"  && initialize menu memvar ~
? "set message to "+str(mMESSAGE,2,0) && setup option help message location
? "do while mMENU"+mMENUno+" <> "+str(mENDCHOICE,2,0)  && do menu while < max
? "    @ 0, 0 clear"                                   && redraw whole screen! 
? '    @ 1,'+str(40-int((len(rtrim(mTITLE))/2)),2,0)+' say "'+rtrim(mTITLE)+'"'
do while (.not. eof()) .and. (mCHOICE<=mENDCHOICE) && write all menu choices
   ? "* menu choice "+ str(mCHOICE,2,0)      && comment line
   ? '   @ '+str(mLINE,2,0)+','+str(mOFFSET,2,0)+' prompt "'+PROMPT+'";'
   ? '   message "'+MESSAGE+'"'  && actual menu choice (two lines: readable)
   skip 1                        && skip to next menu choice.
   mLINE=mLINE+1                 && increment counters
   mCHOICE=mCHOICE+1
   if mLINE=mLASTLINE            && if at bottom of column, goto top of screen
      mLINE=mFIRSTLINE           &&  and change offset for 2nd column.
      mOFFSET=42
   endif
enddo
? "   menu to mMENU"+mMENUno     && works like read on regular screen, but
                                 && stores choice to memvar
goto top             && redo procedure, writing cases for option consequences.
mCHOICE=1
? "do case"
do while (.not. eof()) .and. (mCHOICE<=mENDCHOICE)
   ? "case mMENU"+mMENUno+" = "+ str(mCHOICE,2,0)+"  && "+MESSAGE
   if DOPROC = "Y"   && do a procedure named for prefix and option number.
      ? "do "+rtrim(mPREFIX)+ltrim(str(mCHOICE,2,0))
   endif
   if len(rtrim(command1))<>0  && write commands in dbf if not empty records
      ? command1
   endif
   if len(rtrim(command2))<>0
      ? command2
   endif
   if len(rtrim(command3))<>0
      ? command3
   endif
   if len(rtrim(command4))<>0
      ? command4
   endif
   if len(rtrim(command5))<>0
      ? command5
   endif
   skip 1
   mCHOICE=mCHOICE+1
enddo
? "endcase"
? "enddo"

set alternate off  && set printing back to normal
