***********************************************************************
***********************************************************************
**                                                                   **
**  PROCEDURE FILE ...: USRERROR                                     **
**                                                                   **
**  PURPOSE ..........: Functions and procedures used to check       **
**                      a user input error.                          **
**                                                                   **
**  AUTHOR ...........: S.M. Gray, Suzanne T. Heninger               **
**                      R.W. Ladner                                  **
**                      Data Services Dept.                          **
**                      Sverdrup Technology, Inc.                    **
**                      Stennis Space Center, MS 39529               **
**                      (601) 688 - 1869                             **
**                                                                   **
**  DATE .............: March 1, 1989                                **
**                                                                   **
***********************************************************************
***********************************************************************


*-------------------------------------------------------------------


FUNCTION HskpVal

*---------------------------------------------------------------------
*  Purpose ........:  to perform validation housekeeping (i.e., to keep
*                     up with the last key pressed and if necessary to
*                     to display an error message
*  Parameter ......:  msg -  error message
*  Rtns. called ...:  ErrMsg - display the error message
*  Author .........:  S.M. Gray
*
*---------------------------------------------------------------------

PARAMETERS msg

IF return_val
    key_value = LASTKEY()

    * Break out of the READ if the user entered Ctrl End.

    IF key_value = 23
       CLEAR GETS
    ENDIF

ELSE
    ErrMsg (msg)
ENDIF

*  Redisplay command line

@ 23, 1 SAY command_line

RETURN ""


*---------------------------------------------------------------------

FUNCTION ValTime

*---------------------------------------------------------------------
*  Purpose ........:  to validate the time input in the form hhmm
*  Parameter ......:  timestring
*  Rtns. called ...:  HskpVal - performs validation housekeeping
*  Author .........:  S.M. Gray
*
*  Used as a UDF called from the VALID phrase of the @...SAY...GET
*---------------------------------------------------------------------

PARAMETERS timestring
PRIVATE return_val

return_val = VAL(SUBSTR(timestring,1,2))   <  24 .AND. ;
             VAL(SUBSTR(timestring,3,2))  <  60 

HskpVal('Invalid military time.')

RETURN return_val

*--------------------------------------------------------------------

FUNCTION Validate

*---------------------------------------------------------------------
*  Purpose ......: to validate entry/edit values for almost ALL input 
*                  variables
*  Parameters ...: varname  - name of the variable to be validated
*                  varvalue - value of the variable to be validated
*  Return value .: .T. - if value meets condition
*                  .F. - if value does not meet condition
*  Rtn. called ..:  HskpVal - perform validation housekeeping
*  Author .......:  R.W. Ladner
*
*  This assumes the following databases open:
*   AREA 11 : VARLIST
*   AREA 10 : VALDATA
*
*  VARLIST has the following structure:
*          NAME       Character 10              ** variable name
*          ALIAS      Character 10              ** lookup file name or
*                                               ** name in VALDATA
*          LOOKUP     Logical                   ** indicates lookup file
*          BEBLANK    Logical                   ** entry may be blank
*
*  VALDATA has the following structure:
*          NAME       Character  10
*          CONDITION  Character 100             ** variable must meet this
*                                               ** condition
*          MESSAGE    Character  80             ** error message if condition
*                                               ** not met.
*                     
*  Used in conjunction with the VALID clause of the @..SAY..GET
*
*  This routine allows data validation condition to be external from 
*  the code.  Thus changes in range, lookup file names, strings etc., may 
*  be changes without changing any code.
*
*--------------------------------------------------------------------


PARAMETERS varname, varvalue
PUBLIC key_value
PRIVATE return_val, cond, look_file, done

key_value = LASTKEY()

* Page Up & Up Arrow return without checking the data entry.

IF (key_value = 18) .OR. (key_value = 5)
   RETURN .T.
ENDIF

* Control End also returns without checking the data entry and clears the
*    gets to terminate the read.

IF key_value = 23
   CLEAR GETS
   RETURN .T.
ENDIF

STORE SPACE(8) TO look_file
STORE .T. TO return_val
STORE .F. TO done

SELECT 11               && VARLIST

SEEK varname
IF FOUND()
    IF VARLIST->LOOKUP
         done  = .T.

         IF (VARLIST->BEBLANK) .AND. (EMPTY (varvalue))
             return_val = .T.

         ELSE
             look_file = TRIM(VARLIST->ALIAS)

             SELECT 9
             USE &look_file INDEX &look_file

             SEEK varvalue
             IF .NOT. FOUND()
                  SELECT 10       && VALDATA
                  SEEK varname
                  return_val = .F.
             ELSE
                  return_val = .T.
             ENDIF
             SELECT 9
             USE
         ENDIF

    ELSE
         varname = VARLIST->ALIAS
    ENDIF
ENDIF

IF .NOT. done
    SELECT 10
    SEEK varname
    cond =  VALDATA->CONDITION
    IF EMPTY(cond)
         return_val = .T.
    ELSEIF &cond
         return_val = .T.
    ELSE
         return_val = .F.
    ENDIF
ENDIF

IF .NOT. return_val
   ErrMsg (VALDATA->MESSAGE)
ENDIF

* Redisplay the command line.

@ 23, 1  SAY  command_line

RETURN return_val


*--------------------------------------------------------------------

FUNCTION ValNumCh

*----------------------------------------------------------------------
*  Purpose ......: To validate numeric fields that are entered as     *
*                  character fields to distinguish between a zero     *
*                  and a blank field.                                 *
*  Parameters ...: field_name - name of the field to send to validate *
*                  ch_field   - character entry field                 *
*                               (passed by reference using '@')       *
*  Author .......: Suzanne T. Heninger                                *
*  Rtn. Value ...: The value returned by Validate().  Sets the global *
*                  variable key_value.                                *
*----------------------------------------------------------------------

PARAMETERS field_name, ch_field

* If the field is empty, just call FindKey() to set key_value and return.

IF EMPTY (ch_field)
   FindKey()
   RETURN (.T.)
ENDIF

* Convert the field to a number and back to a character string to right
*    justify it on the screen.

num_ch    = LEN (ch_field)
num_field = VAL (ch_field)
ch_field  = STR (num_field, num_ch)

SET COLOR TO W/B, N/N, N,, N/N
@ row(), col() - num_ch  SAY  ch_field  PICTURE  REPLICATE ('!', num_ch)

SET COLOR TO G/N, W/R, N,, W/B

return_val = Validate (field_name, num_field)

RETURN return_val


*----------------------------------------------------------------------

FUNCTION FindKey

*--------------------------------------------------------------------
*  Purpose ......: to determine the key pressed to terminate a GET  *
*  Parameters ...: None                                             *
*  Author .......: Suzanne T. Heninger                              *
*  Rtn. Value ...: True                                             *
*     Sets the global variable key_value                            *
*--------------------------------------------------------------------

key_value = LASTKEY()

IF key_value = 23
   CLEAR GETS
ENDIF

RETURN .T.


*------------------------------------------------------------------------------

FUNCTION ErrMsg

*------------------------------------------------------------------------------
*  Purpose .....:  to display an error a message on the screen
*  Parameters ..:  string - the message to be displayed
*  Author ......:  S.M. Gray
*
*------------------------------------------------------------------------------

PARAMETER string

SET COLOR TO R/N
@ 23, 0 CLEAR
?? CHR(7)
@ 24, 1 SAY string
INKEY(2.3)

@ 23, 0 CLEAR
SET COLOR TO G/N,W/R,N,,W/B
RETURN ''

*------------------------------------------------------------------------------

FUNCTION ErrResp

*------------------------------------------------------------------------------
*  Purpose .....:  to display an error a message on the screen and
*                  solicit a yes/no response.
*  Parameters ..:  prompt - the message to be displayed
*  Author ......:  Suzanne T. Heninger, based on routines by S.M. Gray
*
*------------------------------------------------------------------------------

PARAMETER prompt

* Turn HELP off or it will get lost in the overlay structure.

SET KEY 28 TO

STORE 'N' to ans
SET COLOR TO R/N, W/R, N,, W/R
@ 23, 0  CLEAR
?? CHR(7)
@ 24, 1  SAY  prompt  GET  ans  PICTURE  '!'  VALID  (ans $ 'YN')
READ

@ 23, 0  CLEAR
SET COLOR TO G/N,W/R,N,,W/B

SET KEY 28 TO HELP

RETURN ans



