******************************************************************************
* UPCFUNC.PRG - UPC Barcode Routines for use with 3PX.LIB for Clipper S87    *
* Copyright(c) 1990, 3P Software, Inc. - All Rights Reserved                 *
* Author: Pedro P. Polakoff III for 3PX.LIB v8.20 extensions                 *
******************************************************************************

function upcinit
  parameters p_hp
  private _usehp,_nb,_wb,_ns,_ws,_scode,_ecode
  public _3PUPC[127],_3PUPRFX,_3PUSUFX
  _usehp=iif(pcount()=1 .and. type("p_hp")="L",p_hp,.f.)
  if _usehp
    _nb=lpcmd("\027*c 3a50b0P\027*p+ 3X")
    _wb=lpcmd("\027*c 7a50b0P\027*p+ 7X")
    _ns=lpcmd("\027*p+ 3X")
    _ws=lpcmd("\027*p+ 7X")
    _scode=lpcmd("\027*p-50Y")
    _ecode=lpcmd("\027*p+50Y")
  else
    _ns=lpcmd("\000\000")
    _ws=_ns+_ns
    _nb=lpcmd("\255")
    _wb=lpcmd("\255\255\255")
    _scode=""
    _ecode=""
  endif
   _3PUPC[01] = _nb+_ns+_nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_wb+_ws+_nb+_ns+_nb+_ns+_nb+_ns+_wb
   _3PUPC[02] = _nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_wb+_ns+_nb+_ns+_nb+_ws+_nb+_ns+_wb
   _3PUPC[03] = _nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_nb+_ns+_wb+_ns+_nb+_ws+_nb+_ns+_wb
   _3PUPC[04] = _nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_wb+_ns+_wb+_ns+_nb+_ws+_nb+_ns+_nb
   _3PUPC[05] = _nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_nb+_ns+_nb+_ns+_wb+_ws+_nb+_ns+_wb
   _3PUPC[06] = _nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_wb+_ns+_nb+_ns+_wb+_ws+_nb+_ns+_nb
   _3PUPC[07] = _nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_nb+_ns+_wb+_ns+_wb+_ws+_nb+_ns+_nb
   _3PUPC[08] = _nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_nb+_ns+_nb+_ns+_nb+_ws+_wb+_ns+_wb
   _3PUPC[09] = _nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_wb+_ns+_nb+_ns+_nb+_ws+_wb+_ns+_nb
   _3PUPC[10] = _nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_nb+_ns+_wb+_ns+_nb+_ws+_wb+_ns+_nb
   _3PUPC[11] = _nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_nb+_ns+_nb+_ns+_wb+_ws+_wb+_ns+_nb
   _3PUPC[12] = _nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_wb+_ns+_nb+_ns+_nb+_ns+_nb+_ws+_wb
   _3PUPC[13] = _nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_nb+_ns+_wb+_ns+_nb+_ns+_nb+_ws+_wb
   _3PUPC[14] = _nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_wb+_ns+_wb+_ns+_nb+_ns+_nb+_ws+_nb
   _3PUPC[15] = _nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_nb+_ns+_nb+_ns+_wb+_ns+_nb+_ws+_wb
   _3PUPC[16] = _nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_wb+_ns+_nb+_ns+_wb+_ns+_nb+_ws+_nb
   _3PUPC[17] = _nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_nb+_ns+_wb+_ns+_wb+_ns+_nb+_ws+_nb
   _3PUPC[18] = _nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_nb+_ns+_nb+_ns+_nb+_ns+_wb+_ws+_wb
   _3PUPC[19] = _nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_wb+_ns+_nb+_ns+_nb+_ns+_wb+_ws+_nb
   _3PUPC[20] = _nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_nb+_ns+_wb+_ns+_nb+_ns+_wb+_ws+_nb
   _3PUPC[21] = _nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_nb+_ns+_nb+_ns+_wb+_ns+_wb+_ws+_nb
   _3PUPC[22] = _nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_wb+_ws+_nb+_ns+_nb+_ns+_nb+_ns+_wb
   _3PUPC[23] = _nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_nb+_ws+_wb+_ns+_nb+_ns+_nb+_ns+_wb
   _3PUPC[24] = _nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_wb+_ws+_wb+_ns+_nb+_ns+_nb+_ns+_nb
   _3PUPC[25] = _nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_nb+_ws+_nb+_ns+_wb+_ns+_nb+_ns+_wb
   _3PUPC[26] = _nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_wb+_ws+_nb+_ns+_wb+_ns+_nb+_ns+_nb
   _3PUPC[27] = _nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_nb+_ws+_wb+_ns+_wb+_ns+_nb+_ns+_nb
   _3PUPC[28] = _nb+_ns+_nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_wb+_ns+_nb+_ns+_nb+_ws+_nb+_ns+_wb
   _3PUPC[29] = _nb+_ns+_nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_wb+_ns+_nb+_ws+_nb+_ns+_wb
   _3PUPC[30] = _nb+_ns+_nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_wb+_ns+_wb+_ns+_nb+_ws+_nb+_ns+_nb
   _3PUPC[31] = _nb+_ns+_nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_nb+_ns+_wb+_ws+_nb+_ns+_wb
   _3PUPC[32] = _nb+_ns+_nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_wb+_ns+_nb+_ns+_wb+_ws+_nb+_ns+_nb
   _3PUPC[33] = _nb+_ws+_wb+_ns+_nb+_ns+_wb+_ns+_nb       && " " SPACE
   _3PUPC[34] = _nb+_ws+_nb+_ws+_nb+_ns+_nb+_ws+_nb+_ns+_wb+_ns+_nb+_ns+_nb+_ws+_nb+_ns+_wb    && "!"
   _3PUPC[35] = _nb+_ws+_nb+_ws+_nb+_ns+_nb+_ws+_nb+_ns+_nb+_ns+_wb+_ns+_nb+_ws+_nb+_ns+_wb    && """
   _3PUPC[36] = _nb+_ws+_nb+_ws+_nb+_ns+_nb+_ws+_nb+_ns+_wb+_ns+_wb+_ns+_nb+_ws+_nb+_ns+_nb    && "#"
   _3PUPC[37] = _nb+_ws+_nb+_ws+_nb+_ns+_nb+_ws+_nb+_ns+_nb+_ns+_nb+_ns+_wb+_ws+_nb+_ns+_wb    && "$"
   _3PUPC[38] = _nb+_ws+_nb+_ws+_nb+_ns+_nb+_ws+_nb+_ns+_wb+_ns+_nb+_ns+_wb+_ws+_nb+_ns+_nb    && "%"
   _3PUPC[39] = _nb+_ws+_nb+_ws+_nb+_ns+_nb+_ws+_nb+_ns+_nb+_ns+_wb+_ns+_wb+_ws+_nb+_ns+_nb    && "&"
   _3PUPC[40] = _nb+_ws+_nb+_ws+_nb+_ns+_nb+_ws+_nb+_ns+_nb+_ns+_nb+_ns+_nb+_ws+_wb+_ns+_wb    && "'"
   _3PUPC[41] = _nb+_ws+_nb+_ws+_nb+_ns+_nb+_ws+_nb+_ns+_wb+_ns+_nb+_ns+_nb+_ws+_wb+_ns+_nb    && "("
   _3PUPC[42] = _nb+_ws+_nb+_ws+_nb+_ns+_nb+_ws+_nb+_ns+_nb+_ns+_wb+_ns+_nb+_ws+_wb+_ns+_nb    && ")"
   _3PUPC[43] = _nb+_ws+_nb+_ws+_nb+_ns+_nb+_ws+_nb+_ns+_nb+_ns+_nb+_ns+_wb+_ws+_wb+_ns+_nb    && "*"
   _3PUPC[44] = _nb+_ws+_nb+_ws+_nb+_ns+_nb+_ws+_nb+_ns+_wb+_ns+_nb+_ns+_nb+_ns+_nb+_ws+_wb    && "+"
   _3PUPC[45] = _nb+_ws+_nb+_ws+_nb+_ns+_nb+_ws+_nb+_ns+_nb+_ns+_wb+_ns+_nb+_ns+_nb+_ws+_wb    && ","
   _3PUPC[46] = _nb+_ws+_nb+_ns+_nb+_ns+_wb+_ns+_wb       && "-"
   _3PUPC[47] = _wb+_ws+_nb+_ns+_nb+_ns+_wb+_ns+_nb       && ".".
   _3PUPC[48] = _nb+_ws+_nb+_ws+_nb+_ns+_nb+_ws+_nb+_ns+_wb+_ns+_nb+_ns+_wb+_ns+_nb+_ws+_nb      && "/"
   _3PUPC[49] = _nb+_ns+_nb+_ws+_wb+_ns+_wb+_ns+_nb       && "0"
   _3PUPC[50] = _wb+_ns+_nb+_ws+_nb+_ns+_nb+_ns+_wb       && "1"
   _3PUPC[51] = _nb+_ns+_wb+_ws+_nb+_ns+_nb+_ns+_wb       && "2"
   _3PUPC[52] = _wb+_ns+_wb+_ws+_nb+_ns+_nb+_ns+_nb       && "3"
   _3PUPC[53] = _nb+_ns+_nb+_ws+_wb+_ns+_nb+_ns+_wb       && "4"
   _3PUPC[54] = _wb+_ns+_nb+_ws+_wb+_ns+_nb+_ns+_nb       && "5"
   _3PUPC[55] = _nb+_ns+_wb+_ws+_wb+_ns+_nb+_ns+_nb       && "6"
   _3PUPC[56] = _nb+_ns+_nb+_ws+_nb+_ns+_wb+_ns+_wb       && "7"
   _3PUPC[57] = _wb+_ns+_nb+_ws+_nb+_ns+_wb+_ns+_nb       && "8"
   _3PUPC[58] = _nb+_ns+_wb+_ws+_nb+_ns+_wb+_ns+_nb       && "9"
   _3PUPC[59] = _nb+_ws+_nb+_ws+_nb+_ns+_nb+_ws+_nb+_ns+_nb+_ws+_wb+_ns+_wb+_ns+_nb+_ns+_nb     && ":"
   _3PUPC[60] = _nb+_ns+_nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_wb+_ns+_wb+_ws+_nb+_ns+_nb     && ";"
   _3PUPC[61] = _nb+_ns+_nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_nb+_ns+_nb+_ws+_wb+_ns+_wb     && "<"
   _3PUPC[62] = _nb+_ns+_nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_wb+_ns+_nb+_ns+_nb+_ws+_wb+_ns+_nb     && "="
   _3PUPC[63] = _nb+_ns+_nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_wb+_ns+_nb+_ws+_wb+_ns+_nb     && ">"
   _3PUPC[64] = _nb+_ns+_nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_nb+_ns+_wb+_ws+_wb+_ns+_nb     && "?"
   _3PUPC[65] = _nb+_ns+_nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ws+_wb+_ns+_nb+_ns+_nb+_ns+_wb     && "@"
   _3PUPC[66] = _wb+_ns+_nb+_ns+_nb+_ws+_nb+_ns+_wb       && "A"
   _3PUPC[67] = _nb+_ns+_wb+_ns+_nb+_ws+_nb+_ns+_wb       && "B"
   _3PUPC[68] = _wb+_ns+_wb+_ns+_nb+_ws+_nb+_ns+_nb       && "C"
   _3PUPC[69] = _nb+_ns+_nb+_ns+_wb+_ws+_nb+_ns+_wb       && "D"
   _3PUPC[70] = _wb+_ns+_nb+_ns+_wb+_ws+_nb+_ns+_nb       && "E"
   _3PUPC[71] = _nb+_ns+_wb+_ns+_wb+_ws+_nb+_ns+_nb       && "F"
   _3PUPC[72] = _nb+_ns+_nb+_ns+_nb+_ws+_wb+_ns+_wb       && "G"
   _3PUPC[73] = _wb+_ns+_nb+_ns+_nb+_ws+_wb+_ns+_nb       && "H"
   _3PUPC[74] = _nb+_ns+_wb+_ns+_nb+_ws+_wb+_ns+_nb       && "I"
   _3PUPC[75] = _nb+_ns+_nb+_ns+_wb+_ws+_wb+_ns+_nb       && "J"
   _3PUPC[76] = _wb+_ns+_nb+_ns+_nb+_ns+_nb+_ws+_wb       && "K"
   _3PUPC[77] = _nb+_ns+_wb+_ns+_nb+_ns+_nb+_ws+_wb       && "L"
   _3PUPC[78] = _wb+_ns+_wb+_ns+_nb+_ns+_nb+_ws+_nb       && "M"
   _3PUPC[79] = _nb+_ns+_nb+_ns+_wb+_ns+_nb+_ws+_wb       && "N"
   _3PUPC[80] = _wb+_ns+_nb+_ns+_wb+_ns+_nb+_ws+_nb       && "O"
   _3PUPC[81] = _nb+_ns+_wb+_ns+_wb+_ns+_nb+_ws+_nb       && "P"
   _3PUPC[82] = _nb+_ns+_nb+_ns+_nb+_ns+_wb+_ws+_wb       && "Q"
   _3PUPC[83] = _wb+_ns+_nb+_ns+_nb+_ns+_wb+_ws+_nb       && "R"
   _3PUPC[84] = _nb+_ns+_wb+_ns+_nb+_ns+_wb+_ws+_nb       && "S"
   _3PUPC[85] = _nb+_ns+_nb+_ns+_wb+_ns+_wb+_ws+_nb       && "T"
   _3PUPC[86] = _wb+_ws+_nb+_ns+_nb+_ns+_nb+_ns+_wb       && "U"
   _3PUPC[87] = _nb+_ws+_wb+_ns+_nb+_ns+_nb+_ns+_wb       && "V"
   _3PUPC[88] = _wb+_ws+_wb+_ns+_nb+_ns+_nb+_ns+_nb       && "W"
   _3PUPC[89] = _nb+_ws+_nb+_ns+_wb+_ns+_nb+_ns+_wb       && "X"
   _3PUPC[90] = _wb+_ws+_nb+_ns+_wb+_ns+_nb+_ns+_nb       && "Y"
   _3PUPC[91] = _nb+_ws+_wb+_ns+_wb+_ns+_nb+_ns+_nb       && "Z"
   _3PUPC[92] = _nb+_ns+_nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_wb+_ns+_nb+_ns+_nb+_ns+_nb+_ws+_wb    && "]"
   _3PUPC[93] = _nb+_ns+_nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_wb+_ns+_nb+_ns+_nb+_ws+_wb    && "\"
   _3PUPC[94] = _nb+_ns+_nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_wb+_ns+_wb+_ns+_nb+_ns+_nb+_ws+_nb    && "["
   _3PUPC[95] = _nb+_ns+_nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_nb+_ns+_wb+_ns+_nb+_ws+_wb    && "^"
   _3PUPC[96] = _nb+_ns+_nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_wb+_ns+_nb+_ns+_wb+_ns+_nb+_ws+_nb    && "_"
   _3PUPC[97] = _nb+_ns+_nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_wb+_ws+_wb+_ns+_nb+_ns+_nb+_ns+_nb    && "`"
   _3PUPC[98] = _nb+_ws+_nb+_ns+_nb+_ws+_nb+_ws+_nb+_ns+_wb+_ns+_nb+_ns+_nb+_ws+_nb+_ns+_wb     && "a"
   _3PUPC[99] = _nb+_ws+_nb+_ns+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_wb+_ns+_nb+_ws+_nb+_ns+_wb     && "b"
   _3PUPC[100] = _nb+_ws+_nb+_ns+_nb+_ws+_nb+_ws+_nb+_ns+_wb+_ns+_wb+_ns+_nb+_ws+_nb+_ns+_nb     && "c"
   _3PUPC[101] = _nb+_ws+_nb+_ns+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_nb+_ns+_wb+_ws+_nb+_ns+_wb     && "d"
   _3PUPC[102] = _nb+_ws+_nb+_ns+_nb+_ws+_nb+_ws+_nb+_ns+_wb+_ns+_nb+_ns+_wb+_ws+_nb+_ns+_nb     && "e"
   _3PUPC[103] = _nb+_ws+_nb+_ns+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_wb+_ns+_wb+_ws+_nb+_ns+_nb     && "f"
   _3PUPC[104] = _nb+_ws+_nb+_ns+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_nb+_ns+_nb+_ws+_wb+_ns+_wb     && "g"
   _3PUPC[105] = _nb+_ws+_nb+_ns+_nb+_ws+_nb+_ws+_nb+_ns+_wb+_ns+_nb+_ns+_nb+_ws+_wb+_ns+_nb     && "h"
   _3PUPC[106] = _nb+_ws+_nb+_ns+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_wb+_ns+_nb+_ws+_wb+_ns+_nb     && "i"
   _3PUPC[107] = _nb+_ws+_nb+_ns+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_nb+_ns+_wb+_ws+_wb+_ns+_nb     && "j"
   _3PUPC[108] = _nb+_ws+_nb+_ns+_nb+_ws+_nb+_ws+_nb+_ns+_wb+_ns+_nb+_ns+_nb+_ns+_nb+_ws+_wb     && "k"
   _3PUPC[109] = _nb+_ws+_nb+_ns+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_wb+_ns+_nb+_ns+_nb+_ws+_wb     && "l"
   _3PUPC[110] = _nb+_ws+_nb+_ns+_nb+_ws+_nb+_ws+_nb+_ns+_wb+_ns+_wb+_ns+_nb+_ns+_nb+_ws+_nb     && "m"
   _3PUPC[111] = _nb+_ws+_nb+_ns+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_nb+_ns+_wb+_ns+_nb+_ws+_wb     && "n"
   _3PUPC[112] = _nb+_ws+_nb+_ns+_nb+_ws+_nb+_ws+_nb+_ns+_wb+_ns+_nb+_ns+_wb+_ns+_nb+_ws+_nb     && "o"
   _3PUPC[113] = _nb+_ws+_nb+_ns+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_wb+_ns+_wb+_ns+_nb+_ws+_nb     && "p"
   _3PUPC[114] = _nb+_ws+_nb+_ns+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_nb+_ns+_nb+_ns+_wb+_ws+_wb     && "q"
   _3PUPC[115] = _nb+_ws+_nb+_ns+_nb+_ws+_nb+_ws+_nb+_ns+_wb+_ns+_nb+_ns+_nb+_ns+_wb+_ws+_nb     && "r"
   _3PUPC[116] = _nb+_ws+_nb+_ns+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_wb+_ns+_nb+_ns+_wb+_ws+_nb     && "s"
   _3PUPC[117] = _nb+_ws+_nb+_ns+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_nb+_ns+_wb+_ns+_wb+_ws+_nb     && "t"
   _3PUPC[118] = _nb+_ws+_nb+_ns+_nb+_ws+_nb+_ws+_nb+_ns+_wb+_ws+_nb+_ns+_nb+_ns+_nb+_ns+_wb     && "u"
   _3PUPC[119] = _nb+_ws+_nb+_ns+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ws+_wb+_ns+_nb+_ns+_nb+_ns+_wb     && "v"
   _3PUPC[120] = _nb+_ws+_nb+_ns+_nb+_ws+_nb+_ws+_nb+_ns+_wb+_ws+_wb+_ns+_nb+_ns+_nb+_ns+_nb     && "w"
   _3PUPC[121] = _nb+_ws+_nb+_ns+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ws+_nb+_ns+_wb+_ns+_nb+_ns+_wb     && "x"
   _3PUPC[122] = _nb+_ws+_nb+_ns+_nb+_ws+_nb+_ws+_nb+_ns+_wb+_ws+_nb+_ns+_wb+_ns+_nb+_ns+_nb     && "y"
   _3PUPC[123] = _nb+_ws+_nb+_ns+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ws+_wb+_ns+_wb+_ns+_nb+_ns+_nb     && "z"
   _3PUPC[124] = _nb+_ns+_nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_wb+_ns+_wb+_ns+_nb+_ws+_nb     && "{"
   _3PUPC[125] = _nb+_ns+_nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_nb+_ns+_nb+_ns+_wb+_ws+_wb     && "|"
   _3PUPC[126] = _nb+_ns+_nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_wb+_ns+_nb+_ns+_nb+_ns+_wb+_ws+_nb     && "}"
   _3PUPC[127] = _nb+_ns+_nb+_ws+_nb+_ws+_nb+_ws+_nb+_ns+_nb+_ns+_wb+_ns+_nb+_ns+_wb+_ws+_nb     && "~"
   _3PUPRFX=_scode+_nb+_ws+_nb+_ns+_wb+_ns+_wb+_ns+_nb+_ns
   _3PUSUFX=_nb+_ws+_nb+_ns+_wb+_ns+_wb+_ns+_nb+_ecode  
return('')


function upcprint
  parameters p_hp,p_code,p_msg1,p_msg2
  private _usehp,_bcode,_msg1,_msg2,_x,_y
  
  _usehp=iif(pcount()>=1 .and. type("p_hp")="L",p_hp,.f.)
  _bcode=iif(pcount()>=2 .and. type("p_code")="C",p_code,"")
  _msg1=iif(pcount()>=3 .and. type("p_msg1")="C",p_msg1,"")
  _msg2=iif(pcount()=4 .and. type("p_msg2")="C",p_msg2,"")
  if !empty(_bcode)
    setprint(.t.)
    setdevice('print')
    setconsole(.f.)
    if _usehp
      for _x=1 to 2
        ? space(3)+_3PUPRFX
        for _y=1 to len(_bcode)
          ?? _3PUPC[ascpos(_bcode,_y)+1]
          ?? lpcmd("\027*p+ 3X")
        next 
        ?? _3PUSUFX
        ?? space(3)+iif(_x=1,_msg1,_msg2)
      next
      ? space((len(_bcode)/2)+3)+_bcode
    else
      private _e1,_o1,_n1
      _e1=i2bin(len(_3PUPRFX))
      _o1=i2bin(len(_3PUSUFX))
      ? lpcmd("\027\051\002")
      for _x=1 to 3
        ?? lpcmd("\027L\030")+replicate(chr(0),31)
        ?? lpcmd("\027L")+_e1+_3PUPRFX
        for _y = 1 to len(_bcode)
          _n1=i2bin(len(_3PUPC[ascpos(_bcode,_y)+1])+2)
          ?? lpcmd("\027L")+_n1+_3PUPC[ascpos(_bcode,_y)+1]+lpcmd("\000\000")
        next
        ?? lpcmd("\027L")+_o1+_3PUSUFX
        if _x=1
          ?? space(3)+_msg1
        elseif _x=3
          ?? space(3)+_msg2
        endif
        ?? lpcmd("\027\074\024\013")
      next
      ? ""
      ? space((len(_bcode)/2)+3)+_bcode
      ? lpcmd("\027\050")
    endif
    setdevice('screen')
    setprint(.f.)
    setconsole(.t.)
  endif
return('')

function upcfree
  release _3PUPC,_3PUPRFX,_3PUSUFX
return('')