*  *
* Program..: unveil.prg
* Version..: 2.0
* Author...: Copyright 1989 by Greg Dunn
* Date.....: February 8, 1989
* Descrip..: Demonstrates help system which includes:
*            (1) context-sensitive help at GET fields
*                and WAIT statements
*            (2) context-sensitive help at menus
*            (3) a help index.
*
* This program is copyrighted.  You may, however, modify it
* for your own use, and you may freely distribute it so long
* as such distribution is in the complete original format
* and no compensation is accepted.
*  *

f1     = 28
escape = 27
nowhelp   = .T.
nowcursor = .F.

* Initialize color variables
CLEAR SCREEN
yesno = "N"
@ 10,10 SAY "Do you have a color monitor? (y/N) " GET yesno
READ
IF yesno $ "Yy"
  appcolor  = "BG+/B, W+/BG,,, GR+/BG"
  appcolor1 = "W+/B"
  appcolor2 = "RB+/B"
  helpcolor = "R/W, W+/R,,,B/W"
  hndxcolor = "GR+/N, W+/G,,,GR+/G"
  highcolor = "GR+/R"
ELSE
  STORE "W/N,N/W,,,N/W" TO appcolor, appcolor1, appcolor2
  STORE "W/N,N/W,,,N/W" TO helpcolor, hndxcolor
  STORE "N/W" TO highcolor
ENDIF

DO WHILE .T.  && Main Menu Selection Loop
  SETCOLOR(appcolor)
  CLEAR SCREEN
  @  0, 0 TO 24,79

  SETCOLOR(appcolor1)
  CenterSay(["HELP UNVEILED"],5)
  @  18,20 to 20,60
  CenterSay("Press F1 for Context-Sensitive Help",19)

  SETCOLOR(appcolor2)
  CenterSay("Copyright 1989 by Greg Dunn",9)
  
  SETCOLOR(appcolor)
  CenterSay("Bi-Level Context-Sensitive Help in Clipper",7)

  DECLARE menuitem[3]

  MenuItem[1] = ' Arbitrary Option 1'
  MenuItem[2] = ' Arbitrary Option 2'
  MenuItem[3] = ' QUIT'

  menu = "MAIN"
  SET KEY F1 TO
  SET CURSOR OFF
  @ 11, 28 TO 15,52
  MenuChoice = ACHOICE(12,30,14,50,menuitem,.T.,"FHELP")

  SETCOLOR(appcolor)
  CLEAR SCREEN
 
  DO CASE
    CASE MenuChoice = 3
        SET COLOR TO
        CLEAR
        RETURN
    CASE MenuChoice = 1
      DO OPTION1
    CASE MenuChoice = 2
      DO OPTION2
  ENDCASE

ENDDO && Main Menu Selection Loop

* 
PROCEDURE OPTION1
* 

USE UNVEIL2
xclientnam = CLIENTNAME
xphone     = PHONE
SET CURSOR ON
SET KEY F1 TO HELP
CLEAR SCREEN

@  5,10 CLEAR TO 7,30
@  5,10 TO 7,30
@  6,12 SAY [Press F1 for Help]

@ 11, 11 CLEAR TO 14, 68
@ 11, 11 TO 14, 68 DOUBLE
@ 12, 14 SAY "Client Name  : " GET xclientnam
@ 13, 14 SAY "Phone Number : " GET xphone
READ
REPL CLIENTNAME WITH xclientnam
REPL PHONE WITH xphone

SET CURSOR OFF
@  5,10 CLEAR TO 7,30
@ 20,20 CLEAR TO 23,60
@ 20,20 TO 23,60
@ 21,23 SAY [   Holding at WAIT "" Statement   ]
@ 22,23 SAY [F1-Help    Any Other Key-Continue]
WAIT ""
SET KEY F1 TO

* 
PROCEDURE OPTION2
* 

USE UNVEIL2
xspousenam = SPOUSENAME
xphone     = PHONE
SET CURSOR ON
SET KEY F1 TO HELP
CLEAR SCREEN

@  5,10 CLEAR TO 7,30
@  5,10 TO 7,30
@  6,12 SAY [Press F1 for Help]

@ 11, 11 CLEAR TO 14, 68
@ 11, 11 TO 14, 68 DOUBLE
@ 12, 14 SAY "Client Name  : " GET xspousenam
@ 13, 14 SAY "Phone Number : " GET xphone
READ
REPL SPOUSENAME WITH xspousenam
REPL PHONE WITH xphone

SET CURSOR OFF
@  5,10 CLEAR TO 7,30
@ 20,20 CLEAR TO 23,60
@ 20,20 TO 23,60
@ 21,23 SAY [   Holding at WAIT "" Statement   ]
@ 22,23 SAY [F1-Help    Any Other Key-Continue]
WAIT ""
SET KEY F1 TO

* 
PROCEDURE HELP
* 

PARAMETER  call_prg, line_num, input_var

color_was = SETCOLOR(helpcolor)
SET CURSOR OFF
SET KEY F1 TO HELP_NDX

DO CASE
  CASE call_prg = "OPTION1"
    DO CASE
      CASE input_var = "XCLIENTNAM"
        helpsource = MEMOREAD("GET11.HLP")
      CASE input_var = "XPHONE"
        helpsource = MEMOREAD("GET12.HLP")
      OTHERWISE
        helpsource = MEMOREAD("WAIT1.HLP")
    ENDCASE
  CASE call_prg = "OPTION2"
    DO CASE
      CASE input_var = "XSPOUSENAM"
        helpsource = MEMOREAD("GET21.HLP")
      CASE input_var = "XPHONE"
        helpsource = MEMOREAD("GET22.HLP")
      OTHERWISE
        helpsource = MEMOREAD("WAIT2.HLP")
    ENDCASE
ENDCASE

SAVE SCREEN
@  2,48 CLEAR TO 23,78
@  2,48 TO 23,78 DOUBLE

@ 19,49 TO 19,77 DOUBLE
@ 20, 50 SAY "  PGDN PGUP Scrolls Help"

@ 21,49 TO 21,77 DOUBLE
@ 22, 50 SAY "ESC-Return   "
temp = SETCOLOR(highcolor)
@ 22, 61 SAY " F1-Help Index "
SETCOLOR(temp)

x=MEMOEDIT(helpsource,  3, 50, 17, 77,.F.)

IF input_var == ""
  SET CURSOR OFF  && We were at a WAIT
ELSE
  SET CURSOR ON   && We were at a GET
ENDIF

SET KEY F1 TO HELP
SETCOLOR(color_was)
RESTORE SCREEN
KEYBOARD ""
RETURN

* 
FUNCTION FHELP
* 

PARAMETER status, element, winrow

color_was = SETCOLOR(helpcolor)
SET CURSOR OFF
SET KEY F1 TO HELP_NDX

DO CASE
  CASE lastkey() = 13
    RETURN 1  && Make selection, returning index of current item...

  CASE lastkey() = f1
    DO CASE
      CASE menu = "MAIN"
        helpfile = "MAIN" + STR(element,1) + ".HLP"
*     CASE menu = ...  && (Fill in the name of another menu)
*     CASE menu = ...  && (Fill in the name of another menu)
*     CASE menu = ...  && (Fill in the name of another menu)
    ENDCASE

    helpsource = MEMOREAD(helpfile)

    SAVE SCREEN
    @  2,48 CLEAR TO 23,78
    @  2,48 TO 23,78 DOUBLE

    @ 19,49 TO 19,77 DOUBLE
    @ 20, 50 SAY "  PGDN PGUP Scrolls Help"

    @ 21,49 TO 21,77 DOUBLE
    @ 22, 50 SAY "ESC-Return   "
    temp = SETCOLOR(highcolor)
    @ 22, 61 SAY " F1-Help Index "
    SETCOLOR(temp)

    x=MEMOEDIT(helpsource,  3, 50, 17, 77,.F.)

    RESTORE SCREEN
    KEYBOARD ""

ENDCASE

SET CURSOR OFF
SET KEY F1 TO
SETCOLOR(color_was)
RETURN 2


* 
PROCEDURE HELP_NDX
* 

SETCOLOR(hndxcolor)
DO WHILE .T.  && Non-terminating menu selection loop

  CLEAR SCREEN       && Notice we're not saving it first
  @  0, 0 TO 24,79
  @  3,35 SAY "HELP INDEX"

  DECLARE menuitem[3]
  menuitem[1] = [   How You, the Programmer, Can Use the Help Index     ]
  menuitem[2] = [   How You Got Where You'll Get By Choosing This Option]
  menuitem[3] = [   RETURN To Application                               ]

  @ 6,9 TO 10,69
  menuchoice = ACHOICE( 7, 10, 9, 68, menuitem)

  DO CASE
  CASE menuchoice == 0  && User pressed Esc
    LOOP
  CASE menuchoice == 1 .OR. menuchoice == 2
    CLEAR SCREEN
    helpfile = "HLPNDX" + STR(menuchoice,1) + ".HLP"
    helpsource = MEMOREAD(helpfile)

    @  0, 0 TO 24,79 DOUBLE

    @ 22, 2 TO 22,77 DOUBLE
    phrase = "  PGDN PGUP Scrolls Help         ESC to Return to Program. "
    CenterSay(phrase,23)

    x=MEMOEDIT(helpsource,  2, 10, 21, 70,.F.)

    KEYBOARD CHR(27)
    RETURN                   && Do we really want to return from here?
  CASE menuchoice == 3
    KEYBOARD CHR(27)
    RETURN
  ENDCASE

ENDDO  && Non-terminating menu selection loop


* 
FUNCTION CenterSay
* 
PARAMETERS phrase, line
@  line, 40-(LEN(phrase)/2) SAY phrase
RETURN .T.

* 

