*--------------------------------------------------------
*  Screen graphics command module (bar graph)           |
*  Universal terminal version                           |
*  John Hathaway    3/1/83                              |
*--------------------------------------------------------
RELEASE ALL
SET TALK OFF
ERASE
*--------------------------------------------------------
*       new DBF file ?            			|
*--------------------------------------------------------
? 'DBASE SCREEN GRAPHICS COMMAND PROGRAM'
?
ACCEPT 'USE LOGGED IN DATA BASE? (Y/N)' TO YS
IF !(YS)<>'Y'
    ACCEPT 'ENTER DATA BASE NAME' TO name
    USE &name
ENDIF
ERASE
RELEASE YS
*--------------------------------------------------------
* setup field variables and data base read conditions   |
*--------------------------------------------------------
? 'ENTER FIELD VARIABLES AND CONDITIONS BELOW'
?
ACCEPT '   FIELD X' TO vx
ACCEPT '   FIELD Y' TO vy
ACCEPT 'CONDITIONS' TO C
?
?
ACCEPT 'GRAPH TYPE ( <S>catter or <B>ar )' TO bars
IF !(bars)='B'
ACCEPT 'LABEL FIELD' TO label
ENDIF
ERASE
?'DETERMINING MINIMUM AND MAXIMUM DATA POINTS ...'
?
STORE -10000 TO xmax
STORE 10000 TO xmin
STORE -10000 TO ymax
STORE 10000 TO ymin
STORE 1 TO num
STORE 0 TO sume
GOTO TOP
DO WHILE .NOT. EOF
*--------------------change following line for cursor up and remove '*'
*   DISPLAY OFF 'RECORD #:',#,CHR(11)
  IF &C
    IF &vx<=xmin
        STORE &vx TO xmin
    ELSE
    IF &vx>=xmax
        STORE &vx TO xmax
    ENDIF
    ENDIF
    IF &vy<=ymin
        STORE &vy TO ymin
    ELSE
    IF &vy>=ymax
        STORE &vy TO ymax
    ENDIF
    ENDIF
    STORE num+1 TO num
    STORE sume+&vy TO sume
  ENDIF
    SKIP+1
ENDDO
*-------------------------------------------------------
* display minimum and maximum - allow alternate entries|
*-------------------------------------------------------
ERASE
@ 2,10 SAY 'AXIS SETUP SCREEN'
@ 5,10 SAY 'NUMBER:'
@ 5,20 SAY STR(num,6,0)
@ 7,10 SAY 'AVERAGE:'
@ 7,20 SAY STR(sume/num,8,2)
@ 8,10 SAY '------------------'
@ 10,10 SAY 'LOWER X' GET xmin
@ 11,10 SAY 'UPPER X' GET xmax
@ 13,10 SAY 'LOWER Y' GET ymin
@ 14,10 SAY 'UPPER Y' GET ymax
IF NUM>15
@ 17,5 SAY 'Too many points for BAR GRAPH. Switching to SCATTERPLOT.'
STORE 'S' TO BARS
ENDIF
READ
*--------------------------------------------------------
*          determine axis scaling factors         	|
*--------------------------------------------------------
STORE xmax-xmin TO xdif
STORE xdif/5 TO xinc
STORE ymax-ymin TO ydif
STORE ydif/4 TO yinc
STORE 1 TO X
STORE 1 TO Y
STORE 1 TO A
ERASE
*--------------------------------------------------------
*                    draw Y axis			|
*--------------------------------------------------------
STORE ymax TO B
STORE '    ' TO D
DO WHILE A<23
    STORE (A-2)/5 TO F
    IF ymax>10
        STORE STR(B-F*yinc,3) TO D
    ELSE
        STORE STR(B-F*yinc,3,1) TO D
    ENDIF
    IF A=2 .OR. A=7 .OR. A=12 .OR. A=17 .OR. A=22
        @ A,1 SAY D
        @ A,4 SAY '+'
    ELSE
        @ A,4 SAY '|'
    ENDIF
    STORE A+1 TO A
ENDDO
*--------------------------------------------------------
*                       draw X axis			|
*--------------------------------------------------------
STORE 0 TO A
@ 22,4 SAY '+--------------+--------------+--------------+--------------+--------------+'
STORE 15 TO N5
DO WHILE A<6
    IF A=5
        STORE 14.4 TO N5
    ENDIF  
    STORE xmin+A*xinc TO B
    @ 23,A*N5+2 SAY STR(B,4,1)
    STORE A+1 TO A
ENDDO
@ 1,50 SAY 'Y AXIS ='
@ 1,58 SAY vy
@ 1,30 SAY 'X AXIS ='
@ 1,38 SAY vx
*--------------------------------------------------------
*               read file and plot data 		|
*--------------------------------------------------------
GOTO TOP
DO WHILE .NOT. EOF
    IF &C 
        STORE (&vx-xmin)/xdif*75 TO X1
        STORE (&vy-ymin)/ydif*20 TO Y1
        STORE 22-Y1 TO JJ
      IF !(bars)='B'
        @ JJ,X1+3 SAY '*'
        @ JJ,X1+4 SAY '*'
        @ JJ,X1+5 SAY '*'
        STORE JJ+1 TO JJ
        DO WHILE JJ<22
            @ JJ,X1+3 SAY '|'
            @ JJ,X1+5 SAY '|'
            STORE JJ+1 TO JJ
        ENDDO
*--------------------------------------------------------
*    plot labels vertically inside bars			|
*--------------------------------------------------------
        STORE 1 TO L
        IF TYPE(&label)='N'
           STORE STR(&label,4) TO Tlabel
        ELSE
           STORE TRIM(&label) TO Tlabel
        ENDIF
        DO WHILE L<=LEN(Tlabel)
            @ 21-LEN(Tlabel)+L,X1+4 SAY $(Tlabel,L,1)
            STORE L+1 TO L
        ENDDO
*------------------------------------ scatter plot
      ELSE
        @ JJ,X1+4 SAY '*'
      ENDIF
    ENDIF
    SKIP+1
ENDDO
RELEASE ALL
*--------------------------------------------------------
*     jump up here to avoid rolling the screen up	|
*--------------------------------------------------------
STORE '  ' TO YS
@ 1,70 SAY 'RET' GET YS
READ
RETURN
