/*
͸
 Dec 91                      UDO                          ver 1.1 
;      User Defined Objects within Clipper         ͵
                         By Steve Baker                             
                                                                    
                    Preprocessor Header file                        
    Must #include at beginning of each Class Definition File        
;
*/

#command;
             CREATE CLASS <class> [INHERIT] [FROM <SuperClass>] ;
=>;//
             function <class>                        ;;
             static __UdoClass                       ;;
             if __UdoClass == NIL                    ;;
             __UdoClass := __UdoNew(<"class">[,<"SuperClass">,{|| <SuperClass>()} ]) ;;
             local: ; readwrite:

#translate;
             ENDCLASS;
=>;//
             end class;;
             return __UdoClass

#command;
             INHERIT [FROM] <SuperClass> ;  // multiple inheritance
=>;//
             __UdoClass:Inherit(<SuperClass>())

#command;
             METHOD <method1> [<lVirtual: VIRTUAL>] ;
=>;//
             __UdoClass:NewMethod(<(method1)> , {|a| <method1>(a) } , <.lVirtual.>)

#command;
             INSTVAR <ivar>  [LINK <fname>]    ;
=>;//
             __UdoClass:NewInstVar(<(ivar)>[,,{|__oUdo|__oUdo:=__UdoObj() , <fname>} ])

#command;
             INSTVAR <ivar> :=  <def>   [LINK <fname>] ;
=>;//
             __UdoClass:NewInstVar(<(ivar)> ,<def> [,{|__oUdo|__oUdo:=__UdoObj() , <fname>} ])

#command;
             INSTVAR <ivar> default <def> [LINK <fname>] ;
=>;//
             __UdoClass:NewInstVar(<(ivar)> ,<def> [,{|__oUdo|__oUdo:=__UdoObj() , <fname>} ])

#command;
             METHOD FUNCTION <proc>  ;
=>;//
             STATIC FUNCTION <proc> ; local __aUdo := __UdoFOA(), __oUdo := __UdoObj()

#command;
             METHOD FUNCTION <proc> (<p1>[, <pN> ])  ;
=>;//
             STATIC FUNCTION <proc> (__aParam);;
             local __nUdo :=1 , __aUdo := __UdoFOA(), __oUdo := __UdoObj() ; local <p1> := __udocnt [,<pN> := __udocnt ]

#command;
             METHOD PROCEDURE <proc>  ;
=>;//
             STATIC PROCEDURE <proc> ; local __aUdo := __UdoFOA(), __oUdo := __UdoObj()

#command;
             METHOD PROCEDURE <proc> (<p1>[, <pN> ])  ;
=>;//
             STATIC PROCEDURE <proc> (__aParam);;
             local __nUdo :=1 , __aUdo := __UdoFOA(), __oUdo := __UdoObj() ; local <p1> := __udocnt [,<pN> := __udocnt ]

#translate;
             CLASS FUNCTION <proc> [(<params,...>)]  ;
=>;//
             FUNCTION <proc> [(<params>)] ; local __aUdo := __UdoFOA(), __oUdo := __UdoObj()

#translate;
             CLASS PROCEDURE <proc> [(<params,...>)]  ;
=>;//
             PROCEDURE <proc> [(<params>)] ; local __aUdo := __UdoFOA(), __oUdo := __UdoObj()

#command;
             CONSTRUCTOR <name>  ;
=>;//
             __UdoClass:Constructor(<"name">, {|a| <name>(a) } )

#command;
             CONSTRUCTOR FUNCTION <proc> ;
=>;//
             STATIC FUNCTION <proc> ; Local __osUdo := __UdoGS(__UdoObj():NewInstance) , __oUdo := __UdoObj() ,  __aUdo := __UdoFOA() , __nxUdo := __UdoLevel(1)

#command;
             CONSTRUCTOR FUNCTION <proc> (<p1>[, <pN> ])  ;
=>;//
             STATIC FUNCTION <proc> ;
             [(__aParam) ; local __nUdo :=1 ; local <p1> := __udocnt] [,<pN> := __udocnt ] ;;
             Local __osUdo := __UdoGS(__UdoObj():NewInstance), __oUdo := __UdoObj() ,  __aUdo := __UdoFOA() , __nxUdo := __UdoLevel(1)

#translate;
             CONSTRUCTOR PROCEDURE;
=>;//
             CONSTRUCTOR FUNCTION

#translate;
             ENDCONSTRUCTOR;
=>;//
             __UdoLevel(0) ; return __UdoGS(__osUdo)

#command;
             INITIALIZER <*sclass*>  ;
=>;//
             __UdoIzer(__UdoObj(),<sclass>)

//
#command     ReadOnly:        =>     __UdoRO(.t.)
#command     ReadWrite:       =>     __UdoRO(.f.)
#command     Export:          =>     __UdoVis(0)
#command     Protect:         =>     __UdoVis(1)
#command     Protected:       =>     __UdoVis(1)
#command     Local:           =>     __UdoVis(2)
#command     Private:         =>     __UdoVis(2)
//
#translate   ::               =>     __oUdo:
#translate   :virtual:        =>     __oUdo:
#translate   :self:           =>     __oUdo:
#translate   __oUdo:self      =>     __oUdo
//
#translate   :::              =>     __UdoSobj(__oUdo):
#translate   :super:          =>     __UdoSobj(__oUdo):
#translate   __udocnt         =>     __aParam\[__nUdo ++\]

