/******************************************************************************
* TXT2FMT.C:                                                   Dan Kenny 6/88 *
*           Function- Converts standard text file to Dbase .FMT file code.    *
******************************************************************************/

#include <dir.h>
#include <dos.h>
#include <stdio.h>
#include <string.h>

void invalid(void);
void parse_switches(void);
void parse_parms(void);
void skipblanks(void);
void gen_fmt(void);
void strcatc(char *sptr,int ch);

FILE *f1, *f2;
char cmd_line[255], *cptr, file_in[13], file_out[13],
     g_char = '@', s_char = '%';
int p_switch=0, g_switch=0, s_switch=0, 
    max_scr=24, max_prt=62;


/******************************************************************************
*   MAIN                                                                      *
******************************************************************************/
main(int argc, char *argv[])
{                                                                
   register int i;

   printf("TXT2FMT.C - Text file to Dbase FMT file converter"
          " - Dan Kenny/Omaha,Ne. 1988\n");
   if (argc == 1) {
      invalid();
   }
   for (i=1; i < argc; i++) {                       /* Copy command line     */
       strcat(cmd_line,argv[i]);  
       strcat(cmd_line," ");
   }                        
   cmd_line[strlen(cmd_line)-1] = '\0';

   cptr = cmd_line;                                 /* Set parsing pointer   */
   parse_switches();

   strcpy(file_in,cmd_line);                        /* Input file            */

   if (!strchr(file_in,'.')) {                      /* Concat .EXT if needed */
      strcpy(file_out,file_in);
      strcat(file_in,".TXT");
   }
   else {                                            /* Parse filename w/o EXT*/
      cptr = file_in;
      for (cptr = file_in,i=0; *cptr != '.'; cptr++,i++)
          file_out[i] = *cptr;
      file_out[i] = '\0';
   }
   strcat(file_out,".FMT");                         /* Output file           */

   if ((f1 = fopen(file_in,"r")) == NULL)  {        /* Open 'em up           */
      printf("--Hey: Can't find %s\n",file_in);
      exit(-1);
   }
   if ((f2 = fopen(file_out,"w")) == NULL)  {
      printf("--Hey: Can't open %s\n",strupr(file_out));
      exit(-1);
   }
   
   printf("--Creating %s....",strupr(file_out));

   gen_fmt();                                       /* Generate FMT file     */

   printf("done.\n");

   fclose(f1);                                      /* Close 'em up          */
   fclose(f2);       
}

/******************************************************************************
*  INVALID - Display proper syntax and exit program                           *
******************************************************************************/
void invalid(void)
{
   printf("\nUsage: TXT2FMT <optional switches> <filename(.ext)>             \n"   
          "\nSwitches:\n"
          "    -p  generate print FMT file      (screen is default)          \n"     
          "    -g<char> override GET variable-identifier char (@ is default) \n"     
          "    -s<char> override SAY variable-identifier char (%% is default)\n"     
          "\n" 
          "TXT2FMT is a no-frills text file to Dbase FMT file converter.    \n"
          "  This program takes text input and writes @...SAY/GET commands. \n"     
          "  If a text line contains special characters (\"variable         \n"     
          "  identifier\" chars), the program will treat all adjacent text  \n"
          "  up to the first blank as a variable name. The default          \n"
          "  \"variable-identifier\" chars are @ for GETs and %% for SAYs.  \n"
          "  Two types of FMT files can be created with this program: screen\n"
          "  (default) and print (-p switch). Screen FMT files issue a READ \n"
          "  every 24 lines. Print FMT files are intended for the printer,  \n"
          "  issue only @...SAYs, and issue an EJECT every 62 lines. Print  \n"
          "  FMT files contain non-standard FMT commands and should be      \n"
          "  called with a DO <FMTfile>.FMT command. \n");

   exit(0);
}

/******************************************************************************
*  PARSE_SWITCHES- Recursively parses switches from the command line          *
******************************************************************************/
void parse_switches(void)
{                
   
   int i;

   skipblanks();
   if (*cptr == '-') {                              /* Switch is there       */
      cptr++;
      switch (tolower(*cptr)) {
         case 'p' : p_switch = 1;                   /* Report generator      */
                    cptr++;                
                    skipblanks();
                    strcpy(cmd_line,cptr);
                    cptr = cmd_line;
                    if (*cptr != '\0') 
                       parse_switches();  
                    break;
         case 'g' : g_switch=1;                     /* Override GET char     */
                    cptr++;                
                    g_char = *cptr;
                    cptr++;
                    skipblanks();
                    strcpy(cmd_line,cptr);
                    cptr = cmd_line;
                    if (*cptr != '\0') 
                       parse_switches();  
                    break;
         case 's' : s_switch=1;                     /* Override SAY char     */
                    cptr++;                
                    s_char = *cptr;
                    cptr++;
                    skipblanks();
                    strcpy(cmd_line,cptr);
                    cptr = cmd_line;
                    if (*cptr != '\0') 
                       parse_switches();  
                    break;
      }                    
   }
}

/******************************************************************************
*  SKIPBLANKS -  Moves the parsing pointer to the first non-blank             *
*                character on the command line                                *
******************************************************************************/
void skipblanks(void)
{               
   while (*cptr == ' ') 
      cptr++;

}

/******************************************************************************
*  GEN_FMT - Generate Dbase code                                              *
******************************************************************************/
void gen_fmt(void)
{
   register char *p;

   char db_var[100][80], out_str[255], in_str[255], file[13];
   int  i, len, var_count, row, col, var_flag, blnk_flag;                                

   i = 0;
   len = 0;                                   /* Length of input string      */
   row = 0;                                   /* Output row position         */
   col = 0;                                   /* Col pos of input string     */
   var_count = 0;                             /* Number of db_vars on a line */

                                                    /* Setup header stuff    */

   fprintf(f2,"*-------------- FMT file generated by TXT2FMT ---------- ");    
   
   if (!p_switch) 
      fprintf(f2,"SCREEN FILE --- *\n*\n");
   else {                        
      fprintf(f2,"PRINT FILE ---- *\n*\n");
      fprintf(f2,"SET DEVICE TO PRINT\n");    
      fprintf(f2,"SET CONSOLE OFF\n");    
      fprintf(f2,"*\n");    
   }
 

   p = fgets(in_str,255,f1);                     /* Get input text line   */
   in_str[strlen(in_str)-1] = '\0';              /* Strip '\n' from line  */

   while (!feof(f1)) {
      blnk_flag = 1;                     /* Flag for blank line on out str */
      var_flag = 0;                      /* Flag for extract variable mode */
      col = 0;
      len = strlen(in_str);

      sprintf(out_str, "@ %2d, %2d SAY %c", row, col, '\"');

      while (col <= len) {
         if ((*p == s_char) || (*p == g_char)) {    /* Variable-identifier   */
            if (var_flag == 1) 
               var_count++;                         /* Set up db_var string  */
            if ((*p == s_char) || (p_switch)) 
               sprintf(db_var[var_count],"@ %2d, %2d SAY ", row, col);
            else 
               sprintf(db_var[var_count],"@ %2d, %2d GET ", row, col);
            var_flag = 1;
            strcatc(out_str, ' ');                  /* Subst ' ' in output str*/
            *p = ' ';
            p++;
            col++;
         }

         if (var_flag == 1)  {                      /* Var extract mode is ON*/
            if (*p == ' ') {                        /* Turn off if a blank   */
               var_flag = 0;
               var_count++;
            }  
            else                                    /* Else, add to db_var str*/
               strcatc(db_var[var_count], *p);
            strcatc(out_str, ' ');                  /* Subst ' ' in output str*/
         }
         else {                                     /* Extract is NOT on...  */
            if (*p != ' ' && *p != '\0')            /* if non-blank, set     */
               blnk_flag = 0;                       /*    blank flag OFF     */
            if (*p == '\"')                         /* if delimiter, break up*/
               strcat(out_str,"\" + [\"] + ");
            strcatc(out_str, *p);                   /* Add char to output str*/
         }

         p++;
         col++;
      }                   

      if (var_flag == 1)  {                         /* EOLN: if extract mode */
         var_flag = 0;                              /*    ON, turn OFF       */
         var_count++; 
      }              
      if (!blnk_flag) {                             /* If not a blank line,  */
         strcatc(out_str, '\"');                    /*    output line        */
         fprintf(f2,"%s\n",out_str);   
      }

      row++;
      if (!p_switch) {                              /* Screen FMT mode:      */
         if (row > max_scr) {                       /* If over maximum screen*/
            var_count--;                            /*    len, output db_vars*/
            for (i=0; i <= var_count; i++)          /*    and issue READ cmd */
                fprintf(f2,"%s\n",db_var[i]);    
            fprintf(f2,"READ\n");    
            fprintf(f2,"*\n");    
            var_count = 0;
            row = 0;
         }            
      }
      else {                                        /* Print FMT mode:       */
         var_count--;                               /* Output db_vars...     */
         for (i=0; i <= var_count; i++) 
            fprintf(f2,"%s\n",db_var[i]);           /* If over maximum page  */
         var_count = 0;                             /*    len, issue EJECT   */
         if (row > max_prt) {                       /*    cmd                */
            fprintf(f2,"EJECT\n");    
            fprintf(f2,"*\n");    
            row = 0;
         }  
      }
      p = fgets(in_str,255,f1);                     /* Get input text line   */
      in_str[strlen(in_str)-1] = '\0';              /* Strip '\n' from str   */
   }             

   var_count--;                                     /* Eof: Output remaining */
   for (i=0; i <= var_count; i++)                   /*      db_vars          */
       fprintf(f2,"%s\n",db_var[i]);    

   if (p_switch) {                                  /* If print FMT mode on, */
       fprintf(f2,"EJECT\n");                       /*    output trailer     */
       fprintf(f2,"*\n");                           /*    commands           */
       fprintf(f2,"SET DEVICE TO SCREEN\n");    
       fprintf(f2,"SET CONSOLE ON\n");    
   }
   fprintf(f2,"*\n* : End  FORMAT \n");    

}

/******************************************************************************
*  STRCATC - Concatenates a char to a null-terminated string                  *
******************************************************************************/
void strcatc(char *sptr,int ch)
{                     
   char tmpstr[2];

   sprintf(tmpstr,"%c",ch);
   strcat(sptr,tmpstr);
}
