/***
 * Program : CDATE2DT.PRG
 * Notice  : Copyright (c) BITwise Computer Services, 1991-1992
 * Date    : 09/17/92
 * Author  : David Christian
 * Purpose : Converts many date string formats into Clipper date
 * Notes   : Compile with /n /w
 *
 * Revised :
 *
*/

#include"txt2dbf.ch"

FUNCTION B_CDATE2DT(cDate,cFormat)
   // SYNTAX: <expD1>:=B_CDATE2DT(<expC1>,[<expC2>])
   //         - CONVERTS DATE STRING cDate TO CLIPPER DATE
   //         - cFormat IS DATE STRING FORMAT (DEFAULT "M2D2Y2")
   //         - RETURNS EMPTY() DATE IF INVALID FORMAT OR STRING
   //         - SAMPLE FORMATS:
   //            "M2D2Y2"  =>  "122592"   MMDDYY
   //            "M2D2Y4"  =>  "12251992" MMDDYYYY
   //            "D2M2Y2"  =>  "251292"   DDMMYY
   //
   LOCAL cMM:="", cDD:="", cYY:="", nX:=0, cType:="", nLen:=0, nPos:=1
   DEFAULT cFormat TO "M2D2Y2"
   cFormat:=UPPER(cFormat)
   FOR nX:=1 TO 6 STEP 2
      cType:=SUBSTR(cFormat,nX,1)
      nLen:=VAL(SUBSTR(cFormat,nX+1,1))
      DO CASE
      CASE cType=="M"
         cMM:=SUBSTR(cDate,nPos,nLen)
      CASE cType=="D"
         cDD:=SUBSTR(cDate,nPos,nLen)
      CASE cType=="Y"
         cYY:=SUBSTR(cDate,nPos,nLen)
      ENDCASE
      nPos+=nLen
   NEXT
RETURN(CTOD(cMM+"/"+cDD+"/"+cYY))

//EOF
