/*

 Program....: TwoBrowse()
 System.....:
 Author.....: Eugene Fallon Jr. - Copyright Fallon Consultants Ltd., 1992
 Date.......: Wed  10-07-1992
 Purpose....: Example code for using SkipBlock to set a relation between two
            : arrays, and browse the two arrays simultaneously.
            :
 Notes......: ESC quits program
            :
            :

*/

#Include "InKey.Ch"

Local oBrows_1,;
      oBrows_2,;
      nKey,;
      aBElement1 := { {"Key1",  "Text for Key 1 "} ,;
                      {"Key2",  "Text for Key 2 "} ,;
                      {"Key3",  "Text for Key 3 "} ,;
                      {"Key4",  "Text for Key 4 "} ,;
                      {"Key5",  "Text for Key 5 "} ,;
                      {"Key6",  "Text for Key 6 "} ,;
                      {"Key7",  "Text for Key 7 "} ,;
                      {"Key8",  "Text for Key 8 "} ,;
                      {"Key9",  "Text for Key 9 "} ,;
                      {"Key10", "Text for Key 10"} ,;
                      {"Key11", "Text for Key 11"} ,;
                      {"Key12", "Text for Key 12"} ,;
                      {"Key13", "Text for Key 13"} ,;
                      {"Key14", "Text for Key 14"} ,;
                      {"Key15", "Text for Key 15"} ,;
                      {"Key16", "Text for Key 16"} ,;
                      {"Key17", "Text for Key 17"} ,;
                      {"Key18", "Text for Key 18"} ,;
                      {"Key19", "Text for Key 19"} ,;
                      {"Key20", "Text for Key 20"} },;
      aBElement2 := { {"Key20", "Text for Key 20"} ,;
                      {"Key19", "Text for Key 19"} ,;
                      {"Key18", "Text for Key 18"} ,;
                      {"Key17", "Text for Key 17"} ,;
                      {"Key16", "Text for Key 16"} ,;
                      {"Key15", "Text for Key 15"} ,;
                      {"Key14", "Text for Key 14"} ,;
                      {"Key13", "Text for Key 13"} ,;
                      {"Key12", "Text for Key 12"} ,;
                      {"Key11", "Text for Key 11"} ,;
                      {"Key10", "Text for Key 10"} ,;
                      {"Key9",  "Text for Key 9 "} ,;
                      {"Key8",  "Text for Key 8 "} ,;
                      {"Key7",  "Text for Key 7 "} ,;
                      {"Key6",  "Text for Key 6 "} ,;
                      {"Key5",  "Text for Key 5 "} ,;
                      {"Key4",  "Text for Key 4 "} ,;
                      {"Key3",  "Text for Key 3 "} ,;
                      {"Key2",  "Text for Key 2 "} ,;
                      {"Key1",  "Text for Key 1 "}},;
      oColumn,;
      nEl_1 := nEl_2 := 1, nMoved := 0

// Clear the screen
CLS
// Create browse objects
// Brows_1
oBrows_1 := TBrowseNew(01, 01, 11, 78)
oBrows_1:GoTopBlock := { | | nEl_1 := 1 }
oBrows_1:GoBottomBlock := { | | nEl_1 := Len(aBElement1) }
oBrows_1:SkipBlock := { |n| nMoved := ;
                        TwoSkip(Len(aBElement1), @nEl_1, n, @nEl_2, ;
                        aBElement1, aBElement2) }
oColumn := TBColumnNew("", { | | aBElement1[nEl_1, 2] } )
oBrows_1:AddColumn(oColumn)

// Brows_2
oBrows_2 := TBrowseNew(14, 01, 23, 78)
oBrows_2:GoTopBlock := { | | nEl_2 := 1 }
oBrows_2:GoBottomBlock := { | | nEl_2 := Len(aBElement2) }
oBrows_2:SkipBlock := { |n| ArraySkip(Len(aBElement2), @nEl_2, n) }
oColumn := TBColumnNew("", { | | aBElement2[nEl_2, 2] } )
oBrows_2:AddColumn(oColumn)

// Display and stabilize the two browses
// Explode(00, 00, 12, 79, 5, "+w/b", " ", "aB1")
// Explode(13, 00, 24, 79, 5, "r/w", " ", "aB2")

// Now lets navigate the top array and move relatively through the bottom
Do While !oBrows_1:Stabilize() .and. NextKey() = 0
EndDo
Do While !oBrows_2:Stabilize() .and. NextKey() = 0
EndDo

// navigate the browses using key
Do While .T.
  Do While !oBrows_1:Stabilize() .and. NextKey() = 0
  EndDo
  Do While !oBrows_2:Stabilize() .and. NextKey() = 0
  EndDo

  nKey := Inkey(0)
  Do Case
  Case nKey == K_UP //  Up one row
    oBrows_1:Up()
    oBrows_2:RefreshAll()

  Case nKey == K_DOWN
    oBrows_1:Down()
    oBrows_2:RefreshAll()

  Case nKey == K_PGUP //  Up on page
    oBrows_1:PageUp()
    oBrows_2:RefreshAll()

  Case nKey == K_PGDN //  Down one page
    oBrows_1:PageDown()
    oBrows_2:RefreshAll()

  Case nKey == K_CTRL_PGUP
    oBrows_1:GoTop()
    oBrows_2:RefreshAll()

  Case nKey == K_CTRL_PGDN //  Down to the last record
    oBrows_1:GoBottom()
    oBrows_2:RefreshAll()

  Case nKey == K_ESC
    Exit

  Otherwise
    // Ignore any other keystrokes for now
  EndCase
EndDo


// End of program
Quit

/*

 Program....: TwoSkip()
 System.....: TwoBrowse
 Author.....: Eugene Fallon Jr. - Copyright Fallon Consultants Ltd., 1992
 Date.......: Wed  10-07-1992
 Purpose....: Function for use by SkipBlock which relates two arrays and
            : allows navigation through two simultaneous browses.
            :
 Notes......: Modified from ArraySkip function in Clipper Developers guide
            : see below.
            :

*/



Function TwoSkip(aLen, curPos1, howMany, curPos2, aSearch, aTarget)
local actual

if howMany >= 0                // Moving forward?
  if (CurPos1 +howMany) > aLen     // Can't go that far!
    actual := aLen - CurPos1          // Actual is whatever is left
    CurPos1 := aLen                   // Put pointer at end
  else                            // Can move the whole distance...
    actual := howMany                // Actual is number requested
    CurPos1 += howMany                // Move pointer forward
  endif
else                           // Moving backward?
  if (CurPos1 +howMany) < 1        // Can't go that far!
    actual := 1 -CurPos1              // Actual is whatever was left
    CurPos1 := 1                      // Put pointer at top
  else                            // Can move the whole distance...
    actual := howMany                // Actual is number requested
    CurPos1 += howMany                // Move pointer backward
  endif
endif
CurPos2 := AScan(aTarget, {|aSrch| ;
            (aSrch[1] == aSearch[CurPos1,1]) })
return actual
// Eof...................: TwoSkip()

/*
   Listing 25.11. ArraySkip(), a b:skipBlock function for arrays.
   Author: Craig Yellick
   Excerpted from "Clipper 5: A Developer's Guide"
   Copyright (c) 1991 M&T Books
                      501 Galveston Drive
                      Redwood City, CA 94063-4728
                      (415) 366-3600
*/

// NOTE: must compile with the /N option!

function ArraySkip(aLen, curPos, howMany)
/*
   General purpose array skipping function intended for
   use with TBrowse b:skipBlocks. You must pass the curPos
   parameter by reference (use the @ operator) for this
   function to work correctly with TBrowse.
*/

local actual

if howMany >= 0                // Moving forward?
  if (curPos +howMany) > aLen     // Can't go that far!
    actual := aLen - curPos          // Actual is whatever is left
    curPos := aLen                   // Put pointer at end
  else                            // Can move the whole distance...
    actual := howMany                // Actual is number requested
    curPos += howMany                // Move pointer forward
  endif
else                           // Moving backward?
  if (curPos +howMany) < 1        // Can't go that far!
    actual := 1 -curPos              // Actual is whatever was left
    curPos := 1                      // Put pointer at top
  else                            // Can move the whole distance...
    actual := howMany                // Actual is number requested
    curPos += howMany                // Move pointer backward
  endif
endif
return actual

// end of file CHP2511.PRG

// Eof...................: TwoBrowse()
