/*
 Ŀ
  Program ..: Makestru.prg                                                
  Author ...: Tom Underwood                                               
  Date .....: May 1994                                                    
 Ĵ
  Notes.....: Create a function to check the structure of your tables.    
 
 
 1. Compile with /l /m /n /w

 2. This program will produce CHKSTRUC.PRG and DATA.CH based on all 
    the DBF files in the current directory.

 3. You can use this function to update tables with changed structures
    or create new tables if none exist.

 4. I am using temp.dbf as my temporary file as I know I don't have one,
    you may need a routine to get a unique file name for the temporary
    .dbf file.

 5. The function Make_Index() works in a similar way to Check_Dbf() i.e.

    #include "data.ch"

    *
    Function Make_Index( nTable )
    *

    Do Case

        Case nTable = DATA_ATABLE

            select atable

            index on text to atable

    EndCase

    Return NIL

 6. The function SysMemoExt() is something I use to make switching
    between different RDD's easier.   See below...

    #define  DBF_NTX  1
    #define  DBF_CDX  2

    Initialise( DBF_NTX )  // I change this line to switch RDD's.

    etc ...

    *
    Function Initialise( nMode )
    *

    Do Case

        Case nMode = DBF_NTX
            REQUEST DBFNTX
            RDDSETDEFAULT( "DBFNTX" )
            SysNtxExt(  "ntx" )
            SysMemoExt( "dbt" )

        Case nMode = DBF_CDX
            REQUEST DBFCDX
            RDDSETDEFAULT( "DBFCDX" )     // Comment out this whole section
            SysNtxExt(  "idx" )           // if you aren't using DBFCDX to
            SysMemoExt( "fpt" )           // save linking in the extra library.

    EndCase

    Return NIL

    *
    Function SysNtxExt( cExtention )
    *
    Static cResult

    cResult := Iif( cExtention = NIL, cResult, cExtention )

    Return cResult

    *
    Function SysMemoExt( cExtention )
    *
    Static cResult

    cResult := Iif( cExtention = NIL, cResult, cExtention )

    Return cResult

*/

/*****************************************************************************
   Include file headers.
*****************************************************************************/

#include "directry.ch"
#include "dbstruct.ch"

*
Procedure Main()
*
Local aDirectory := Directory( "*.dbf" )
Local aDbfs      := {}
Local aStructure := {}
Local nFields    := 0
Local nMain      := 0
Local nSub       := 0

For nMain = 1 to Len( aDirectory )              // Transfer the database names
    Aadd( aDbfs, aDirectory[ nMain, F_NAME ] )  // to a new array. You could 
Next                                            // probably use aDirectory, but
                                                // it is easier to sort this way.

Asort( aDbfs )                                  // Put the tables in 
                                                // alphabetical order.
Set Printer To chkstruc.prg
Set Print On

Qqout( '/*' )
Qout( ' Ŀ' )
Qout( '  Program ..: Chkstruc.prg                                                ' )
Qout( '  Author ...: Tom Underwood                                               ' )
Qout( '  Date .....: ' + Dtoc( Date() ) + '                                                    ' )
Qout( ' Ĵ' )
Qout( '  Notes.....: Check existing data structure or create new table           ' )
Qout( '  Syntax....: Check_Dbf( <nTable> )                                       ' )
Qout( '                                                                          ' )
Qout( '            : nTable... Defined in data.ch                                ' )
Qout( '                                                                          ' )
Qout( '  Example...: For nCount = 1 To DATA_TOTALDB                              ' )
Qout( '                  Check_Dbf( nCount )                                     ' )
Qout( '              Next                                                        ' )
Qout( '                                                                          ' )
Qout( ' ' )
Qout( '*/' )
Qout()
Qout( '/*****************************************************************************' )
Qout( '   Include file headers.' )
Qout( '*****************************************************************************/' )
Qout()
Qout( '#include "data.ch"' )
Qout()
Qout( '*' )
Qout( 'Function Check_Dbf( nTable )' )
Qout( '*' )
Qout( 'Local aStr := {}' )
Qout()
Qout( 'Do Case' )
Qout()

For nMain = 1 To Len( aDbfs )          // For each table.

    Use ( Left( aDbfs[ nMain ], At( ".", aDbfs[ nMain ] ) - 1 ) )

    aStructure := Dbstruct()           // Read the structure.
    nFields    := Fcount()             // Count the fields.

    Qout( '    Case nTable = DATA_' + Alias() )
    Qout()

    For nSub = 1 to nFields            // For each field.

        Qout( '        Aadd( aStr, { "' + Trim( aStructure[ nSub, DBS_NAME ] );
                     + '", "' + Trim( aStructure[ nSub, DBS_TYPE ] );
                     + '", '  + Ltrim( Str( aStructure[ nSub, DBS_LEN ], 5 ) );
                     + ', '   + Str( aStructure[ nSub, DBS_DEC ], 2 ) + ' } )' )
    Next

    Qout()
    Qout( '        Db_Update( "' + Trim( Alias() ) + '", aStr, nTable )' )
    Qout()

Next

Qout( 'EndCase' )
Qout()
Qout( 'Return NIL' )
Qout()

Qout( '*' )
Qout( 'Function Db_Update( cTable, aStr, nTable )' )
Qout( '*' )
Qout( 'Local aStructure := {}' )
Qout( 'Local cOldDbf    := cTable + ".dbf"' )
Qout( 'Local cOldMem    := cTable + "." + SysMemoExt()' )
Qout()
Qout( 'DbCreate( "temp", aStr )' )
Qout()
Qout( 'If File( cOldDbf )' )
Qout()
Qout( '    Use ( cTable )' )
Qout( '    aStructure := DbStruct()' )
Qout( '    Use' )
Qout()
Qout( '    If !ArraySame( aStructure, aStr )' )
Qout( '        Use temp' )
Qout( '        Append From ( cTable )' )
Qout( '        Erase ( cOldDbf )' )
Qout( '        Use' )
Qout( '        Rename temp.dbf To ( cOldDbf )' )
Qout( '        If File( "temp." + SysMemoExt() )' )
Qout( '            Erase ( cOldMem )' )
Qout( '            Rename ( "temp." + SysMemoExt() ) To ( cOldMem )' )
Qout( '        End' )
Qout( '        Use ( cOldDbf )' )
Qout( '        Make_Index( nTable )' )
Qout( '        Use' )
Qout( '    End' )
Qout()
Qout( 'Else' )
Qout()
Qout( '    Use temp' )
Qout( '    Copy To ( cTable )' )
Qout( '    Use ( cOldDbf )' )
Qout( '    Make_Index( nTable )' )
Qout( '    Use' )
Qout()
Qout( 'End' )
Qout()
Qout( 'Erase temp.dbf' )
Qout()
Qout( 'If File( "temp." + SysMemoExt() )' )
Qout( '    Erase ( "temp." + SysMemoExt() )' )
Qout( 'End' )
Qout()
Qout( 'Return NIL' )
Qout()
Qout( '*' )
Qout( 'Function ArraySame( aArray1, aArray2 )' )
Qout( '*' )
Qout( 'Local lresult := .f.' )
Qout( 'Local nCount1 := 0' )
Qout( 'Local nCount2 := 0' )
Qout()
Qout( 'Begin Sequence' )
Qout()
Qout( 'If Len( aArray1 ) == Len( aArray2 )' )
Qout( '    For nCount1 = 1 To Len( aArray1 )' )
Qout( '        For nCount2 = 1 To 4' )
Qout( '            If !( aArray1[ nCount1, nCount2 ] == aArray2[ nCount1, nCount2 ] )' )
Qout( '                Break' )
Qout( '            End' )
Qout( '        Next' )
Qout( '    Next' )
Qout( 'Else' )
Qout( '    Break' )
Qout( 'End' )
Qout()
Qout( 'lResult := .t.' )
Qout()
Qout( 'End Sequence' )
Qout()
Qout( 'Return lResult' )

Set Print Off

Set Printer To data.ch
Set Print On

QQout( '/*' )
Qout(  '    Data.ch' )
Qout(  '    Database numeric identifiers for indexing and opening.' )
Qout(  '*/' )
Qout()

For nMain = 1 To Len( aDbfs )          // For each table.

    Use ( Left( aDbfs[ nMain ], At( ".", aDbfs[ nMain ] ) - 1 ) )

    Qout( '#define DATA_' + Padr( Alias(), 8 ) + Str( nMain, 5 ) )

next

Qout()
Qout( '#define DATA_TOTALDB ' + Str( Len( aDbfs ), 5 ) )

Set Print Off
Set Printer To

Return

