/*
 Ŀ
  Program ..: Makedict.prg                                                
  Author ...: Tom Underwood                                               
  Date .....: May 1994                                                    
 Ĵ
  Notes.....: ObjectDB 1.1 Data Dictionary Creation Program.              
 
 
 1. Compile with /l /m /n /w

 2. This program will produce DATADICT.PRG containing all the DBF files 
    in the current directory.

 3. PRIMARY KEYS are set to the first field found in the table.

 4. Edit DATADICT.PRG to fine tune it later.

*/

/*****************************************************************************
   Include file headers.
*****************************************************************************/

#include "directry.ch"
#include "dbstruct.ch"

*
Procedure Main()
*
Local aDirectory := Directory( "*.dbf" )
Local aDbfs      := {}
Local aStructure := {}
Local nFields    := 0
Local nMain      := 0
Local nSub       := 0
Local cName      := ""
Local cType      := ""
Local cLine      := ""
Local cLen       := ""
Local nLen       := 0
Local nDecs      := 0

For nMain = 1 to Len( aDirectory )              // Transfer the database names
    Aadd( aDbfs, aDirectory[ nMain, F_NAME ] )  // to a new array. You could 
Next                                            // probably use aDirectory, but
                                                // it is easier to sort this way.

Asort( aDbfs )                                  // Put the tables in 
                                                // alphabetical order.
Set Printer To datadict.prg
Set Print On

Qqout( '/*' )
Qout( ' Ŀ' )
Qout( '  Program ..: Datadict.prg                                                ' )
Qout( '  Author ...: Tom Underwood                                               ' )
Qout( '  Date .....: ' + Dtoc( Date() ) + '                                                    ' )
Qout( ' Ĵ' )
Qout( '  Notes.....: ObjectDB 1.1 Data Dictionary.                               ' )
Qout( ' ' )
Qout( '*/' )
Qout()
Qout( '/*****************************************************************************' )
Qout( '   Include file headers.' )
Qout( '*****************************************************************************/' )
Qout()
Qout( '#include "ddl.ch"' )
Qout()
Qout( 'DATA DEFINITION MODULE' )
Qout()
Qout( 'DEFINE DATABASE MYDATA' )

For nMain = 1 To Len( aDbfs )          // For each table.

    Qout()

    Use ( Left( aDbfs[ nMain ], At( ".", aDbfs[ nMain ] ) - 1 ) )

    aStructure := Dbstruct()           // Read the structure.
    nFields    := Fcount()             // Count the fields.

    Qout( '    DEFINE TABLE ' + Padr( Lower( Alias() ), 13 ) +;
          'ALIAS ' + Padr( Lower( Alias() ), 22 ) +;
          'DESC "' + Left( Alias(), 1 ) + Substr( Lower( Alias() ), 2 ) + '"' )

    For nSub = 1 to nFields            // For each field.

        cName := Trim( Lower( aStructure[ nSub, DBS_NAME ] ) )
        cType := Trim( aStructure[        nSub, DBS_TYPE ] )
        nLen  := aStructure[              nSub, DBS_LEN  ]
        nDecs := aStructure[              nSub, DBS_DEC  ]

        cLine := '        COLUMN ' + Padr( cName , 15 )

        Do Case

            Case cType = "N"
                cLen := 'NUM  ( ' + Padl( Ltrim( Str( nLen, 3 ) ), 3, "0" ) +;
                        ', ' + Padl( Ltrim( Str( nDecs, 2 ) ), 2, "0" ) + ' )'

            Case cType = "C"
                cLen := 'CHAR ( ' + Padl( Ltrim( Str( nLen, 3 ) ), 3, "0" ) +;
                        ' )'

            Case cType = "M"
                cLen := 'VLF'

            Case cType = "D"
                cLen := 'DATE'

            Case cType = "L"
                cLen := 'LOG'

        EndCase

        cLine += Padr( cLen, 28 ) + 'DESC "' + Upper( Left( cName, 1 ) ) +;
                 Substr( cName, 2 ) + '"'

        Qout( cLine )

    Next

    Qout()
    Qout( '    PRIMARY KEY ' + Lower( Trim( aStructure[ 1, DBS_NAME ] ) ) )

Next

Qout()
Qout( 'END DATA DEFINITION MODULE' )
Qout()

Set Print Off
Set Printer To

Return

