/*
* TTS libray for Clipper 5.01
*   Brian Connelly
*/
#include <extend.h>


#include "tts_lib.h"	// return codes, etc.

//>+*************************************************************************
//>N*	TTSIsAvail()
//>Q*	will tell you whether or not TTS is available and enabled
//>T*
//>S* Syntax
//>T*	TTSIsAvail()	->	iReturn
//>T*
//>R* Returns
//>T*	iReturn :	    00	not available
//>T*			    01	available
//>T*			    253 disabled
//>T*
//>D* Description
//>T*	Simple clipper shell around TTSIsAvailable() call.
//>T*
//>W* Written by
//>T*	Brian Connelly
//>T*
//>L* Language
//>T*	    Assembler
//>T*	    C
//>T*
//>E* Examples
//>T*	    ? TTSIsAvail()		//RESULT: 0 {hopefully}
//>T*
//>O* See also
//>T*	TTSBegin()
//>T*	TTSEnd()
//>T*	TTSAbort()
//>T*	TTSStatus()
//>T*	TTSGetAppT()
//>T*	TTSSetAppT()
//>T*	TTSGetWksT()
//>T*	TTSSetWksT()
//>T*
//>-*************************************************************************

CLIPPER ttsisavail (void)
/* this function will tell you whether TTS is available and/or disabled
*/
{
    int rc = 0;

    _asm {
	mov ah, 0xc7
	mov al, 0x02
	int 0x21
	mov rc, al
	}

    _retni( rc );

return;
}

//>+*************************************************************************
//>N*	TTSBegin()
//>Q*	Begins an explicit transaction
//>T*
//>S* Syntax
//>T*	TTSBegin()	->	iReturn
//>T*
//>R* Returns
//>T*	iReturn :	    00	success
//>T*			    150 out of dynamic worksapce on server
//>T*			    255 explicit transaction already active
//>T*			    254 implicit transaction already active
//>T*
//>D* Description
//>T*	    Simple clipper shell around TTSBeginTransaction() call.
//>T*	Note: On return code of 255 the explicit transaction will continue
//>T*	normally. On a return code of 254 the implicit transaction will
//>T*	as an explicit transaction. On a return code of 150, you are in some
//>T*	serious trouble.
//>T*
//>W* Written by
//>T*	Brian Connelly
//>T*
//>L* Language
//>T*	    Assembler
//>T*	    C
//>T*
//>E* Examples
//>T*	    ? TTSBegin()		//RESULT: 0 {hopefully}
//>T*
//>O* See also
//>T*	TTSIsAvail()
//>T*	TTSEnd()
//>T*	TTSAbort()
//>T*	TTSStatus()
//>T*	TTSGetAppT()
//>T*	TTSSetAppT()
//>T*	TTSGetWksT()
//>T*	TTSSetWksT()
//>T*
//>-*************************************************************************

CLIPPER ttsbegin (void)
/* this functions notifies Netware to begin tts backups on all tts file
*   output, from this moment on.
*/
{
    int rc = 0;

    _asm {
	mov ah, 0xc7
	mov al, 0x00
	int 0x21
	mov rc, al
	}

    _retni( rc );

return;
}

//>+*************************************************************************
//>N*	TTSEnd()
//>Q*	Ends an explicit (or implicit) transaction
//>T*
//>S* Syntax
//>T*	TTSEnd( @<iTransNumber>)	->	iReturn
//>T*
//>A* Arguments
//>T*	<iTransNumber>	    : optional transaction reference number for
//>T*				call to TTSStatus()
//>T*
//>R* Returns
//>T*	iReturn :	    00	success
//>T*			    255 no explicit transaction active
//>T*			    254 transaction ended, records locked
//>T*			    253 tts is disabled
//>T*			    252 BAD PARAMETERS
//>T*
//>D* Description
//>T*	    Simple clipper shell around TTSEndTransaction() call.
//>T*	Note: On return code of 254 the transaction was aborted, but the
//>T*	records were left locked, this is only for implicit transactions.
//>T*
//>W* Written by
//>T*	Brian Connelly
//>T*
//>L* Language
//>T*	    Assembler
//>T*	    C
//>T*
//>E* Examples
//>T*	    Local iRef := 0
//>T*	    ? TTSEnd( @iRef)		//RESULT: 0 {hopefully}
//>T*
//>O* See also
//>T*	TTSIsAvail()
//>T*	TTSBegin()
//>T*	TTSAbort()
//>T*	TTSStatus()
//>T*	TTSGetAppT()
//>T*	TTSSetAppT()
//>T*	TTSGetWksT()
//>T*	TTSSetWksT()
//>T*
//>-*************************************************************************

CLIPPER ttsend (void)
/* this function notifies Netware to end the current transaction. It will
*   return a completion code as well as a transaction number, that can
*   be used to track when the transaction is actually written.
*/
{
    unsigned	ref = 0 , *ref_ptr = &ref;
    int rc;

    if ( PCOUNT == 1 )
	if ( !ISBYREF(1) || !ISNUM(1) ) {
	    _retni( 252 );
	    return;
	}

    _asm {
	mov ah, 0xc7
	mov al, 0x01
	int 0x21
	cmp al, 0
	jne NoRef
	mov ref_ptr[0], cx
	mov ref_ptr[2], dx
NoRef:	mov rc, al
	}

    if ( PCOUNT == 1)
	_stornl( (long) ref, 1);

    _retni( rc );

return;
}

//>+*************************************************************************
//>N*	TTSAbort()
//>Q*	Aborts all transactions.
//>T*
//>S* Syntax
//>T*	TTSAbort()	->	iReturn
//>T*
//>R* Returns
//>T*	iReturn :	    00	success
//>T*			    255 no explicit transaction active
//>T*			    254 transaction ends record locked
//>T*			    253 tts is disabled
//>T*
//>D* Description
//>T*	    Simple clipper shell around TTSAbortTransaction() call.
//>T*	Note: On return code of 254 the transaction was aborted, but the
//>T*	records were left locked, this is only for implicit transactions.
//>T*
//>W* Written by
//>T*	Brian Connelly
//>T*
//>L* Language
//>T*	    Assembler
//>T*	    C
//>T*
//>E* Examples
//>T*	    ? TTSAbort()		//RESULT: 0 {hopefully}
//>T*
//>O* See also
//>T*	TTSIsAvail()
//>T*	TTSEnd()
//>T*	TTSBegin()
//>T*	TTSStatus()
//>T*	TTSGetAppT()
//>T*	TTSSetAppT()
//>T*	TTSGetWksT()
//>T*	TTSSetWksT()
//>T*
//>-*************************************************************************

CLIPPER ttsabort (void)
/* this function aborts all current transactions, implicit or explicit
*/
{
    int rc = 0;

    _asm {
	mov ah, 0xc7
	mov al, 0x03
	int 0x21
	mov rc, al
	}

    _retni( rc );

return;
}

//>+*************************************************************************
//>N*	TTSStatus()
//>Q*	Get the status of an ended transaction
//>T*
//>S* Syntax
//>T*	TTSAbort( <iTransNumber>)	->	iReturn
//>T*
//>A* Arguments
//>T*	<iTransNumber>	    : transaction reference number from
//>T*				call to TTSEnd()
//>T*
//>R* Returns
//>T*	iReturn :	    00	success
//>T*			    255 transaction not yet written
//>T*			    252 bad parameters
//>T*
//>D* Description
//>T*	    Simple clipper shell around TTSTransactionStatus() call.
//>T*
//>W* Written by
//>T*	Brian Connelly
//>T*
//>L* Language
//>T*	    Assembler
//>T*	    C
//>T*
//>E* Examples
//>T*	    Local iRef := 0
//>T*	    ? TTSEnd( @iRef)
//>T*	    ? TTSStatus( iRef)		//RESULT:   0 {hopefully}
//>T*
//>O* See also
//>T*	TTSIsAvail()
//>T*	TTSBegin()
//>T*	TTSAbort()
//>T*	TTSEnd()
//>T*	TTSGetAppT()
//>T*	TTSSetAppT()
//>T*	TTSGetWksT()
//>T*	TTSSetWksT()
//>T*
//>-*************************************************************************

CLIPPER ttsstatus (void)
/* this function tells you whether or not the chosen transaction has been
*   written to disk yet.
*/
{
    unsigned  ref = 0 , *ref_ptr = &ref;
    int rc = 0;

    if ( PCOUNT != 1 || !ISNUM(1) ) {
	_retni( 252 );
	return;
	}

    ref = (unsigned) _parni( 1 );

    _asm {
	mov ah, 0xc7
	mov al, 0x04
	mov cx, ref_ptr[0]
	mov dx, ref_ptr[2]
	int 0x21
	mov rc, al
	}

    _retni( rc );

return;
}

//>+*************************************************************************
//>N*	TTSGetAppT()
//>Q*	Get the worstation thresholds for implicit transactions
//>T*
//>S* Syntax
//>T*	TTSGetAppT( @<iLogLocks>, @<iPhysLocks>)	->	iReturn
//>T*
//>A* Arguments
//>T*	    iLogLocks	    : Number of logical locks before implicit trans
//>T*				[0 - 255]
//>T*	    iPhysLocks	    : Number of physical locks before implicit trans
//>T*				[0 - 255]
//>T*
//>R* Returns
//>T*	iReturn :	    00	success
//>T*			    252 bad parameters
//>T*
//>D* Description
//>T*	    Simple clipper shell around TTSGetApplicationThresholds() call.
//>T*	Default thresholds are 0. A value of 255 disables implicit transactions
//>T*	of that type.
//>T*
//>W* Written by
//>T*	Brian Connelly
//>T*
//>L* Language
//>T*	    Assembler
//>T*	    C
//>T*
//>E* Examples
//>T*	    Local iLogicals, iPhysicals
//>T*	    ? TTSGetAppT( @iLogicals, @iPhysicals)	//RESULT:   0
//>T*
//>O* See also
//>T*	TTSIsAvail()
//>T*	TTSBegin()
//>T*	TTSAbort()
//>T*	TTSEnd()
//>T*	TTSStatus()
//>T*	TTSSetAppT()
//>T*	TTSGetWksT()
//>T*	TTSSetWksT()
//>T*
//>-*************************************************************************

CLIPPER ttsgetappt (void)
/* this call returns the physical and logical lock thresholds that will
*   trigger implicit transaction tracking. These thresholds last only the
*   duration of the application and supersede the workstation thresholds.
*/
{
    unsigned char plocks, llocks;
    int rc = 0;

    if ( PCOUNT != 2 || !ISNUM(1) || !ISNUM(2) || !ISBYREF(1) || !ISBYREF(2) ) {
	_retni( 252 );
	return;
	}

    _asm {
	mov ah, 0xc7
	mov al, 0x05
	int 0x21
	mov plocks, ch
	mov llocks, cl
	mov rc, al
	}

    _storni(1, plocks);
    _storni(2, llocks);
    _retni( rc);

return;
}

//>+*************************************************************************
//>N*	TTSSetAppT()
//>Q*	Set the worstation thresholds for implicit transactions
//>T*
//>S* Syntax
//>T*	TTSGetAppT( <iLogLocks>, <iPhysLocks>)	->	iReturn
//>T*
//>A* Arguments
//>T*	    iLogLocks	    : Number of logical locks before implicit trans
//>T*				[0 - 255]
//>T*	    iPhysLocks	    : Number of physical locks before implicit trans
//>T*				[0 - 255]
//>T*
//>R* Returns
//>T*	iReturn :	    00	success
//>T*			    252 bad parameters
//>T*
//>D* Description
//>T*	    Simple clipper shell around TTSSetApplicationThresholds() call.
//>T*	Default thresholds are 0. A value of 255 disables implicit transactions
//>T*	of that type.
//>T*
//>W* Written by
//>T*	Brian Connelly
//>T*
//>L* Language
//>T*	    Assembler
//>T*	    C
//>T*
//>E* Examples
//>T*	    Local iLogicals := 255, iPhysicals := 255
//>T*	    ? TTSSetAppT( iLogicals, iPhysicals)	//RESULT:   0
//>T*
//>O* See also
//>T*	TTSIsAvail()
//>T*	TTSBegin()
//>T*	TTSAbort()
//>T*	TTSEnd()
//>T*	TTSStatus()
//>T*	TTSGetAppT()
//>T*	TTSGetWksT()
//>T*	TTSSetWksT()
//>T*
//>-*************************************************************************

CLIPPER ttssetappt (void)
/* this call is used to set the physical and logical lock thresholds for
*   implicit transaction tracking. These thresholds last only for the
*   duration of the application and supersede the workstation thresholds.
*   Setting a threshold to 0xff disables implict transactions for that kind
*   of lock.
*/
{
    unsigned char plocks, llocks;
    int rc = 0;

    if ( PCOUNT != 2 || !ISNUM(1) || !ISNUM(2) ) {
	_retni( BAD_PARAMS );
	return;
	}

    _asm {
	mov ah, 0xc7
	mov al, 0x06
	mov ch, plocks
	mov cl, llocks
	int 0x21
	mov rc, al
	}

    _retni( rc);

return;
}

//>+*************************************************************************
//>N*	TTSGetWksT()
//>Q*	Get the worstation thresholds for implicit transactions
//>T*
//>S* Syntax
//>T*	TTSGetWksT( @<iLogLocks>, @<iPhysLocks>)	->	iReturn
//>T*
//>A* Arguments
//>T*	    iLogLocks	    : Number of logical locks before implicit trans
//>T*				[0 - 255]
//>T*	    iPhysLocks	    : Number of physical locks before implicit trans
//>T*				[0 - 255]
//>T*
//>R* Returns
//>T*	iReturn :	    00	success
//>T*			    252 bad parameters
//>T*
//>D* Description
//>T*	    Simple clipper shell around TTSGetWorkstationThresholds() call.
//>T*	Default thresholds are 0. A value of 255 disables implicit transactions
//>T*	of that type.
//>T*
//>W* Written by
//>T*	Brian Connelly
//>T*
//>L* Language
//>T*	    Assembler
//>T*	    C
//>T*
//>E* Examples
//>T*	    Local iLogicals, iPhysicals
//>T*	    ? TTSGetWksT( @iLogicals, @iPhysicals)	//RESULT:   0
//>T*
//>O* See also
//>T*	TTSIsAvail()
//>T*	TTSBegin()
//>T*	TTSAbort()
//>T*	TTSEnd()
//>T*	TTSStatus()
//>T*	TTSSetAppT()
//>T*	TTSGetAppT()
//>T*	TTSSetWksT()
//>T*
//>-*************************************************************************

CLIPPER ttsgetwkst (void)
/* this call returns the physical and logical lock thresholds that will
*   trigger implicit transaction tracking. These thresholds last until reset.
*   These values are used as the default for applications that don't set
*   their own thresholds.
*/
{
    unsigned char plocks, llocks;
    int rc = 0;

    if ( PCOUNT != 2 || !ISNUM(1) || !ISNUM(2) || !ISBYREF(1) || !ISBYREF(2) ) {
	_retni( BAD_PARAMS );
	return;
	}

    _asm {
	mov ah, 0xc7
	mov al, 0x07
	int 0x21
	mov plocks, ch
	mov llocks, cl
	mov rc, al
	}

    _storni(1, plocks);
    _storni(2, llocks);

    _retni( rc);

return;
}

//>+*************************************************************************
//>N*	TTSSetWksT()
//>Q*	Set the worstation thresholds for implicit transactions
//>T*
//>S* Syntax
//>T*	TTSSetWksT( <iLogLocks>, <iPhysLocks>)	->	iReturn
//>T*
//>A* Arguments
//>T*	    iLogLocks	    : Number of logical locks before implicit trans
//>T*				[0 - 255]
//>T*	    iPhysLocks	    : Number of physical locks before implicit trans
//>T*				[0 - 255]
//>T*
//>R* Returns
//>T*	iReturn :	    00	success
//>T*			    252 bad parameters
//>T*
//>D* Description
//>T*	    Simple clipper shell around TTSSetWorkstationThresholds() call.
//>T*	Default thresholds are 0. A value of 255 disables implicit transactions
//>T*	of that type.
//>T*
//>W* Written by
//>T*	Brian Connelly
//>T*
//>L* Language
//>T*	    Assembler
//>T*	    C
//>T*
//>E* Examples
//>T*	    Local iLogicals := 255, iPhysicals := 255
//>T*	    ? TTSSetWksT( iLogicals, iPhysicals)	//RESULT:   0
//>T*
//>O* See also
//>T*	TTSIsAvail()
//>T*	TTSBegin()
//>T*	TTSAbort()
//>T*	TTSEnd()
//>T*	TTSStatus()
//>T*	TTSGetAppT()
//>T*	TTSGetWksT()
//>T*	TTSSetAppT()
//>T*
//>-*************************************************************************

CLIPPER ttssetwkst (void)
/* this call sets the physical and logical lock thresholds that will
*   trigger implicit transaction tracking. These thresholds last until reset.
*   These values are used as the default for applications that don't set
*   their own thresholds.
*   Setting a threshold to 0xff disables implict transactions for that kind
*   of lock.
*/
{
    unsigned char plocks, llocks;
    int rc = 0;

    if ( PCOUNT != 2 || !ISNUM(1) || !ISNUM(2) ) {
	_retni( 252 );
	return;
	}

    _asm {
	mov ah, 0xc7
	mov al, 0x08
	mov ch, plocks
	mov cl, llocks
	int 0x21
	mov rc, al
	}

    _retni( rc);

return;
}
