*(s16.66H
*Ŀ
* Little Crummy Black Book Program - Uses BTRIEVE RASQL Clipper Library      
* Purpose: Testing File Opening Modes for BTrieve and Transaction Tracking   
*  Author: Stephen Genusa, HazWaste Industries, Inc.                         
*          08/04/93 - Initial coding - 4 hours                               
*                                                                            
*                                                                            
*                                                                            
*

#define K_ENTER 13
#define K_ESC 27
#define K_UP 5
#define K_DOWN 24
#define K_RIGHT 4
#define K_LEFT 19
#define K_BKSP 8
#define K_PGUP 18
#define K_PGDN 3
#define K_HOME 1
#define K_END 6
#define K_PLUS 43
#define K_MINUS 45

#define HICOLOR "B/W,B/W,N"
#define LOCOLOR "+W/B,B/W,N"
#define TAGCOLOR "+GR/B,B/W,N"
#define MNUCOLOR "+GR/N,N/W,N"
#define ERRCOLOR "+W/R,R/W,N"

Parameters sFileMode

* environment
set scoreboard off
set confirm on
set exact off
set wrap on

* Open Files
* Open database TTFL
*
select 0

Cls
SET COLOR TO +BG/B
@ 0,0 say "       Steve's Transaction Tracking/File Mode Test Program - Version 1.0       "

PHONE=space(14)
NAME=space(30)
CurFileMode = -1

If sFileMode <> NIL
  CurFileMode = Val(sFileMode)-1
endif

Do FileMode

Do StatMsg with "Your Wish is my Command..."
TransTracking = .f.
Set Color to MnuColor
@ 3, 25 Say "Transaction Tracking is OFF"

private MENUOPT[11],MENUMSG[11],MCHOICE
MENUOPT[1]="Next"
MENUOPT[2]="Previous"
MENUOPT[3]="Add"
MENUOPT[4]="Edit"
MENUOPT[5]="Delete"
MENUOPT[6]="File-Mode"
MENUOPT[7]="Post"
MENUOPT[8]="Lock"
MENUOPT[9]="Unlock"
MENUOPT[10]="TransTra"
MENUOPT[11]="Quit"
MENUMSG[1]="Skip to the next record"
MENUMSG[2]="Move backwards one record"
MENUMSG[3]="Enter a new record"
MENUMSG[4]="Edit an existing record"
MENUMSG[5]="Delete an existing record"
MENUMSG[6]="Change File Open Mode"
MENUMSG[7]="Post Transactions to Base File"
MENUMSG[8]="Lock Current Record"
MENUMSG[9]="Unlock All Records"
MENUMSG[10]="Toggle Transaction Tracking"
MENUMSG[11]="Exit this program"
MCHOICE=0
* display fixed text
do disprec

do while .t.
  do HORZMNU
  do case
    case MCHOICE =1
      do nextrec
    case MCHOICE =2
      do prevrec
    case MCHOICE =3
      do addrec
    case MCHOICE =4
      do editrec
    case MCHOICE =5
      do delrec
    case MCHOICE =6
      do filemode
    case MCHOICE =7
      do postrec
      do disprec
    case MCHOICE =8
      do lockrec
    case MCHOICE =9
      do unlockrecs
    case MCHOICE =10
      do transtrack
    case MCHOICE =11
      do quitstuff
      n_xlogout()
      return
  endcase
enddo

**********************************
* nextrec: go to next record
**********************************
PROC nextrec
n_xskip()
IF n_xeof()
  n_xgotobot()
  do statmsg with "End of file!"
ELSE
  do statmsg with ""
  do disprec
ENDIF
RETURN


**********************************
* prevrec: go to previous record
**********************************
PROC prevrec
n_xskip(-1)
IF n_xbof()
  n_xgototop()
  do statmsg with "Beginning of file!"
ELSE
  do statmsg with ""
  do disprec
ENDIF
RETURN


****************************************************************************
* File Open Mode
****************************************************************************
PROC FileMode
  CurFileMode = CurFileMode + 1
  If CurFileMode > 4
    CurFileMode = 0
  endif
  do case
    Case CurFileMode = 0
      OpenFMode = " Normal        - 0"
    Case CurFileMode = 1
      OpenFMode = " Accelerated   - 1"
    Case CurFileMode = 2
      OpenFMode = " Read Only     - 2"
    Case CurFileMode = 3
      OpenFMode = " Write Verify  - 3"
    Case CurFileMode = 4
      OpenFMode = " Exclusive R/W - 4"
  end case
  Set Color to MnuColor
  @ 3,0 Say OpenFMode
  Do StatMsg with ""
  n_xclose()
  if n_xerror () != 0
    * Ignore it
  endif
  n_xlogin()
  n_xopenmode (CurFileMode)
  n_xuse ("TTFL.DAT",;
        "NAME                C    30.0  ;"+;
        "PHONE               C    14.0  ;")

  if n_xerror () != 0
    ? "Error opening TTFL datafile"
    return
  endif
  do disprec
RETURN



********************************
* editrec: edit current record
********************************
PROC editrec

*** create memvar duplicates for all fields

*** ...and initialize 'em
M->NAME = NAME
M->PHONE = PHONE

do statmsg with "Edit record. ^W to save; Esc to abandon"

*** get input fields into memvar duplicates
@   8,  20 get M->NAME
@   9,  20 get M->PHONE
READ

do statmsg with ""

IF lastkey() = 27	    && user escaped out of READ
  RETURN
ENDIF

RecNo = n_xrecno()
n_xgoto(RecNo)
n_xreplace ("NAME", M->NAME, "PHONE", M->PHONE)
n_xupdate()
do disprec
RETURN

********************************
* toggle trans tracking
********************************
PROC transtrack
  Set Color to MnuColor
  if TransTracking = .f.
    TransTracking = .t.
    n_xtranon()
    @ 3, 25 Say "Transaction Tracking is ON "
  else
    TransTracking = .f.
    n_xtranoff()
    @ 3, 25 Say "Transaction Tracking is OFF"
  end if
  do disprec
return

********************************
* lock record
********************************
PROC lockrec
  n_xrlock()
return

********************************
* unlock all records
********************************
PROC unlockrecs
  n_xunlock()
return

********************************
* addrec: append new record
********************************
PROC addrec

*** create memvar duplicates for all fields
PRIVATE NAME, PHONE

*** ...and initialize 'em
M->NAME = SPACE(30)
M->PHONE = SPACE(14)

do statmsg with "Enter new record. ^W to save; Esc to abandon"

*** get input fields into memvar duplicates
@   8,  20 get M->NAME
@   9,  20 get M->PHONE
READ

do statmsg with ""

IF lastkey() = 27	    && user escaped out of READ
  RETURN
ENDIF

* append into DBF fields
n_xreplace ("NAME", M->NAME, "PHONE", M->PHONE)
n_xinsert()

do disprec
RETURN



**********************************************
* delrec: delete record. If deleted, recall
**********************************************
PROC delrec
RecNo = n_xrecno()
n_xgoto(RecNo)
n_xdelete()
n_xskip(-1)
do statmsg with ""
do disprec
RETURN


*********************************
* quitstuff: various quit things
*********************************
PROC quitstuff
CLOSE DATABASES
set color to LOCOLOR
CLEAR
RETURN



************************************************
* statmsg: displays passed message on line 23
************************************************
PROC statmsg
PARAM s
Set Color to MnuColor
@ 4,0 SAY " "+s+space(80-len(s))
RETURN



*********************************************************************
* disprec: displays current record, along with recno() and deleted()
*********************************************************************
PROC disprec

M->NAME = n_xfetch ("NAME")
M->PHONE = n_xfetch ("PHONE")
SET COLOR TO +BG/B
@   5,   0,  22,  79 box "͸Գ"
SET COLOR TO +W/B
@   6,  1, 21, 78 box "         "
@ 8, 14 say "Name:"
@ 9, 13 say "Phone:"
set color to HICOLOR
  @ 8, 20 say M->NAME
  @ 9, 20 say M->PHONE
set color to LOCOLOR
*say_all_variables_in_box(MAINBOX)
*get_all_variables_in_box(MAINBOX)
*CLEAR GETS
Set Color to MnuColor
@ 3, 60 say "Records:"
@ 3, 69 say alltrim(str(n_xlastrec()))
RETURN


****************************************
proc HORZMNU
****************************************
* proc to display a HORIZONTAL MENU
set message to 24
set key 32 to RGTARROW
do while .t.
  set color to MNUCOLOR
  @ 23,0
  @ 24,0
  I = 0
  MAXOPT=len(MENUOPT)
  MNU_LINE = 23
  MNU_CLMN = 0
  OPTN_CODE = 1
  do while OPTN_CODE <= MAXOPT
    @ MNU_LINE,MNU_CLMN prompt MENUOPT[OPTN_CODE] message MENUMSG[OPTN_CODE]
    MNU_CLMN = MNU_CLMN + len(MENUOPT[OPTN_CODE]) + 2
    OPTN_CODE = OPTN_CODE + 1
  enddo
  menu to MCHOICE
  if MCHOICE = 0
    loop
  else
    exit
  endif
enddo
set color to LOCOLOR
@ 23,0
@ 24,0
set key 32 to
return


****************************************
proc RGTARROW
****************************************
keyboard chr(4)
return


****************************************
proc PostRec
****************************************
  NewName = Space(30)
  NewPhone = Space(14)
  n_xselect(0)
  n_xuse ("TTFL2.DAT",;
        "NAME2               C    30.0  ;"+;
        "PHONE2              C    14.0  ;")

  if n_xerror () != 0
    @ 1, 1 Say "Error opening TTFL2 Posting datafile"
    return
  endif
  ************************
  * turn transaction tracking on
  ************************
  n_xtranon()
  do while ! n_xeof()
    NewName = n_xfetch  ("NAME2")
    NewPhone = n_xfetch ("PHONE2")
    n_xselect("TTFL")
    n_xreplace ("NAME", NewName, "PHONE", NewPhone)
    n_xinsert()
    n_xselect("TTFL2")
    n_xskip()
  enddo
  n_xselect("TTFL2")
  ************************
  * turn transaction tracking off - ALL Done!
  ************************
  n_xtranoff()
  n_xclose()
  n_xselect("TTFL")
return


****************************************
*** MA_hidsp: hilites prompt line at currow
****************************************
PROC MA_hidsp
set color to HICOLOR
return

****************************************
*** MA_lodsp: lolites prompt line at currow
****************************************
PROC MA_lodsp
if TAGREC
  set color to TAGCOLOR
else
  set color to LOCOLOR
endif
  @ 8, 20 say NAME
  @ 9, 20 say PHONE
set color to LOCOLOR
return


****************************************
*** MA_disp : displays a MAINBROW full of records.
****************************************
*** If called WITH .t., currow and recno() will be set to the first
*** record in the MAINBROW.
*** If called WITH .f., currow and recno() will be set to the last
*** record in the MAINBROW.
***
PROC MA_disp
PARAM set_to_top

private THISROW, TOPREC

set color to LOCOLOR
@ SCRLTOP, SCRLLEFT clear to SCRLBOT, SCRLRIGHT
TOPREC = n_xrecno()
THISROW = SCRLTOP
do while .not. eof() .and. THISROW <= SCRLBOT
if TAGREC
  set color to TAGCOLOR
endif
  n_xskip()
  THISROW = THISROW + 1
  set color to LOCOLOR
enddo

if SET_TO_TOP
  n_xgoto(TOPREC)
  CURROW = SCRLTOP
else
  n_xskip(-1)
  CURROW = THISROW -1
endif
CURREC = n_xrecno()

return


****************************************
proc CUSTPRGS
****************************************
return

