/*********
*
* STRIP.C

*   Author : Jean-Pierre van Melis
* Compiled : with Microsoft C 5.1
*   Object : can only be used in conjunction with Clipper summer '87

*  Syntax: STRIP( <expC> )
*  Return: All non-alphanumeric characters are removed, and spaces
*          are added to keep the initial length (for indexing purposes).
*          and all characters are made uppercase to gain speed.
*
*          INPUT                  RETURN
*          ---------------------- ----------------------------------
*           "v/d Broek B.V.  "    "VDBROEKBV       "
*
*
*        mNAAM = "v/d Broek B.V.    "
*        USE namen
*        INDEX ON STRIP(naam) TO naam
*        SEEK TRIM(STRIP(mNAAM))
*        IF FOUND()
*           ? naam
*        ENDIF
*
*
*     output: "v/d Broek B.V.    "
*********/

#include "jplib.h"

CLIPPER strip()

{

   byte *par;                                      /* pointer to input */
   byte *retstr;                                   /* pointer to output */

   quant leng;                                     /* leng of string */
   quant n1;                                       /* offset input */
   quant n2;                                       /* offset output */

   Boolean error;

   error = TRUE;

   if(PCOUNT == 1 && ISCHAR(1))
   {
      par    = _parc(1);                           /* receive pointer from clipper */
      leng   = (quant) _parclen(1);                /* receive leng from clipper */

      retstr = _exmgrab(leng+1);                   /* Allocate memory */

      if(retstr)                                   /* Enough memory available */
      {
         error = FALSE;                            /* No errors */
         n2    = 0;                                /* point to first character */

         for(n1 = 0; n1 < leng; n1++)              /* parse input till end of input*/
         {
            if(islower(par[n1]))                   /* character is lowercase */
              retstr[n2++] = (par[n1] + ('A'-'a'));/* convert to uppercase */
            else if(isdigit(par[n1]) || isupper(par[n1])) /* is alphanumeric */
              retstr[n2++] = par[n1];              /* copy from input */
         }
         while(n2 < leng)                          /* fill rest with spaces */
            retstr[n2++] = SPACEC;

         retstr[n2] = NULLC;                       /* terminate with null */
      }
   }
   if(error)
      _retc(NULLS);                                /* return null string */
   else
   {
      _retclen(retstr, leng);                      /* return string with length */
      _exmback(retstr, leng+1);                    /* deallocate memory */
   }
   return;
}
