/******************************
* Compiled : with Microsoft C 5.1
* Object   : can only be used in conjunction with Clipper summer '87
* Syntax   : SOUNDEX( <xpC> )
* Parameter: string of any length without embedded null bytes
*            and terminated with a null byte.
* Return   : A string of 5 characters long containing the soundex code
* Author   : Jean-Pierre van Melis, Helmond, The Netherlands
* Date     : June 1, 1988
* Note..   : There is 1 difference with the SOUNDEX function from clipper.
*            the trailing characters are SPACEs instead of zeros.
*
*            this routine is 3 times faster than the internal clipper function.
*            and it always returns a string of 5 characters (so you can
*            use code like:

                              INDEX ON SOUNDEX(name) TO SND_name
                              SEEK TRIM(SOUNDEX(mNAME))
*
*            A E H I O U W Y                group  0
*            B F P V                        group  1
*            C G J K Q S X Z              group  2
*            D T                            group  3
*            L                              group  4
*            M N                            group  5
*            R                              group  6
*            (including lowercase)
*
*            all other characters are discarded.
*
*     CLIPPER's  routine                My routine
*     -------------------               ------------------
*  SOUNDEX("Nantucket") == "N532"  <==> SOUNDEX("Nantucket") == "N5323"
*  SOUNDEX("Mantucket") == "M532"  <==> SOUNDEX("Mantucket") == "M5323"
*  SOUNDEX("extend")    == "E235"  <==> SOUNDEX("extend")    == "E2353"
*
*  SOUNDEX("         ") == ""      <==> SOUNDEX("         ") == "     "
*  SOUNDEX("X")         == "X000"  <==> SOUNDEX("X")         == "X    " 
*
*  Execution time:
*                  0.0084 seconds  <==> 0.0033 seconds (using Turbo C 1.0)
*  Size:  
*   Source :          3184 bytes   <==> 1884 bytes (both without comments)
*   Object :          1234 bytes   <==> 795  bytes (both using turbo C)
*                                  <==> 752  bytes (using MSC 5.1)
*
*  When comparing speed, I used the routine out of extend.lib.
*  When comparing size, I used the routine out of examplec.c and compiled
*  it with Turbo C.
*  Results are probably better when using Microsoft C 5.x 
*
*  If you replace the line ' #define COMPATIBLE FALSE ' with
*  ' #define COMPATIBLE TRUE ', and recompile it with Microsoft C 5.x
*  the soundex routine is almost the same as the internal routine
*  (only faster, and always returning a valid soundex code)
*
***********/
#include "jplib.h"

#define COMPATIBLE FALSE

#if (COMPATIBLE)
   #define INIT      '0'
   static byte result[5] = {INIT,INIT,INIT,INIT,'\0'};
#else
   #define INIT      ' '
   static byte result[6] = {INIT,INIT,INIT,INIT,INIT,'\0'};
#endif


/*                A   B   C   D   E   F   G   H   I   J   K   L   M  */

#define ALPH1    ' ','1','2','3',' ','1','2',' ',' ','2','2','4','5'
#define ALPH2    '5',' ','1','2','6','2','3',' ','1',' ','2',' ','2'

/*                N   O   P   Q   R   S   T   U   V   W   X   Y   Z  */

#define SPACE    ' '
#define SPACE5   ' ',' ',' ',' ',' '

#define SPACE10  SPACE5,SPACE5
#define SPACE20  SPACE10,SPACE10
#define SPACE40  SPACE20,SPACE20
#define SPACE65  SPACE40,SPACE20,SPACE5
#define SPACE120 SPACE40,SPACE40,SPACE40


static byte code_string[256]= { SPACE65,
                                ALPH1,          /* A...M  */
                                ALPH2,          /* N...Z  */
                                SPACE5,SPACE,   /* [\]^_` */
                                ALPH1,          /* a...m  */
                                ALPH2,          /* n...z  */
                                SPACE5,
#if (COMPATIBLE)
                                SPACE,
#else
                                '2',            /*       */
#endif
                                SPACE5,SPACE,
#if (COMPATIBLE)
                                SPACE,
#else
                                '2',            /*       */
#endif
                                SPACE120
                               };

CLIPPER SOUNDEX()

{
 byte     *in_ptr;
 byte     *res_ptr;
 byte     code;
 byte     lastcode;

 in_ptr   = _parc(1);              /* receive string from clipper */

 result[0]= INIT;                  /* initialize result with INIT. */
 result[1]= INIT;                  /* because the result gets overwritten */
 result[2]= INIT;                  /* each time the function is called. */
 result[3]= INIT;                  /* only the null byte stays the same. */
#if ! (COMPATIBLE)
 result[4]= INIT;
#endif
 res_ptr  = result;                /* res_ptr is pointer to result */

 if ISCHAR(1)                       /* parameter is a character string */
 {
  if(*in_ptr)  			                /* string may be empty */	
  {
    lastcode   = SPACE;             /* initialize lastcode */
    *res_ptr++ = toupper(*in_ptr);  /* convert to uppercase */
    *in_ptr++;                      /* increment input pointer */
    while((*res_ptr) && (*in_ptr))  /* while not end of string */
    {
      code = code_string[*in_ptr++];/* get code out of code_string */
      if (code != SPACE)            /* is it a valid code */
      {
        if (code != lastcode)       /* is it different */
        {
          lastcode    = code;       /* save last used code */
          *res_ptr++  = code;       /* put code into result */
        }
      }
    }
  }
 }
 _retc(result);                      /* return result to clipper */
 return;                             /* return to clipper */
}
