/*********
*
* PAD.C

* Author   : Jean-Pierre van Melis, Helmond, The Netherlands
* Compiled : with Microsoft C 5.1
*   Object : can only be used in conjunction with Clipper summer '87

*  Syntax: PAD( <expC>, <expN> )
*  Return: expC with a length of expN, padded with spaces
*********/

#include "jplib.h"

CLIPPER pad()

{

   byte *par;                                   /* pointer to input */
   byte *ret;                                   /* pointer to output */

   quant par_leng;                              /* length input */
   quant ret_leng;                              /* length output */
   quant i;                                     /* offset input */

   Boolean error =  TRUE;

   if(PCOUNT == 2 && ISCHAR(1) && ISNUM(2))
   {
      par      = _parc(1);                      /* receive pointer from clipper */
      ret_leng = (quant) _parnd(2);             /* receive length from clipper */

      par_leng = (quant) _parclen(1);           /* get length of string */
      par_leng = min(par_leng,ret_leng);

      ret      = _exmgrab(ret_leng+1);          /* Allocate memory */

      if(ret)                                   /* Enough memory available? */
      {
         error = FALSE;                         /* No errors */

         for(i = 0; i < par_leng; i++)          /* copy from input */
            ret[i] = par[i];
         while(i < ret_leng)                    /* fill rest with spaces */
            ret[i++] = SPACEC;

         ret[i] = NULLC;                        /* terminate with null */
      }
   }
   if(error)
      _retc(NULLS);                             /* return null string */
   else
   {
      _retclen(ret, ret_leng);                  /* return string with length */
      _exmback(ret, ret_leng+1);                /* deallocate memory */
   }
   return;
}
