/* Author : Jean-Pierre van Melis, Helmond, The Netherlands
*/

#include "jplib.h"
/* Syntax : SUM_ARR( <expA> [ , <expN>] )
   Return : Total of all (or <expN> first ) numerical elements of
            Array <expA>

*/

CLIPPER sum_arr()
{
   if (ISARRAY(1))
   {
      quant i;
      quant alength;
      double answer = 0.00;

      if (ISNUM(2))
         alength = (quant) _parnd(2);
      else
         alength = ALENGTH(1);

      for (i=1; i <= alength; i++)
      {
         if (_parinfa(1, i) == NUMERIC)
            answer += _parnd(1, i);
      }
      _retnd(answer);
   }
   else
      _ret();

   return;
}

/* Syntax : AVG_ARR( <expA> [ , <expN>] )
   Return : Average of all (or <expN> first ) numerical elements of
            Array <expA>

*/
CLIPPER avg_arr()
{
   if (PCOUNT == 1 && ISARRAY(1))
   {
      quant alength;
      quant i;
      quant j = 0;
      double answer = 0.00;

      if (ISNUM(2))
         alength = (quant) _parnd(2);
      else
         alength = ALENGTH(1);

      for (i=1; i <= alength; i++)
      {
         if (_parinfa(1, i) == NUMERIC)
         {
            answer += _parnd(1, i);
            j++;
         }
      }
      if(j)
         _retnd(answer/j);
      else
         _retnd(0);

   }
   else
      _ret();

   return;
}
