UNIT TPDBScrn;
{August 22, 1989}
{Screen handling unit}

{$L Flash}
{$L Attr}

INTERFACE

CONST
	{Color constants - defined to take advantage of Turbo Pascal's
 constant folding capabilities.  See documentation.}


  Black        = $00;       DarkGray     = $08;
  Blue         = $01;       LightBlue    = $09;
  Green        = $02;       LightGreen   = $0A;
  Cyan         = $03;       LighBCyan    = $0B;
  Red          = $04;       LightRed     = $0C;
  Magenta      = $05;       LightMagenta = $0D;
  Brown        = $06;       Yellow       = $0E;
  LightGray    = $07;       White        = $0F;
  Blink        = $80;

  BlackBG      = $00;
  BlueBG       = $10;
  GreenBG      = $20;
  CyanBG       = $30;
  RedBG        = $40;
  MagentaBG    = $50;
  BrownBG      = $60;
  LightGrayBG  = $70;

Type
	ScreenType = Array[0..3999] of Byte;
	ScrPtr = ^ScreenType;
   DisplayType = (Monochrome, CGA, EGA, MCGA, VGA);

VAR
	VideoBase : WORD;
	VideoWait : BOOLEAN;



FUNCTION SaveScreen : ScrPtr;

PROCEDURE RestoreScreen(VAR SavedScreen : ScrPtr);

PROCEDURE Flash(Row,Col, Attr:byte; Str : String);

PROCEDURE CursorOn;

PROCEDURE CursorOff;

PROCEDURE BlockCursor;

PROCEDURE ChAttr(Number : Word; Row, Col, Attr : Word);

PROCEDURE ChAllAttr(Row,Col,Rows,Cols,Attr : Word);

PROCEDURE FlashC(Row,Attr:Byte;Str : String);


IMPLEMENTATION

VAR
	Screen : ScreenType absolute $B800 : 0000;
	MonoScreen : ScreenType absolute $B000 : 0000;
	Mono : BOOLEAN;

{$F+}

PROCEDURE Flash(Row,Col, Attr:byte; Str : String);EXTERNAL;

	FUNCTION CurrVidDisplay: DisplayType;EXTERNAL;

	FUNCTION CurrentVideoMode: Byte; EXTERNAL;

	PROCEDURE CursorOn;EXTERNAL;

	PROCEDURE CursorOff;EXTERNAL;

	PROCEDURE BlockCursor;EXTERNAL;

PROCEDURE ChAttr(Number : Word; Row, Col, Attr : Word);EXTERNAL;



{$F-}

PROCEDURE ChAllAttr(Row,Col,Rows,Cols,Attr : Word);
VAR
	TRow : BYTE;
BEGIN
	FOR TRow := Row TO Rows DO
		ChAttr(Cols,TRow,Col,Attr);
END;

PROCEDURE FlashC(Row,Attr:Byte;Str : String);
BEGIN
     Flash(Row,40 - Length(Str) div 2,Attr,Str);
END;


FUNCTION SaveScreen : ScrPtr;
VAR
	TempPtr : ScrPtr;
BEGIN
	NEW(TempPtr);
	IF Mono THEN
		Move(MonoScreen,TempPtr^,4000)
	ELSE
		Move(Screen,TempPtr^,4000);
	SaveScreen := TempPtr;
END;

PROCEDURE RestoreScreen(VAR SavedScreen : ScrPtr);
BEGIN
	IF Mono THEN
		Move(SavedScreen^,MonoScreen,4000)
	ELSE
		Move(SavedScreen^,Screen,4000);
	DISPOSE(SavedScreen);
END;


BEGIN
	IF CurrentVideoMode = 7 THEN
	BEGIN
		VideoBase := $B000;
		Mono := TRUE;
	END
	ELSE
	BEGIN
		VideoBase := $B800;
		Mono := FALSE;
	END;
	VideoWait := (CurrVidDisplay = CGA);
END.