Unit TPDBDate;

                       (*****************************)
                       (*        TPDBDATE.tpu       *)
                       (*     TPDB Version 2.2      *)
                       (*        March 2,1989       *)
                       (*   Time and Date Routines  *)
                       (*       for TPDB.tpu        *)
                       (*  Public Domain Source by  *)
                       (*        Brian Corll        *)
                       (*****************************)
                       (*   Credits: John Wood and  *)
                       (*       Scott Bussinger     *)
                       (*****************************)

INTERFACE

Uses Dos;

Type
    DayStr   = String[9];
    DateType = word;
    DateStr  = String[8];
    TimeStr  = String[13];
    Str9     = String[9];

Function CalcDate(InDate:DateStr;Days,Months,Years: integer): DateStr;
(* Add or subtract days,months, or years from two dates. *)

Function CDOW(InDate : DateStr): DayStr;
(* Returns character day of week - i.e. 'Monday','Tuesday',etc. *)

Function CMonth(InDate : DateStr) : Str9;
(* Returns character month - i.e. 'March' *)

Function CompDates(Date1,Date2 : DateStr):Word;
(* Compares two dates and calculates the number of days between them. *)

Function CTOD(InDate: DateStr) : DateType;
(* Converts a .DBF compatible date field to a word date type. *)

Function DTOC(Julian: DateType) : DateStr;
(* Converts a word date type to a string compatible with .DBF date fields. *)


Function Mon(InDate : DateStr) : Byte;
(* Returns numeric value for the month in a date. *)

Function TimeNow : TimeStr;
(* Returns current time in formatted string. *)

Function Today : DateStr;
(* Returns current date in .DBF date field compatible format. *)

Function ValidDate(InDate : DateStr): boolean;
(* Checks whether a date is valid. *)

Function FormDate(InDate:DateStr) : String;
(* Formats a date as 'MM/DD/YY' *)




IMPLEMENTATION

Const
     Months : Array[1..12] of Str9 = ('January  ','February ','March    ',
          'April    ','May      ','June     ','July     ',
         'August   ','September','October  ','November ','December ');

Var
   Temp,Month,Day,Year,ErrCode : Integer;
   MM,DD : String[2];
   YY : String[4];


Function CDOW(InDate : DateStr) : DayStr;
(* Returns the name of the day of the week represented by
   a date. *)

Var
   DayOfWeek,DOW        : Integer;

begin
     YY := Copy(InDate,1,4); MM := Copy(InDate,5,2); DD := Copy(InDate,7,2);
     Val(MM,Month,ErrCode); Val(DD,Day,ErrCode); Val(YY,Year,ErrCode);
     If month<=2 then
        begin
        month := month + 12;
        year := year -1;
        end;

     DayOfWeek := (Day+month*2+(month+1)*6 div 10 +year + year div 4 - year
            div 100 + year div 400 + 2) mod 7;

     If DayOfWeek = 0 then DOW := 7
        else DOW := DayOfWeek;

     Case DOW of
          1 : CDOW := 'Sunday';
          2 : CDOW := 'Monday';
          3 : CDOW := 'Tuesday';
          4 : CDOW := 'Wednesday';
          5 : CDOW := 'Thursday';
          6 : CDOW := 'Friday';
          7 : CDOW := 'Saturday';
     end;
end;

Function CTOD(InDate: DateStr) : DateType;
(* Convert from a date string to a word date type. *)
Var
   Julian : DateType;

begin
     YY := Copy(InDate,1,4);
     MM := Copy(InDate,5,2);
     DD := Copy(InDate,7,2);

     Val(YY,Year,ErrCode);
     Val(MM,Month,ErrCode);
     Val(DD,Day,ErrCode);

     If (Year=1900) and (Month<3) then
     if Month = 1 then
      Julian := pred(Day)
     else
      Julian := Day + 30
   else
    begin
    if Month > 2
     then
      dec(Month,3)
     else
      begin
      inc(Month,9);
      dec(Year)
      end;
    dec(Year,1900);
    Julian := (1461*longint(Year) div 4) + ((153*Month+2) div 5) + Day + 58
    end;
    CTOD := Julian;
  end;

Function DTOC(Julian: DateType) : DateStr;
(* Convert from a word date type to a date string. *)
Var
   LongTemp: longint;

begin
  if Julian <= 58
   then
    begin
    Year := 1900;
    if Julian <= 30
     then
      begin
      Month := 1;
      Day := succ(Julian)
      end
     else
      begin
      Month := 2;
      Day := Julian - 30
      end
    end
   else
    begin
    LongTemp := 4*longint(Julian) - 233;
    Year := LongTemp div 1461;    Temp := LongTemp mod 1461 div 4 * 5 + 2;
    Month := Temp div 153;
    Day := Temp mod 153 div 5 + 1;
    inc(Year,1900);
    if Month < 10
     then
      inc(Month,3)
     else
      begin
      dec(Month,9);
      inc(Year)
      end
    end;
    Str(Month : 2,MM);
    Str(Day : 2,DD);
    Str(Year : 4,YY);
    If Month<10 then MM := '0'+Copy(MM,2,1);
    If Day<10 then DD := '0'+Copy(DD,2,1);;
    DTOC := YY+MM+DD;
  end;

Function ValidDate(InDate : DateStr): boolean;
(* Check whether a date field contains a valid date. *)
begin
     YY := Copy(InDate,1,4); MM := Copy(InDate,5,2); DD := Copy(InDate,7,2);
     Val(DD,Day,ErrCode); Val(MM,Month,ErrCode); Val(YY,Year,ErrCode);
     If (Day=0) and (Year-1900=0) and(Month=0) then
     begin
          ValidDate := True;
          Exit;
     end;
     If (Day<1) or (Year<1900) or (Year>2078) then
     ValidDate := false
     else
     Case Month of
      1,3,5,7,8,10,12 : ValidDate := Day <= 31;
      4,6,9,11        : ValidDate := Day <= 30;
      2: ValidDate    := Day <= 28 + ord((Year mod 4)=0)*ord(Year<>1900)
      else ValidDate  := false
      end
  end;

Function CalcDate(InDate:DateStr;Days,Months,Years: integer): DateStr;
(* Add or subtract days, months , and years from a specific date string,
 as stored in a .DBF record. *)
Var
   Julian : DateType;
   TempDate   : DateStr;
  begin
  YY := Copy(InDate,1,4);
  MM := Copy(InDate,5,2);
  DD := Copy(InDate,7,2);
  Val(MM,Month,ErrCode);
  Val(DD,Day,errCode);
  Val(YY,Year,ErrCode);
  Month := Month + Months - 1;
  Year := Year + Years + (Month div 12) - ord(Month<0);
  Month := (Month + 12000) mod 12 + 1;
  Str(Month : 2,MM);
  Str(Day : 2,DD);
  Str(Year : 4,YY);
  If Month<10 then MM := '0'+Copy(MM,2,1);
  If Day<10 then DD := '0'+Copy(DD,2,1);
  TempDate := YY+MM+DD;
  Julian := CTOD(TempDate)+Days;
  CalcDate := DTOC(Julian);
  end;

Function CompDates(Date1,Date2 : DateStr):Word;
(* Compare two dates and calculate the number of
 days between them. *)
Begin
  If CTOD(Date1)>CTOD(Date2) then
     CompDates := CTOD(Date1)-CTOD(Date2)
  else
     CompDates := CTOD(Date2)-CTOD(Date1);
End;

Function CMonth(InDate : DateStr) : Str9;
(* Returns the month name for any date. *)

begin
     MM := Copy(InDate,5,2);
     Val(MM,Month,ErrCode);
     CMonth := Months[Month]
end;

Function TimeNow : TimeStr;
(* Returns a formatted string for the current time. *)
Var
   Hour,Minute,Second,Sec100 : Word;
   HH,MM,SS : String[2];
   Temp : String[8];
   Code : Integer;
begin
     GetTime(Hour,Minute,Second,Sec100);
     Str(Minute,MM);
     Str(Second,SS);
     If Minute<10 then MM := '0'+MM;
     If Second<10 then SS := '0'+SS;
     If Hour>12 then
     begin
          Str(Hour-12,HH);
     end
     else Str(Hour,HH);
     If Hour>=12 then TimeNow := HH+':'+MM+':'+SS+' p.m.'
     else TimeNow := HH+':'+MM+':'+SS+' a.m.';
end;

Function Today : DateStr;
(* Returns today's date in dBASE III date format. *)
Var
  mMonth, mDay, mYear, mDayOfWk : Word;
Begin
  GetDate(mYear,mMonth,mDay,mDayOfWk);
  Str(mMonth,MM);
  Str(mDay,DD);
  Str(mYear,YY);
  If mMonth<10 Then insert('0',MM,1);
  If mDay  <10 Then insert('0',DD,1);
  Today := YY+MM+DD;
End;

Function Mon(InDate : DateStr) : Byte;
(* Returns number of month in a date. *)
Var
   Temp : Byte;
begin
     MM := Copy(InDate,5,2);
     Val(MM,Temp,ErrCode);
     Mon := Temp;
end;

Function FormDate(InDate:DateStr):String;
(* Formats dBASE date field as MM/DD/YY *)
Var
	OutDate : String[8];
begin
	OutDate := Copy(InDate,5,2)+'/'+Copy(InDate,7,2)+'/'+Copy(InDate,3,2);
	FormDate := OutDate;
end;

END. (* TPDBDate *)