/*
 Ŀ
  Module....: TBLS2ODB.prg                                                
  Author....: Steve Kolterman  (DataTech Associates, Inc.)                
  Copyright.: Princeton MICRAN Associates, Inc.                           
  Date......: June 1993                                                   
 Ĵ
  Notes.....: 1) Converts existing tables to ObjectDB.                    
              2) Creates utility tables to operate in DD mode.            
 

 NOTO BENE:
 This has been thoroughly tested, but you should backup your app.'s tables
 first anyway!

 The DD tables (TABLES.DBF/COLUMNS.DBF/INDEXES.DBF/FKEYS.DBF/INDXCOLS.DBF)
 are filled with as much data and pertinent defaults as possible, in the
 expectation that you will find it more palatable to delete/change rather
 than add data.

 TABLES.DBF   - will contain all tables.
 COLUMNS.DBF  - will contain all columns.
 INDEXES.DBF  - will contain one record for each table's primary key.
                you will probably need to add others.
 FKEYS.DBF    - will remain empty.  no way to know.
 INDXCOLS.DBF - will contain all columns.  you would delete records (column
                entries) that are not to become parts of indexes.

 Creating the .EXE (with Blinker):
 ---------------------------------
 If your app. is in COMIX or DBFSIX without Flexfile:
 MAKEIT CMX
 - or
 MAKEIT DBFSIX

 If your app. is in COMIX or DBFSIX *with* Flexfile:
 MAKEITFF CMX
 - or
 MAKEITFF DBFSIX

 If your app. is in DBFNTX without Flexfile:
 MAKEIT

 If your app. is in DBFNTX *with* Flexfile:
 MAKEITFF

 Before executing, CD\ to the directory that will hold the DD tables, then:
 TBLS2ODB \somedir\*.dbf

 And yes, if you don't specify a path, the current directory's .DBFs are
 the default.  I would have avoided the need for the wildcard except that
 Brian's going to implement alternate table extensions, hopefully soon. 
 <g>

 The idea at this point, then, is to use the DATADICT.PRG in ODB_DD.ZIP
 (CIS Clipper forum, lib 7 or PMA BBS) against the DD tables.

 Almost forgot to mention...if you pass a second param, anything at all,
 you can bypass creation of the DD tables, performing only the conversion
 of your app.'s tables:
 
 TBLS2ODB \somedir\*.dbf NODD

*/

#include "directry.ch"
#include "dbstruct.ch"

#ifdef CMX
  #include "cmx.ch"
#endif
#ifdef DBFSIX
  #include "dbfsix2.ch"
#endif

#xcomm DEFAULT <p> TO <val> [,<pn> TO <valn>]      =>  ;
         IIF( <p> == NIL, <p> := <val>,) ;
         [; IIF( <pn> == NIL, <pn> := <valn>,) ]

FUNCTION Tbls2Odb( cConvert,cNoDD )
LOCAL nX,aFiles,lRet:= .T.,nLen,lDD
DEFAULT cConvert TO "\"+Curdir()+"\*.dbf"

IF Len((aFiles:= Directory(cConvert))) == 0
   lRet:= .F.
ELSE
#ifdef DBFSIX
  #ifdef DATATECH
    sx_MemoExt(".DTM")
  #endif
#endif
   OutStd("Working...")
   IF (lDD:= (cNoDD==NIL))
      IF !CreateOpenTables()
         ErrMsg("Failure creating DD tables") ; lRet:= .F.
      ENDIF
   ENDIF
ENDIF

IF lRet
   IIF( lDD,dbSelectArea("TABLES"), )
   nLen:= Len(aFiles)
   IF "*." $ cConvert
      cConvert:= Left(cConvert,AT("*",cConvert)-1)
   ENDIF
   FOR nX:= 1 TO nLen
       IF OpenTable(cConvert+aFiles[nX][F_NAME]) 
          IF (aFiles[nX][F_NAME])->( FieldPos("___ODB") ) == 0
             ConvertOdb( cConvert,aFiles[nX][F_NAME] )
          ENDIF
          IF lDD .and. tables->(AddRec())
             tables->table:= Left(aFiles[nX][F_NAME], ;
                                  AT(".",aFiles[nX][F_NAME])-1)
             AddColumns(cConvert,Trim(tables->table))
             tables->( CommitUnLock() )
          ENDIF
          IF lDD .and. indexes->(AddRec())
             indexes->table:= indexes->alias:= tables->table
             indexes->isprimary:= .T.
             indexes->unique:= indexes->case_sens:= .F.
             indexes->order:= " 1"
             indexes->( CommitUnlock() )
          ENDIF
       ENDIF
   NEXT
   OutStd("Finished!")
ENDIF

CLOSE ALL ; QUIT
RETURN NIL

STATIC FUNCTION OpenTable(cTable)
 USE (cTable) NEW EXCLUSIVE
RETURN !Neterr()

STATIC FUNCTION AddRec()
 dbAppend()
RETURN !NetErr()

STATIC FUNCTION TablesStruct()
RETURN { ;
         {"TABLE","C",8,0} ,;
         {"ALIAS","C",10,0},;
         {"DESCR","C",30,0} ;
       }

STATIC FUNCTION ColumnsStruct()
RETURN { ;
         {"TABLE","C",8,0}    ,;
         {"COLUMN","C",10,0}  ,;
         {"TYPE","C",1,0}     ,;
         {"LENGTH","N",4,0}   ,;
         {"DECIMALS","N",4,0} ,;
         {"NOT_NULL","L",1,0} ,;
         {"DESCR","C",30,0}   ,;
         {"TABLE_POS","C",3,0} ;
       }

STATIC FUNCTION IndexesStruct()
RETURN { ;
         {"TABLE","C",8,0}     ,;
         {"ISPRIMARY","L",1,0} ,;
         {"ALIAS","C",10,0}    ,;
         {"UNIQUE","L",1,0}    ,;
         {"CASE_SENS","L",1,0} ,;
         {"ORDER","C",2,0}      ;
       }

STATIC FUNCTION FKeysStruct()
RETURN { ;
         {"TABLE","C",8,0}     ,;
         {"REF_TABLE","C",8,0} ,;
         {"UPD_RULE","C",1,0}  ,;
         {"DEL_RULE","C",1,0}  ,;
         {"USE_INDEX","L",1,0} ,;
         {"ALIAS","C",10,0}    ,;
         {"ORDER","C",2,0}      ;
       }

STATIC FUNCTION IndxColsStruct()
RETURN { ;
         {"TABLE","C",8,0}     ,;
         {"COLUMN","C",10,0}   ,;
         {"SEQUENCE","C",2,0}  ,;
         {"DESCENDING","L",1,0},;
         {"ORDER","C",2,0}      ;
       }

STATIC FUNCTION CreateOpenTables()
LOCAL nX,aTables,lRet:= .T.
aTables:= { {"TABLES",TablesStruct()} ,;
            {"COLUMNS",ColumnsStruct()} ,;
            {"INDEXES",IndexesStruct()} ,;
            {"FKEYS",FkeysStruct()} ,;
            {"INDXCOLS",IndxColsStruct()} }
FOR nX:= 1 TO 5
   dbCreate( aTables[nX][1],aTables[nX][2] )
   IF DosError() > 0
      lRet:= .F. ; EXIT
   ENDIF
   USE (aTables[nX][1]) NEW EXCLUSIVE
   IF NetErr()
      lRet:= .F. ; EXIT
   ENDIF
NEXT
RETURN lRet

STATIC FUNCTION AddColumns(cDir,cTable)
LOCAL nX,nX2,nLen,aStruct
aStruct:= dbStruct(cDir+cTable)
nLen:= Len(aStruct)
FOR nX:= 1 TO nLen
   IF !( Field(nX) == "___ODB" )
      IF columns->( AddRec() )
         columns->table:= cTable
         FOR nX2:= 2 TO 5
             columns->( FieldPut(nX2,aStruct[nX][nX2-1]) )
         NEXT
         columns->table_pos:= PadL( Ltrim(Str(nX)),3 )
         columns->not_null:= .F.
         columns->( CommitUnlock() )
      ENDIF
      IF indxcols->(AddRec())
         indxcols->table:= cTable
         indxcols->column:= aStruct[nX][1]
         indxcols->descending:= .F.
         indxcols->( CommitUnlock() )
      ENDIF
   ENDIF
NEXT
RETURN NIL

STATIC FUNCTION ErrMsg(cMsg,lQuit)
DEFAULT lQuit TO .F.
DispOut(cMsg,"+w/r")
IF lQuit
   CLOSE ALL ; QUIT
ENDIF
RETURN NIL

STATIC FUNCTION CommitUnlock()
 dbCommit() ; dbUnlock()
RETURN NIL

STATIC FUNCTION ConvertOdb(cConvert,cTable)
LOCAL aStruct:= dbStruct(cTable),nRecs:= 0,nTempRecs:= 0,cAlias,cTempf
Aadd( aStruct,{"___ODB","C",3,0} )
cTempf:= "odb"+SUBS(cTable,4)
cAlias:= Alias()
nRecs:= LastRec()
dbCreate(cConvert+cTempf,aStruct)
IF !OpenTable(cConvert+cTempf)
   ErrMsg("Failure opening temporary table",.T.)
ENDIF
CLOSE (cAlias)
APPEND FROM (cConvert+cTable)
nTempRecs:= LastRec()
IF NetErr() .or. (nTempRecs <> nRecs)
   ErrMsg("Failure creating converted file",.T.)
ENDIF
CLOSE
Ferase(cConvert+cTable)
FRename( cConvert+cTempf,cConvert+cTable )
OpenTable( cConvert+cTable )
RETURN NIL
