* Module Name ..... TOUCH.PRG 
* Author's Name ... D.B. McDonald  [ CIS 76334,3521 ] 
* Date Created .... 4/25/1993 at 14:53
*
*.............................................................................
*
* Executable........
*    TOUCH.EXE
*
* Description .....
*    Changes the date and time attributes of files.
*
* Syntax ..........
*    TOUCH <file spec> -d[<date>] -t[<time>] -n -v 
*
* Parameters ......
*    <file spec>  -->  a file name or a file specification using wildcard
*                      characters '?' and '*'
*    -d[<date>]   -->  change file date using format mm/dd/yy
*    -t[<time>]   -->  change file time using format hh:mm:ss
*    -n           -->  change file date and time to NOW          
*    -v           -->  verbose output in format oldfile --> newfile
*    -h           -->  help screen
*    //info       -->  enhanced Clipper Information screen
*
* Returns .........
*    DOS errorlevel codes:
*       == 0  --> Successful completion
*        > 0  --> number of files unsuccessfully changed (max255)
*
* Examples ........
*    touch *.prg -d09/12/92 -t18:00   
*
* Notes ...........
*    Requires Clipper Tools, version 3.0
*    Linked using Blinker 2.0 or RTLINK
*
*    If linking with RTLink this file must be compiled using the
*    Clipper option /dRTLINK
*
* See Also ........
*
*.............................................................................
* Revision: 1.00.00 Last Revised: 4/25/1993 at 14:53
* Description: Original Creation.
*.............................................................................
*
* Public Domain Version
*
*-----------------------------------------------------------------------------
#include "blinker2.ch"

//... Assume linking via the Blinker 2.0 linker unless
//... RTLINK is defined
#ifndef RTLINK
  request Blinker2
#else
  request RTLink
#endif

* -------------------------------------------------------------------------- *
Procedure Startup( fileSpec )
* -------------------------------------------------------------------------- *
  local cArg := lower( dosParam() )

  if ( '//info' $ cArg )
     t_Info()
  elseif ( '//?' $ cArg )
     t_Syntax()
  else
     t_Execute( fileSpec )
  endif

return

