;Tone.asm
;
;  This routine is designed for use with the Nantucket Clipper compiler,
; Winter '85 (January '86) version.  It was written by Eric Engelmann,
; at a time when he didn't know much about assembly language.  The calling
; routine must do a large portion of the work for this program, by 
; sending in two parameters.  Each of these must be two character strings.
; These strings are interpreted by this routine as a pitch for a tone, 
; and as the tone's duration.  If anyone has the knowledge/ambition to 
; convert this so that the calling routine can pass in floating point
; numbers, I would appreciate it if you would send me the source code.
;
; Example useage: (this tone will be of different lengths on different 
;  machines because they have different speeds at getting through the
;  kill-time loops in this routine) Be carefull not to pass any null
;  strings (chr(0)).
;
; * Call tone generator with 1190000/(1+(3*256)) hertz tone selected,
; *  and a medium long duration.
; Call tone with chr(1)+chr(3), chr(1)+chr(100)
;
;
;
;
; July 1, 1986
; Eric Engelmann, Technical Director, EMS, A microcomputer consulting
;  company located at:
; 11701 Karen Drive
; Potomac, MD 20854
; (301) 299-9239
;
;
;
TITLE Tone    
;
;
;
_Prog   SEGMENT BYTE              ;This is the standard Clipper stuff.
        ASSUME  CS:_Prog                       
        PUBLIC  Tone    

Tone    PROC    FAR                    
        PUSH    BP
        MOV     BP,SP
        PUSH    DS
        PUSH    ES
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                       M A I N   P R O G R A M
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        LDS     SI,[BP+6]          ;DS now contains the segment 
                                   ; of the passed tone, and SI 
                                   ; contains the offset.

;
; Generate a tone. 
;
        MOV     AL,0B6H
        OUT     43H,AL                      
;
;
        MOV     AX,[SI]   

        OUT     42H,AL
        MOV     AL,AH
        OUT     42H,AL

        IN      AL,61H
         
        MOV     AH,AL
        OR      AL,3
        OUT     61H,AL

        LDS     SI,[BP+10]              ; DS now contains the segment
                                        ; of the passed tone duration,
                                        ; and SI contains the offset.
                              ;Now kill time until the tone is finished.
        MOV     CX,[SI]       ;Delay counter is the second of the 
loop1:  LOOP    loop1         ; passed variables.  (This is just a sloppy,
        MOV     CX,[SI]       ; but easy way for me to code, way of 
                              ; killing time while the tone is played.
loop2:  LOOP    loop2        
        MOV     CX,[SI]
loop3:  LOOP    loop3 
        MOV     CX,[SI]
loop4:  LOOP    loop4 
        MOV     CX,[SI]
loop5:  LOOP    loop5 
        MOV     CX,[SI]
loop6:  LOOP    loop6 
        

                                ;Restore speaker to its previous value.
        MOV     AL,AH
        OUT     61H,AL



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                       C L E A N   U P
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        POP     ES               ;This is the standard Clipper cleanup
        POP     DS               ; prior to return to the calling program.
        POP     BP

        RET                             
Tone    ENDP
_Prog   ENDS
        END
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
