* readtime.prg
* Andrew Schulman 11/29/86

parameter datetime
* either date (example: do readtime with date() + .75)
* or numeric variable (example:  do readtime with 2446764.5)
* though usually parameter will be variable created by maketime.prg

basedate = ctod("11/29/86") - 2446764
* 2446764 is Julian period number for 29 November 1986
* subtracting Julian period number from its date creates a date variable
* corresponding to the number zero (1 Jan. 4713 b.c.)
* dBase won't display BASEDATE properly, but it's fine in calculations
* SYMDEB DL command can be used to verify that it really is zero

if type("datetime") = "D"
   julian = datetime - basedate
else  && if type("datetime") = "N"
   julian = datetime
   if julian >= 1 .and. julian <= 73050  && if it's probably a Lotus date...
      julian = julian + 2415019          && ...convert to dBase III date
   endif
endif
* create Julian period numeric variable from date variable datetime
* or if datetime is already numeric, just make our copy of it
* Lotus:  the two months before 1 March 1900 are off by one because of a
* bug in Lotus date arithmetic, which thinks 1900 is a leap year (it's not)

mdate = int(julian)
mtime = julian - mdate   && time is fractional part of date

public ddate, time_str   && public in case they want to use them
ddate = basedate + mdate

do case
   case mtime = 0        && no time was attached: regular date variable
      time_str = ""
   case mtime > 0.9997 .or. mtime < 0.0010
      time_str = "'round midnight"
   otherwise
      hrs = mtime / (1 / 24)
      mins = (hrs - int(hrs)) * 60
      hrs = int(hrs)

      mins_str = iif(mins < 10, "0" + str(mins,1,0), str(mins,2,0))
      * if you don't have dBase III Plus's iif(), use if-else-endif

      time_str = str( iif(hrs <= 12, hrs, hrs - 12), 2, 0 ) + ":" + ;
                 mins_str + iif(hrs < 12, "am", "pm")
      * if you don't have dBase III Plus's iif(), use this instead:
      *   if hrs < 12
      *       time_str = str(hrs,2,0) + ":" + mins_str + "am"
      *   else
      *      if hrs = 12
      *         time_str = str(hrs,2,0) + ":" + mins_str + "pm"
      *      else if hrs > 12
      *         time_str = str(hrs - 12,2,0) + ":" + mins_str + "pm"
      *      endif
      *   endif
      * or, if you actually LIKE 24-hour "military" time, substitute the
      * following which does simplify things:
      *    time_str = str(hrs,2,0) + ":" + mins_str
      * YUK!  "military time is to time as military music to music"
endcase

if julian < 2415386 .or. julian > 2451545   && < 1 Jan 1901 or > 31 Dec 1999
   set century on
endif

? ddate
?? "  " + time_str
return
