* maketime.prg
* Andrew Schulman 11/28/86

parameter mdate, timestr, var
* mdate = date in date, num, or string form
* timestr = string in form of time() except that secs optional, e.g., "18:12"
* var = existing variable you want to hold date/time information
* if var is num, output is num variable, otherwise output is date variable
* Example:    now = ""
*             do maketime with date(),time(),now
* or:         then = 0
*             do maketime with "12/31/1999","23:59",then
* to read:    do readtime with then
* or:         now = ""
*             do maketime with 0,time(),now

dHOUR = 1 / 24
dMIN = dHOUR / 60

colon = at(":", timestr)
if colon > 1
   mtime = (val(substr(timestr,1,colon - 1)) * dHOUR) + ;
           (val(substr(timestr,colon + 1,2)) * dMIN)
else
   mtime = 0
endif

basedate = ctod("11/29/86") - 2446764
* see readtime.prg for explanation

mtype = type("mdate")
do case
   case mtype = "C"
      mmdate = ctod(mdate)
   case mtype = "D"
      mmdate = mdate
   case mtype = "N"
      if mdate >= 1 .and. mdate <= 73050  && must be Lotus-style date
         mdate = mdate + 2415019          && so convert to dBase format
      endif
      mmdate = basedate + mdate
endcase
* do any necessary conversions

if type("var") = "N"
   var = (mmdate + mtime) - basedate
else
   var = mmdate + mtime
endif
* if parameter is numeric, give them the Julian period number back
* otherwise, give them a date variable

return





