
.286

extrn alarm_go:byte
extrn dosinit:byte
extrn save1c:word
extrn time_format:byte
extrn time_x:byte
extrn time_y:byte
extrn idle_active:byte
extrn dosbusy:word

extrn alarm_func:far
extrn time_int21:far               ; 4CH handler   
extrn __RETNI:far                  ; CLIPPER routine for return code
extrn __PARC:far                   ; CLIPPER routine to return parmater string
extrn __chk_sym:far
extrn __parinfo:far
extrn __parni:far


         public timefunc           ; make this routine public
	 public timeoff             
	 public int1c

	DGROUP group dseg
	CGROUP group cseg

dseg	segment 'data'

save_func	dw 0,0
timer_cnt	dw 0
timer_cnt1      dw 0
busy_flag       db 0
pending		db 0

time_busy	db 0	
time_hh		db 0
time_mm		db 0
time_ss		db 0

time_blink	db ':'

alarm_busy	db 0

dseg	ends

cseg segment 'code'

   assume cs:CGROUP,ds:DGROUP

timefunc proc far

	enter 0,0
	  
	pusha
	push ds
	push es

	push 0			  ; # of params
	call __parinfo
	add sp,2

	cmp ax,2
	je   id_001
	mov ax,1
	jmp id_ret

id_001:

	push 1
	call __parinfo
	add sp,2

	cmp ax,1
	je id_002
	mov ax,2
	jmp id_ret

id_002:

	push 2
	call __parinfo
	add sp,2

	cmp ax,2
	je id_003
	mov ax,3
	jmp id_ret

id_003:

	 push 1	                  ; first param = func name
	 call __PARC	          ; address returned in DX:AX
	 add sp,2	          ; restore stack

	 push dx		  ; save it
	 push ax

	 call __chk_sym           ; check that it exists
	 add sp,4

	 or dx,dx                 ; found
	 jnz id_004
	 mov ax,4
	 jmp id_ret

id_004:

	 mov es,dx
	 mov bx,ax

	 mov ax,word ptr es:[bx+14]
	 mov save_func,ax
	 mov ax,word ptr es:[bx+16]
	 mov save_func+2,ax

	 push 2	                  ; second param = interval
	 call __PARNI	          ; value in AX
	 add sp,2	          ; restore stack

	 mov cl,18
	 mul cl                ; up by 18
	 mov timer_cnt,ax         ; save it
	 mov timer_cnt1,ax

	cmp dosinit,0            ; set up the exit routine
	jne id_005		 ; no

; now  get int 1c save it and point to ours

	mov ah,35h
	mov al,1ch
	int 21h

	mov save1c,bx
	mov save1c+2,es

	push ds

	push cs
	pop  ds
	mov dx,offset CGROUP:int1c
	mov ah,25h
	mov al,1ch
	int 21h

	pop ds
	mov ah,34h                ; get busy flag  
	int 21h

	mov dosbusy,bx
	mov dosbusy+2,es
	

	call time_int21          ; no. go do it

id_005:

	mov idle_active,1        ; were active
	mov ax,0                 ; worked ok

id_ret:
	 push ax		  ; ax has return code
	 call __RETNI	          ; pass it back to CLIPPER
	 add sp,2	          ; restore stack


	pop es
	pop ds
	popa
         leave			  ; restore registers

	 ret		          ; return to CLIPPER

timefunc endp

timeoff	proc	far


	mov idle_active,0       ; switch timefunc off

	push 0	
	call __RETNI	          ; pass it back to CLIPPER
	add sp,2	          ; restore stack

	ret

timeoff	endp
;
;   new int1c handler
;

int1c:

	sti

	pusha
	push es
	push ds

	mov ax,DGROUP
	mov ds,ax

	pushf
	call dword ptr save1c     ; call the old one

	cmp alarm_go,1		  ; time to wake up
	jne int1c_time_check	  ; no

	cmp alarm_busy,0	  ; already calling
	jne int1c_time_check	  ; yes

	les bx,dword ptr dosbusy  ;
	cmp byte ptr es:[bx],0	  ; dos busy
	jne int1c_time_check	  ; yes

	mov alarm_busy,1	  ; were off
	mov alarm_go,0		  ; reset for next 24 hour period

	call dword ptr alarm_func ; do it

	mov alarm_busy,0	  ; not busy anymore

int1c_time_check:

	cmp time_format,0	; clock display active
	jne int1c_tf001		; yes

int1c_go:

	jmp int1c_timefunc      ; check if timefunc is active

int1c_tf001:

	cmp time_busy,0        	; timer routine active
	jne  int1c_go		; yes

	mov time_busy,1		; dont interrupt me

	mov ah,02h
	int 1ah

	cmp ch,time_hh		; any change in hours
	jne int1c_tf003		; yes

	cmp cl,time_mm		; any change in minutes
	jne int1c_tf003		; yes

	cmp dh,time_ss		; any change in seconds
	jne int1c_tf003		; yes

	mov time_busy,0         ; re activate
	jmp int1c_timefunc      ; check the idle func

int1c_tf003:

	mov time_hh,ch          ; save the new time     
	mov time_mm,cl
	mov time_ss,dh

	mov ax,0B800h          	; video buffer address
	mov es,ax


	xor ch,ch
	xor bh,bh
	mov ax,160
	mov cl,time_y
	mul cx
	mov bl,time_x
	shl bx,1
	add ax,bx
	mov di,ax               ; ES:DI noe point to the start adress


	call format_hh
	call format_mm
	call format_ss

	mov time_busy,0          

int1c_timefunc:

	cmp idle_active,0	; time func active
	je  int1c_out           ; no just get out 

	cmp pending,1           ; pending a call
	je int1c_001

	cmp busy_flag,1
	je int1c_out

	dec word ptr timer_cnt
	jnz int1c_out

	mov pending,1

int1c_001:

	les bx,dword ptr dosbusy
	cmp byte ptr es:[bx],0
	jne int1c_out

	mov pending,0

	mov busy_flag,1

	mov ax,timer_cnt1
	mov timer_cnt,ax

	call dword ptr save_func

	mov busy_flag,0

int1c_out:

	pop ds
	pop es
	popa

	iret

;
; format the hours portion
;

format_hh	proc	near

	mov al,time_hh
	cmp time_format,3
	jne fhh_001
	cmp al,12h
	jbe fhh_001
	sub al,12h

fhh_001:

	push ax
	shr al,4
	add al,30h
	cmp time_format,3
	jne fhh_002
	cmp al,30h
	jne fhh_002
	mov al,' '

fhh_002:
	stosb
	inc di
	pop ax
	and al,0fh
	add al,30h
	stosb
	inc di


	mov al,time_blink
	stosb
	inc di
	cmp time_format,2
	je fhh_ret
	xor time_blink,':'
fhh_ret:
	ret

format_hh	endp
format_mm	proc	near


	mov al,time_mm
	call proc_byte

	cmp time_format,2
	jne fmm_ret
	mov al,':'
	stosb
	inc di
fmm_ret:
	
	ret

format_mm	endp
format_ss	proc	near

	cmp time_format,1
	je fss_ret
	
	cmp time_format,2
	je fss_001

	mov al,' '
	stosb
	inc di

	mov bl,time_hh
	mov al,'a'
	cmp bl,12h
	jbe fss_000
	mov al,'p'
fss_000:
	stosb
	inc di
	mov al,'m'
	stosb
	jmp short fss_ret


fss_001:

	mov al,time_ss
	call proc_byte

fss_ret:

	ret

format_ss	endp

;
;  take a byte in al and store it at es:di
;
proc_byte	proc near


	push ax
	shr al,4
	add al,30h
	stosb
	inc di
	pop ax
	and al,0fh
	add al,30h
	stosb
	inc di

	ret
proc_byte	endp
cseg ends


      end  
