;
;  clock display function.
;  usage :
;     clock(x,y,format)
;     x = x pos. relative to 0
;     y = y pos. relative to 0
;     format 1 = "hh:mm"       07:34
;            2 =  "hh:mm:ss"   07:34:34
;            3 =  "h:mm"       7:34 am
;

.286
extrn dosinit:byte
extrn save1c:word
extrn idle_active:byte
extrn dosbusy:word

extrn int1c:far
extrn time_int21:far               ; 4CH handler   
extrn __RETNI:far                  ; CLIPPER routine for return code
extrn __PARC:far                   ; CLIPPER routine to return parmater string
extrn __parinfo:far
extrn __parni:far

extrn time_format:byte
extrn time_x:byte
extrn time_y:byte

         public clock_on
	 public clock_off             

	DGROUP group dseg
	CGROUP group cseg

dseg	segment 'data'

time_save	db 16 dup(0)  ; maximum save area

dseg	ends

cseg segment 'code'

   assume cs:CGROUP,ds:DGROUP

; hook inti int 1c, if we haven't already
; validate the passed params then go
;

clock_on	proc	far

	
	enter 0,0
	  
	pusha
	push ds
	push es

	push 0			  ; # of params
	call __parinfo
	add sp,2

	cmp ax,3		  ; should be three
	je   co_001
	mov ax,1
	jmp co_ret

co_001:

	push 1			  ; get parameter 1 type
	call __parinfo
	add sp,2

	cmp ax,2		  ; numeric ?
	je co_002		  ; yes
	mov ax,2
	jmp co_ret

co_002:

	push 2
	call __parinfo
	add sp,2

	cmp ax,2
	je co_003
	mov ax,3
	jmp co_ret

co_003:



	push 3
	call __parinfo
	add sp,2

	cmp ax,2		   ; numeric
	je co_003b		   ; yes
	mov ax,3
	jmp co_ret


co_003b:

	cmp time_format,0          ; clock already on
	je  co_004

	call far ptr clock_off

co_004:

	 push 1	                  ; first param = x pos
	 call __PARNI	          ; value in AX
	 add sp,2	          ; restore stack

	 mov time_x,al            ; save it

	 push 2	                  ; second param = y pos
	 call __PARNI	          ; value in AX
	 add sp,2	          ; restore stack

	 mov time_y,al            ; save it

	 push 3	                  ; third param = format
	 call __PARNI	          ; value returned in AX
	 add sp,2	          ; restore stack

	 mov time_format,al       ; save it

	 push ds		
	 pop  es
	 mov di,offset DGROUP:time_save


	xor ch,ch
	xor bh,bh
	mov ax,160
	mov cl,time_y
	mul cx
	mov bl,time_x
	shl bx,1
	add ax,bx
	mov si,ax               ; DS:SI now points to the start adress
	mov cx,8
	mov ax,0B800h          	; video buffer address
	mov ds,ax

rep	movsw			; save screen


	push es
	pop ds

	cmp dosinit,0            ; int1c already set up ?
	jne co_005		 ; yes

	mov ah,35h
	mov al,1ch
	int 21h

	mov save1c,bx
	mov save1c+2,es

	push ds

	push cs
	pop  ds
	mov dx,offset CGROUP:int1c
	mov ah,25h
	mov al,1ch
	int 21h

	pop ds
	mov ah,34h                ; get busy flag  
	int 21h

	mov dosbusy,bx
	mov dosbusy+2,es
	
	call time_int21          ; set up the exit routine

co_005:
	
	mov ax,0

co_ret:

	 push ax		  ; ax has return code
	 call __RETNI	          ; pass it back to CLIPPER
	 add sp,2	          ; restore stack


	pop es
	pop ds
	popa
         leave			  ; restore registers

	 ret		          ; return to CLIPPER


clock_on	endp


clock_off	proc far

	pusha
	push es
	push ds


	mov time_format,0	; also restore the screen

	mov ax,0B800h          	; video buffer address
	mov es,ax

	xor ch,ch
	xor bh,bh
	mov ax,160
	mov cl,time_y
	mul cx
	mov bl,time_x
	shl bx,1
	add ax,bx
	mov di,ax               ; ES:DI noe point to the start adress
	mov cx,8
	mov si,offset DGROUP:time_save

rep	movsw			; save screen

	pop ds
	pop es
	popa

	ret

clock_off	endp
cseg	ends
	end
